/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Matches;
import org.apache.lucene.search.MatchesIterator;
import org.apache.lucene.search.PhraseMatcher;
import org.apache.lucene.search.PhraseScorer;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.Similarity;

abstract class PhraseWeight
extends Weight {
    final boolean needsScores;
    final Similarity.SimWeight stats;
    final Similarity similarity;
    final String field;

    protected PhraseWeight(Query query, String field2, IndexSearcher searcher, boolean needsScores) throws IOException {
        super(query);
        this.needsScores = needsScores;
        this.field = field2;
        this.similarity = searcher.getSimilarity(needsScores);
        this.stats = this.getStats(searcher);
    }

    protected abstract Similarity.SimWeight getStats(IndexSearcher var1) throws IOException;

    protected abstract PhraseMatcher getPhraseMatcher(LeafReaderContext var1, boolean var2) throws IOException;

    @Override
    public Scorer scorer(LeafReaderContext context) throws IOException {
        PhraseMatcher matcher2 = this.getPhraseMatcher(context, false);
        if (matcher2 == null) {
            return null;
        }
        Similarity.SimScorer simScorer = this.similarity.simScorer(this.stats, context);
        return new PhraseScorer(this, matcher2, this.needsScores, simScorer);
    }

    @Override
    public Explanation explain(LeafReaderContext context, int doc) throws IOException {
        PhraseMatcher matcher2 = this.getPhraseMatcher(context, false);
        if (matcher2 == null || matcher2.approximation.advance(doc) != doc) {
            return Explanation.noMatch("no matching terms", new Explanation[0]);
        }
        matcher2.reset();
        if (!matcher2.nextMatch()) {
            return Explanation.noMatch("no matching phrase", new Explanation[0]);
        }
        Similarity.SimScorer simScorer = this.similarity.simScorer(this.stats, context);
        float freq2 = matcher2.sloppyWeight(simScorer);
        while (matcher2.nextMatch()) {
            freq2 += matcher2.sloppyWeight(simScorer);
        }
        Explanation freqExplanation = Explanation.match(freq2, "phraseFreq=" + freq2, new Explanation[0]);
        Explanation scoreExplanation = simScorer.explain(doc, freqExplanation);
        return Explanation.match(scoreExplanation.getValue(), "weight(" + this.getQuery() + " in " + doc + ") [" + this.similarity.getClass().getSimpleName() + "], result of:", scoreExplanation);
    }

    @Override
    public Matches matches(LeafReaderContext context, int doc) throws IOException {
        return Matches.forField(this.field, () -> {
            final PhraseMatcher matcher2 = this.getPhraseMatcher(context, true);
            if (matcher2 == null || matcher2.approximation.advance(doc) != doc) {
                return null;
            }
            matcher2.reset();
            if (!matcher2.nextMatch()) {
                return null;
            }
            return new MatchesIterator(){
                boolean started = false;

                @Override
                public boolean next() throws IOException {
                    if (!this.started) {
                        this.started = true;
                        return true;
                    }
                    return matcher2.nextMatch();
                }

                @Override
                public int startPosition() {
                    return matcher2.startPosition();
                }

                @Override
                public int endPosition() {
                    return matcher2.endPosition();
                }

                @Override
                public int startOffset() throws IOException {
                    return matcher2.startOffset();
                }

                @Override
                public int endOffset() throws IOException {
                    return matcher2.endOffset();
                }
            };
        });
    }

    @Override
    public boolean isCacheable(LeafReaderContext ctx) {
        return true;
    }
}

