/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.lucene.search.DisjunctionMatchesIterator;
import org.apache.lucene.search.MatchesIterator;

public interface Matches
extends Iterable<String> {
    public static final Matches MATCH_WITH_NO_TERMS = new Matches(){

        @Override
        public Iterator<String> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public MatchesIterator getMatches(String field2) {
            return null;
        }
    };

    public MatchesIterator getMatches(String var1) throws IOException;

    public static Matches fromSubMatches(List<Matches> subMatches) {
        if (subMatches == null || subMatches.size() == 0) {
            return null;
        }
        final List sm = subMatches.stream().filter(m -> m != MATCH_WITH_NO_TERMS).collect(Collectors.toList());
        if (sm.size() == 0) {
            return MATCH_WITH_NO_TERMS;
        }
        if (sm.size() == 1) {
            return (Matches)sm.get(0);
        }
        return new Matches(){

            @Override
            public MatchesIterator getMatches(String field2) throws IOException {
                ArrayList<MatchesIterator> subIterators = new ArrayList<MatchesIterator>(sm.size());
                for (Matches m : sm) {
                    MatchesIterator it = m.getMatches(field2);
                    if (it == null) continue;
                    subIterators.add(it);
                }
                return DisjunctionMatchesIterator.fromSubIterators(subIterators);
            }

            @Override
            public Iterator<String> iterator() {
                return sm.stream().flatMap(m -> StreamSupport.stream(m.spliterator(), false)).distinct().iterator();
            }
        };
    }

    public static Matches forField(final String field2, final MatchesIteratorSupplier mis) throws IOException {
        final MatchesIterator mi = mis.get();
        if (mi == null) {
            return null;
        }
        return new Matches(){
            boolean cached = true;

            @Override
            public MatchesIterator getMatches(String f2) throws IOException {
                if (!Objects.equals(field2, f2)) {
                    return null;
                }
                if (!this.cached) {
                    return mis.get();
                }
                this.cached = false;
                return mi;
            }

            @Override
            public Iterator<String> iterator() {
                return Collections.singleton(field2).iterator();
            }
        };
    }

    @FunctionalInterface
    public static interface MatchesIteratorSupplier {
        public MatchesIterator get() throws IOException;
    }
}

