/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.ScoreCachingWrappingScorer;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SimpleFieldComparator;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;

public abstract class FieldComparator<T> {
    public abstract int compare(int var1, int var2);

    public abstract void setTopValue(T var1);

    public abstract T value(int var1);

    public abstract LeafFieldComparator getLeafComparator(LeafReaderContext var1) throws IOException;

    public int compareValues(T first, T second) {
        if (first == null) {
            if (second == null) {
                return 0;
            }
            return -1;
        }
        if (second == null) {
            return 1;
        }
        return ((Comparable)first).compareTo(second);
    }

    public static class TermValComparator
    extends FieldComparator<BytesRef>
    implements LeafFieldComparator {
        private final BytesRef[] values;
        private final BytesRefBuilder[] tempBRs;
        private BinaryDocValues docTerms;
        private final String field;
        private BytesRef bottom;
        private BytesRef topValue;
        private final int missingSortCmp;

        public TermValComparator(int numHits, String field2, boolean sortMissingLast) {
            this.values = new BytesRef[numHits];
            this.tempBRs = new BytesRefBuilder[numHits];
            this.field = field2;
            this.missingSortCmp = sortMissingLast ? 1 : -1;
        }

        private BytesRef getValueForDoc(int doc) throws IOException {
            if (this.docTerms.advanceExact(doc)) {
                return this.docTerms.binaryValue();
            }
            return null;
        }

        @Override
        public int compare(int slot1, int slot2) {
            BytesRef val1 = this.values[slot1];
            BytesRef val2 = this.values[slot2];
            return this.compareValues(val1, val2);
        }

        @Override
        public int compareBottom(int doc) throws IOException {
            BytesRef comparableBytes = this.getValueForDoc(doc);
            return this.compareValues(this.bottom, comparableBytes);
        }

        @Override
        public void copy(int slot, int doc) throws IOException {
            BytesRef comparableBytes = this.getValueForDoc(doc);
            if (comparableBytes == null) {
                this.values[slot] = null;
            } else {
                if (this.tempBRs[slot] == null) {
                    this.tempBRs[slot] = new BytesRefBuilder();
                }
                this.tempBRs[slot].copyBytes(comparableBytes);
                this.values[slot] = this.tempBRs[slot].get();
            }
        }

        protected BinaryDocValues getBinaryDocValues(LeafReaderContext context, String field2) throws IOException {
            return DocValues.getBinary(context.reader(), field2);
        }

        @Override
        public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
            this.docTerms = this.getBinaryDocValues(context, this.field);
            return this;
        }

        @Override
        public void setBottom(int bottom) {
            this.bottom = this.values[bottom];
        }

        @Override
        public void setTopValue(BytesRef value2) {
            this.topValue = value2;
        }

        @Override
        public BytesRef value(int slot) {
            return this.values[slot];
        }

        @Override
        public int compareValues(BytesRef val1, BytesRef val2) {
            if (val1 == null) {
                if (val2 == null) {
                    return 0;
                }
                return this.missingSortCmp;
            }
            if (val2 == null) {
                return -this.missingSortCmp;
            }
            return val1.compareTo(val2);
        }

        @Override
        public int compareTop(int doc) throws IOException {
            return this.compareValues(this.topValue, this.getValueForDoc(doc));
        }

        @Override
        public void setScorer(Scorer scorer) {
        }
    }

    public static class TermOrdValComparator
    extends FieldComparator<BytesRef>
    implements LeafFieldComparator {
        final int[] ords;
        final BytesRef[] values;
        private final BytesRefBuilder[] tempBRs;
        final int[] readerGen;
        int currentReaderGen = -1;
        SortedDocValues termsIndex;
        private final String field;
        int bottomSlot = -1;
        int bottomOrd;
        boolean bottomSameReader;
        BytesRef bottomValue;
        BytesRef topValue;
        boolean topSameReader;
        int topOrd;
        final int missingSortCmp;
        final int missingOrd;

        public TermOrdValComparator(int numHits, String field2) {
            this(numHits, field2, false);
        }

        public TermOrdValComparator(int numHits, String field2, boolean sortMissingLast) {
            this.ords = new int[numHits];
            this.values = new BytesRef[numHits];
            this.tempBRs = new BytesRefBuilder[numHits];
            this.readerGen = new int[numHits];
            this.field = field2;
            if (sortMissingLast) {
                this.missingSortCmp = 1;
                this.missingOrd = Integer.MAX_VALUE;
            } else {
                this.missingSortCmp = -1;
                this.missingOrd = -1;
            }
        }

        private int getOrdForDoc(int doc) throws IOException {
            if (this.termsIndex.advanceExact(doc)) {
                return this.termsIndex.ordValue();
            }
            return -1;
        }

        @Override
        public int compare(int slot1, int slot2) {
            if (this.readerGen[slot1] == this.readerGen[slot2]) {
                return this.ords[slot1] - this.ords[slot2];
            }
            BytesRef val1 = this.values[slot1];
            BytesRef val2 = this.values[slot2];
            if (val1 == null) {
                if (val2 == null) {
                    return 0;
                }
                return this.missingSortCmp;
            }
            if (val2 == null) {
                return -this.missingSortCmp;
            }
            return val1.compareTo(val2);
        }

        @Override
        public int compareBottom(int doc) throws IOException {
            assert (this.bottomSlot != -1);
            int docOrd = this.getOrdForDoc(doc);
            if (docOrd == -1) {
                docOrd = this.missingOrd;
            }
            if (this.bottomSameReader) {
                return this.bottomOrd - docOrd;
            }
            if (this.bottomOrd >= docOrd) {
                return 1;
            }
            return -1;
        }

        @Override
        public void copy(int slot, int doc) throws IOException {
            int ord = this.getOrdForDoc(doc);
            if (ord == -1) {
                ord = this.missingOrd;
                this.values[slot] = null;
            } else {
                assert (ord >= 0);
                if (this.tempBRs[slot] == null) {
                    this.tempBRs[slot] = new BytesRefBuilder();
                }
                this.tempBRs[slot].copyBytes(this.termsIndex.lookupOrd(ord));
                this.values[slot] = this.tempBRs[slot].get();
            }
            this.ords[slot] = ord;
            this.readerGen[slot] = this.currentReaderGen;
        }

        protected SortedDocValues getSortedDocValues(LeafReaderContext context, String field2) throws IOException {
            return DocValues.getSorted(context.reader(), field2);
        }

        @Override
        public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
            this.termsIndex = this.getSortedDocValues(context, this.field);
            ++this.currentReaderGen;
            if (this.topValue != null) {
                int ord = this.termsIndex.lookupTerm(this.topValue);
                if (ord >= 0) {
                    this.topSameReader = true;
                    this.topOrd = ord;
                } else {
                    this.topSameReader = false;
                    this.topOrd = -ord - 2;
                }
            } else {
                this.topOrd = this.missingOrd;
                this.topSameReader = true;
            }
            if (this.bottomSlot != -1) {
                this.setBottom(this.bottomSlot);
            }
            return this;
        }

        @Override
        public void setBottom(int bottom) throws IOException {
            this.bottomSlot = bottom;
            this.bottomValue = this.values[this.bottomSlot];
            if (this.currentReaderGen == this.readerGen[this.bottomSlot]) {
                this.bottomOrd = this.ords[this.bottomSlot];
                this.bottomSameReader = true;
            } else if (this.bottomValue == null) {
                assert (this.ords[this.bottomSlot] == this.missingOrd);
                this.bottomOrd = this.missingOrd;
                this.bottomSameReader = true;
                this.readerGen[this.bottomSlot] = this.currentReaderGen;
            } else {
                int ord = this.termsIndex.lookupTerm(this.bottomValue);
                if (ord < 0) {
                    this.bottomOrd = -ord - 2;
                    this.bottomSameReader = false;
                } else {
                    this.bottomOrd = ord;
                    this.bottomSameReader = true;
                    this.readerGen[this.bottomSlot] = this.currentReaderGen;
                    this.ords[this.bottomSlot] = this.bottomOrd;
                }
            }
        }

        @Override
        public void setTopValue(BytesRef value2) {
            this.topValue = value2;
        }

        @Override
        public BytesRef value(int slot) {
            return this.values[slot];
        }

        @Override
        public int compareTop(int doc) throws IOException {
            int ord = this.getOrdForDoc(doc);
            if (ord == -1) {
                ord = this.missingOrd;
            }
            if (this.topSameReader) {
                return this.topOrd - ord;
            }
            if (ord <= this.topOrd) {
                return 1;
            }
            return -1;
        }

        @Override
        public int compareValues(BytesRef val1, BytesRef val2) {
            if (val1 == null) {
                if (val2 == null) {
                    return 0;
                }
                return this.missingSortCmp;
            }
            if (val2 == null) {
                return -this.missingSortCmp;
            }
            return val1.compareTo(val2);
        }

        @Override
        public void setScorer(Scorer scorer) {
        }
    }

    public static final class DocComparator
    extends FieldComparator<Integer>
    implements LeafFieldComparator {
        private final int[] docIDs;
        private int docBase;
        private int bottom;
        private int topValue;

        public DocComparator(int numHits) {
            this.docIDs = new int[numHits];
        }

        @Override
        public int compare(int slot1, int slot2) {
            return this.docIDs[slot1] - this.docIDs[slot2];
        }

        @Override
        public int compareBottom(int doc) {
            return this.bottom - (this.docBase + doc);
        }

        @Override
        public void copy(int slot, int doc) {
            this.docIDs[slot] = this.docBase + doc;
        }

        @Override
        public LeafFieldComparator getLeafComparator(LeafReaderContext context) {
            this.docBase = context.docBase;
            return this;
        }

        @Override
        public void setBottom(int bottom) {
            this.bottom = this.docIDs[bottom];
        }

        @Override
        public void setTopValue(Integer value2) {
            this.topValue = value2;
        }

        @Override
        public Integer value(int slot) {
            return this.docIDs[slot];
        }

        @Override
        public int compareTop(int doc) {
            int docValue = this.docBase + doc;
            return Integer.compare(this.topValue, docValue);
        }

        @Override
        public void setScorer(Scorer scorer) {
        }
    }

    public static final class RelevanceComparator
    extends FieldComparator<Float>
    implements LeafFieldComparator {
        private final float[] scores;
        private float bottom;
        private Scorer scorer;
        private float topValue;

        public RelevanceComparator(int numHits) {
            this.scores = new float[numHits];
        }

        @Override
        public int compare(int slot1, int slot2) {
            return Float.compare(this.scores[slot2], this.scores[slot1]);
        }

        @Override
        public int compareBottom(int doc) throws IOException {
            float score = this.scorer.score();
            assert (!Float.isNaN(score));
            return Float.compare(score, this.bottom);
        }

        @Override
        public void copy(int slot, int doc) throws IOException {
            this.scores[slot] = this.scorer.score();
            assert (!Float.isNaN(this.scores[slot]));
        }

        @Override
        public LeafFieldComparator getLeafComparator(LeafReaderContext context) {
            return this;
        }

        @Override
        public void setBottom(int bottom) {
            this.bottom = this.scores[bottom];
        }

        @Override
        public void setTopValue(Float value2) {
            this.topValue = value2.floatValue();
        }

        @Override
        public void setScorer(Scorer scorer) {
            this.scorer = !(scorer instanceof ScoreCachingWrappingScorer) ? new ScoreCachingWrappingScorer(scorer) : scorer;
        }

        @Override
        public Float value(int slot) {
            return Float.valueOf(this.scores[slot]);
        }

        @Override
        public int compareValues(Float first, Float second) {
            return second.compareTo(first);
        }

        @Override
        public int compareTop(int doc) throws IOException {
            float docValue = this.scorer.score();
            assert (!Float.isNaN(docValue));
            return Float.compare(docValue, this.topValue);
        }
    }

    public static class LongComparator
    extends NumericComparator<Long> {
        private final long[] values;
        private long bottom;
        private long topValue;

        public LongComparator(int numHits, String field2, Long missingValue) {
            super(field2, missingValue != null ? missingValue : 0L);
            this.values = new long[numHits];
        }

        private long getValueForDoc(int doc) throws IOException {
            if (this.currentReaderValues.advanceExact(doc)) {
                return this.currentReaderValues.longValue();
            }
            return (Long)this.missingValue;
        }

        @Override
        public int compare(int slot1, int slot2) {
            return Long.compare(this.values[slot1], this.values[slot2]);
        }

        @Override
        public int compareBottom(int doc) throws IOException {
            return Long.compare(this.bottom, this.getValueForDoc(doc));
        }

        @Override
        public void copy(int slot, int doc) throws IOException {
            this.values[slot] = this.getValueForDoc(doc);
        }

        @Override
        public void setBottom(int bottom) {
            this.bottom = this.values[bottom];
        }

        @Override
        public void setTopValue(Long value2) {
            this.topValue = value2;
        }

        @Override
        public Long value(int slot) {
            return this.values[slot];
        }

        @Override
        public int compareTop(int doc) throws IOException {
            return Long.compare(this.topValue, this.getValueForDoc(doc));
        }
    }

    public static class IntComparator
    extends NumericComparator<Integer> {
        private final int[] values;
        private int bottom;
        private int topValue;

        public IntComparator(int numHits, String field2, Integer missingValue) {
            super(field2, missingValue != null ? missingValue : 0);
            this.values = new int[numHits];
        }

        private int getValueForDoc(int doc) throws IOException {
            if (this.currentReaderValues.advanceExact(doc)) {
                return (int)this.currentReaderValues.longValue();
            }
            return (Integer)this.missingValue;
        }

        @Override
        public int compare(int slot1, int slot2) {
            return Integer.compare(this.values[slot1], this.values[slot2]);
        }

        @Override
        public int compareBottom(int doc) throws IOException {
            return Integer.compare(this.bottom, this.getValueForDoc(doc));
        }

        @Override
        public void copy(int slot, int doc) throws IOException {
            this.values[slot] = this.getValueForDoc(doc);
        }

        @Override
        public void setBottom(int bottom) {
            this.bottom = this.values[bottom];
        }

        @Override
        public void setTopValue(Integer value2) {
            this.topValue = value2;
        }

        @Override
        public Integer value(int slot) {
            return this.values[slot];
        }

        @Override
        public int compareTop(int doc) throws IOException {
            return Integer.compare(this.topValue, this.getValueForDoc(doc));
        }
    }

    public static class FloatComparator
    extends NumericComparator<Float> {
        private final float[] values;
        private float bottom;
        private float topValue;

        public FloatComparator(int numHits, String field2, Float missingValue) {
            super(field2, Float.valueOf(missingValue != null ? missingValue.floatValue() : 0.0f));
            this.values = new float[numHits];
        }

        private float getValueForDoc(int doc) throws IOException {
            if (this.currentReaderValues.advanceExact(doc)) {
                return Float.intBitsToFloat((int)this.currentReaderValues.longValue());
            }
            return ((Float)this.missingValue).floatValue();
        }

        @Override
        public int compare(int slot1, int slot2) {
            return Float.compare(this.values[slot1], this.values[slot2]);
        }

        @Override
        public int compareBottom(int doc) throws IOException {
            return Float.compare(this.bottom, this.getValueForDoc(doc));
        }

        @Override
        public void copy(int slot, int doc) throws IOException {
            this.values[slot] = this.getValueForDoc(doc);
        }

        @Override
        public void setBottom(int bottom) {
            this.bottom = this.values[bottom];
        }

        @Override
        public void setTopValue(Float value2) {
            this.topValue = value2.floatValue();
        }

        @Override
        public Float value(int slot) {
            return Float.valueOf(this.values[slot]);
        }

        @Override
        public int compareTop(int doc) throws IOException {
            return Float.compare(this.topValue, this.getValueForDoc(doc));
        }
    }

    public static class DoubleComparator
    extends NumericComparator<Double> {
        private final double[] values;
        private double bottom;
        private double topValue;

        public DoubleComparator(int numHits, String field2, Double missingValue) {
            super(field2, missingValue != null ? missingValue : 0.0);
            this.values = new double[numHits];
        }

        private double getValueForDoc(int doc) throws IOException {
            if (this.currentReaderValues.advanceExact(doc)) {
                return Double.longBitsToDouble(this.currentReaderValues.longValue());
            }
            return (Double)this.missingValue;
        }

        @Override
        public int compare(int slot1, int slot2) {
            return Double.compare(this.values[slot1], this.values[slot2]);
        }

        @Override
        public int compareBottom(int doc) throws IOException {
            return Double.compare(this.bottom, this.getValueForDoc(doc));
        }

        @Override
        public void copy(int slot, int doc) throws IOException {
            this.values[slot] = this.getValueForDoc(doc);
        }

        @Override
        public void setBottom(int bottom) {
            this.bottom = this.values[bottom];
        }

        @Override
        public void setTopValue(Double value2) {
            this.topValue = value2;
        }

        @Override
        public Double value(int slot) {
            return this.values[slot];
        }

        @Override
        public int compareTop(int doc) throws IOException {
            return Double.compare(this.topValue, this.getValueForDoc(doc));
        }
    }

    public static abstract class NumericComparator<T extends Number>
    extends SimpleFieldComparator<T> {
        protected final T missingValue;
        protected final String field;
        protected NumericDocValues currentReaderValues;

        public NumericComparator(String field2, T missingValue) {
            this.field = field2;
            this.missingValue = missingValue;
        }

        @Override
        protected void doSetNextReader(LeafReaderContext context) throws IOException {
            this.currentReaderValues = this.getNumericDocValues(context, this.field);
        }

        protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field2) throws IOException {
            return DocValues.getNumeric(context.reader(), field2);
        }
    }
}

