/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesIterator;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

public final class DocValuesFieldExistsQuery
extends Query {
    private final String field;

    public DocValuesFieldExistsQuery(String field2) {
        this.field = Objects.requireNonNull(field2);
    }

    public String getField() {
        return this.field;
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.field.equals(((DocValuesFieldExistsQuery)other).field);
    }

    @Override
    public int hashCode() {
        return 31 * this.classHash() + this.field.hashCode();
    }

    @Override
    public String toString(String field2) {
        return "DocValuesFieldExistsQuery [field=" + this.field + "]";
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores, float boost) {
        return new ConstantScoreWeight(this, boost){

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                DocIdSetIterator iterator2 = DocValuesFieldExistsQuery.getDocValuesDocIdSetIterator(DocValuesFieldExistsQuery.this.field, context.reader());
                if (iterator2 == null) {
                    return null;
                }
                return new ConstantScoreScorer((Weight)this, this.score(), iterator2);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return DocValues.isCacheable(ctx, DocValuesFieldExistsQuery.this.field);
            }
        };
    }

    public static DocIdSetIterator getDocValuesDocIdSetIterator(String field2, LeafReader reader) throws IOException {
        FieldInfo fieldInfo = reader.getFieldInfos().fieldInfo(field2);
        if (fieldInfo != null) {
            DocValuesIterator iterator2;
            switch (fieldInfo.getDocValuesType()) {
                case NONE: {
                    iterator2 = null;
                    break;
                }
                case NUMERIC: {
                    iterator2 = reader.getNumericDocValues(field2);
                    break;
                }
                case BINARY: {
                    iterator2 = reader.getBinaryDocValues(field2);
                    break;
                }
                case SORTED: {
                    iterator2 = reader.getSortedDocValues(field2);
                    break;
                }
                case SORTED_NUMERIC: {
                    iterator2 = reader.getSortedNumericDocValues(field2);
                    break;
                }
                case SORTED_SET: {
                    iterator2 = reader.getSortedSetDocValues(field2);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            return iterator2;
        }
        return null;
    }
}

