/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;

public abstract class ConstantScoreWeight
extends Weight {
    private final float score;

    protected ConstantScoreWeight(Query query, float score) {
        super(query);
        this.score = score;
    }

    @Override
    public void extractTerms(Set<Term> terms) {
    }

    protected final float score() {
        return this.score;
    }

    @Override
    public Explanation explain(LeafReaderContext context, int doc) throws IOException {
        boolean exists2;
        Scorer s2 = this.scorer(context);
        if (s2 == null) {
            exists2 = false;
        } else {
            TwoPhaseIterator twoPhase = s2.twoPhaseIterator();
            if (twoPhase == null) {
                exists2 = s2.iterator().advance(doc) == doc;
            } else {
                boolean bl = exists2 = twoPhase.approximation().advance(doc) == doc && twoPhase.matches();
            }
        }
        if (exists2) {
            return Explanation.match(this.score, this.getQuery().toString() + (this.score == 1.0f ? "" : "^" + this.score), new Explanation[0]);
        }
        return Explanation.noMatch(this.getQuery().toString() + " doesn't match id " + doc, new Explanation[0]);
    }
}

