/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.lucene.search.BooleanWeight;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.FakeScorer;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FutureObjects;
import org.apache.lucene.util.PriorityQueue;

final class BooleanScorer
extends BulkScorer {
    static final int SHIFT = 11;
    static final int SIZE = 2048;
    static final int MASK = 2047;
    static final int SET_SIZE = 32;
    static final int SET_MASK = 31;
    final Bucket[] buckets = new Bucket[2048];
    final long[] matching = new long[32];
    final BulkScorerAndDoc[] leads;
    final HeadPriorityQueue head;
    final TailPriorityQueue tail;
    final FakeScorer fakeScorer = new FakeScorer();
    final int minShouldMatch;
    final long cost;
    final OrCollector orCollector = new OrCollector();

    private static long cost(Collection<BulkScorer> scorers, int minShouldMatch) {
        PriorityQueue<BulkScorer> pq = new PriorityQueue<BulkScorer>(scorers.size() - minShouldMatch + 1){

            @Override
            protected boolean lessThan(BulkScorer a, BulkScorer b) {
                return a.cost() > b.cost();
            }
        };
        for (BulkScorer scorer : scorers) {
            pq.insertWithOverflow(scorer);
        }
        long cost = 0L;
        BulkScorer scorer = (BulkScorer)pq.pop();
        while (scorer != null) {
            cost += scorer.cost();
            scorer = (BulkScorer)pq.pop();
        }
        return cost;
    }

    BooleanScorer(BooleanWeight weight, Collection<BulkScorer> scorers, int minShouldMatch, boolean needsScores) {
        if (minShouldMatch < 1 || minShouldMatch > scorers.size()) {
            throw new IllegalArgumentException("minShouldMatch should be within 1..num_scorers. Got " + minShouldMatch);
        }
        if (scorers.size() <= 1) {
            throw new IllegalArgumentException("This scorer can only be used with two scorers or more, got " + scorers.size());
        }
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i] = new Bucket();
        }
        this.leads = new BulkScorerAndDoc[scorers.size()];
        this.head = new HeadPriorityQueue(scorers.size() - minShouldMatch + 1);
        this.tail = new TailPriorityQueue(minShouldMatch - 1);
        this.minShouldMatch = minShouldMatch;
        for (BulkScorer scorer : scorers) {
            BulkScorerAndDoc evicted;
            if (!needsScores) {
                scorer = BooleanWeight.disableScoring(scorer);
            }
            if ((evicted = this.tail.insertWithOverflow(new BulkScorerAndDoc(scorer))) == null) continue;
            this.head.add(evicted);
        }
        this.cost = BooleanScorer.cost(scorers, minShouldMatch);
    }

    @Override
    public long cost() {
        return this.cost;
    }

    private void scoreDocument(LeafCollector collector, int base, int i) throws IOException {
        FakeScorer fakeScorer = this.fakeScorer;
        Bucket bucket = this.buckets[i];
        if (bucket.freq >= this.minShouldMatch) {
            int doc;
            fakeScorer.score = (float)bucket.score;
            fakeScorer.doc = doc = base | i;
            collector.collect(doc);
        }
        bucket.freq = 0;
        bucket.score = 0.0;
    }

    private void scoreMatches(LeafCollector collector, int base) throws IOException {
        long[] matching2 = this.matching;
        for (int idx = 0; idx < matching2.length; ++idx) {
            int ntz;
            for (long bits2 = matching2[idx]; bits2 != 0L; bits2 ^= 1L << ntz) {
                ntz = Long.numberOfTrailingZeros(bits2);
                int doc = idx << 6 | ntz;
                this.scoreDocument(collector, base, doc);
            }
        }
    }

    private void scoreWindowIntoBitSetAndReplay(LeafCollector collector, Bits acceptDocs, int base, int min2, int max2, BulkScorerAndDoc[] scorers, int numScorers) throws IOException {
        for (int i = 0; i < numScorers; ++i) {
            BulkScorerAndDoc scorer = scorers[i];
            assert (scorer.next < max2);
            scorer.score(this.orCollector, acceptDocs, min2, max2);
        }
        this.scoreMatches(collector, base);
        Arrays.fill(this.matching, 0L);
    }

    private BulkScorerAndDoc advance(int min2) throws IOException {
        assert (this.tail.size() == this.minShouldMatch - 1);
        HeadPriorityQueue head2 = this.head;
        TailPriorityQueue tail = this.tail;
        BulkScorerAndDoc headTop = (BulkScorerAndDoc)head2.top();
        BulkScorerAndDoc tailTop = (BulkScorerAndDoc)tail.top();
        while (headTop.next < min2) {
            if (tailTop == null || headTop.cost <= tailTop.cost) {
                headTop.advance(min2);
                headTop = (BulkScorerAndDoc)head2.updateTop();
                continue;
            }
            BulkScorerAndDoc previousHeadTop = headTop;
            tailTop.advance(min2);
            headTop = head2.updateTop(tailTop);
            tailTop = tail.updateTop(previousHeadTop);
        }
        return headTop;
    }

    private void scoreWindowMultipleScorers(LeafCollector collector, Bits acceptDocs, int windowBase, int windowMin, int windowMax, int maxFreq) throws IOException {
        while (maxFreq < this.minShouldMatch && maxFreq + this.tail.size() >= this.minShouldMatch) {
            BulkScorerAndDoc candidate = (BulkScorerAndDoc)this.tail.pop();
            candidate.advance(windowMin);
            if (candidate.next < windowMax) {
                this.leads[maxFreq++] = candidate;
                continue;
            }
            this.head.add(candidate);
        }
        if (maxFreq >= this.minShouldMatch) {
            for (int i = 0; i < this.tail.size(); ++i) {
                this.leads[maxFreq++] = this.tail.get(i);
            }
            this.tail.clear();
            this.scoreWindowIntoBitSetAndReplay(collector, acceptDocs, windowBase, windowMin, windowMax, this.leads, maxFreq);
        }
        for (int i = 0; i < maxFreq; ++i) {
            BulkScorerAndDoc evicted = this.head.insertWithOverflow(this.leads[i]);
            if (evicted == null) continue;
            this.tail.add(evicted);
        }
    }

    private void scoreWindowSingleScorer(BulkScorerAndDoc bulkScorer, LeafCollector collector, Bits acceptDocs, int windowMin, int windowMax, int max2) throws IOException {
        assert (this.tail.size() == 0);
        int nextWindowBase = ((BulkScorerAndDoc)this.head.top()).next & 0xFFFFF800;
        int end = Math.max(windowMax, Math.min(max2, nextWindowBase));
        bulkScorer.score(collector, acceptDocs, windowMin, end);
        collector.setScorer(this.fakeScorer);
    }

    private BulkScorerAndDoc scoreWindow(BulkScorerAndDoc top, LeafCollector collector, Bits acceptDocs, int min2, int max2) throws IOException {
        int windowBase = top.next & 0xFFFFF800;
        int windowMin = Math.max(min2, windowBase);
        int windowMax = Math.min(max2, windowBase + 2048);
        this.leads[0] = (BulkScorerAndDoc)this.head.pop();
        int maxFreq = 1;
        while (this.head.size() > 0 && ((BulkScorerAndDoc)this.head.top()).next < windowMax) {
            this.leads[maxFreq++] = (BulkScorerAndDoc)this.head.pop();
        }
        if (this.minShouldMatch == 1 && maxFreq == 1) {
            BulkScorerAndDoc bulkScorer = this.leads[0];
            this.scoreWindowSingleScorer(bulkScorer, collector, acceptDocs, windowMin, windowMax, max2);
            return this.head.add(bulkScorer);
        }
        this.scoreWindowMultipleScorers(collector, acceptDocs, windowBase, windowMin, windowMax, maxFreq);
        return (BulkScorerAndDoc)this.head.top();
    }

    @Override
    public int score(LeafCollector collector, Bits acceptDocs, int min2, int max2) throws IOException {
        this.fakeScorer.doc = -1;
        collector.setScorer(this.fakeScorer);
        BulkScorerAndDoc top = this.advance(min2);
        while (top.next < max2) {
            top = this.scoreWindow(top, collector, acceptDocs, min2, max2);
        }
        return top.next;
    }

    final class OrCollector
    implements LeafCollector {
        Scorer scorer;

        OrCollector() {
        }

        @Override
        public void setScorer(Scorer scorer) {
            this.scorer = scorer;
        }

        @Override
        public void collect(int doc) throws IOException {
            int idx;
            int i = doc & 0x7FF;
            int n = idx = i >>> 6;
            BooleanScorer.this.matching[n] = BooleanScorer.this.matching[n] | 1L << i;
            Bucket bucket = BooleanScorer.this.buckets[i];
            ++bucket.freq;
            bucket.score += (double)this.scorer.score();
        }
    }

    static final class TailPriorityQueue
    extends PriorityQueue<BulkScorerAndDoc> {
        public TailPriorityQueue(int maxSize) {
            super(maxSize);
        }

        @Override
        protected boolean lessThan(BulkScorerAndDoc a, BulkScorerAndDoc b) {
            return a.cost < b.cost;
        }

        public BulkScorerAndDoc get(int i) {
            FutureObjects.checkIndex(i, this.size());
            return (BulkScorerAndDoc)this.getHeapArray()[1 + i];
        }
    }

    static final class HeadPriorityQueue
    extends PriorityQueue<BulkScorerAndDoc> {
        public HeadPriorityQueue(int maxSize) {
            super(maxSize);
        }

        @Override
        protected boolean lessThan(BulkScorerAndDoc a, BulkScorerAndDoc b) {
            return a.next < b.next;
        }
    }

    private class BulkScorerAndDoc {
        final BulkScorer scorer;
        final long cost;
        int next;

        BulkScorerAndDoc(BulkScorer scorer) {
            this.scorer = scorer;
            this.cost = scorer.cost();
            this.next = -1;
        }

        void advance(int min2) throws IOException {
            this.score(BooleanScorer.this.orCollector, null, min2, min2);
        }

        void score(LeafCollector collector, Bits acceptDocs, int min2, int max2) throws IOException {
            this.next = this.scorer.score(collector, acceptDocs, min2, max2);
        }
    }

    static class Bucket {
        double score;
        int freq;

        Bucket() {
        }
    }
}

