/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.flexible.standard.processors;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import org.apache.lucene.queryparser.flexible.core.nodes.FieldQueryNode;
import org.apache.lucene.queryparser.flexible.core.nodes.FuzzyQueryNode;
import org.apache.lucene.queryparser.flexible.core.nodes.QueryNode;
import org.apache.lucene.queryparser.flexible.core.nodes.QuotedFieldQueryNode;
import org.apache.lucene.queryparser.flexible.core.processors.QueryNodeProcessorImpl;
import org.apache.lucene.queryparser.flexible.core.util.UnescapedCharSequence;
import org.apache.lucene.queryparser.flexible.standard.config.StandardQueryConfigHandler;
import org.apache.lucene.queryparser.flexible.standard.nodes.PrefixWildcardQueryNode;
import org.apache.lucene.queryparser.flexible.standard.nodes.TermRangeQueryNode;
import org.apache.lucene.queryparser.flexible.standard.nodes.WildcardQueryNode;
import org.apache.lucene.util.BytesRef;

public class WildcardQueryNodeProcessor
extends QueryNodeProcessorImpl {
    private static final Pattern WILDCARD_PATTERN = Pattern.compile("(\\.)|([?*]+)");

    private static String analyzeWildcard(Analyzer a, String field2, String wildcard) {
        BytesRef normalized;
        String chunk;
        Matcher wildcardMatcher = WILDCARD_PATTERN.matcher(wildcard);
        StringBuilder sb = new StringBuilder();
        int last2 = 0;
        while (wildcardMatcher.find()) {
            if (wildcardMatcher.group(1) != null) continue;
            if (wildcardMatcher.start() > 0) {
                chunk = wildcard.substring(last2, wildcardMatcher.start());
                normalized = a.normalize(field2, chunk);
                sb.append(normalized.utf8ToString());
            }
            sb.append(wildcardMatcher.group(2));
            last2 = wildcardMatcher.end();
        }
        if (last2 < wildcard.length()) {
            chunk = wildcard.substring(last2);
            normalized = a.normalize(field2, chunk);
            sb.append(normalized.utf8ToString());
        }
        return sb.toString();
    }

    @Override
    protected QueryNode postProcessNode(QueryNode node) throws QueryNodeException {
        if (node instanceof FieldQueryNode || node instanceof FuzzyQueryNode) {
            FieldQueryNode fqn = (FieldQueryNode)node;
            CharSequence text2 = fqn.getText();
            if (fqn.getParent() instanceof TermRangeQueryNode || fqn instanceof QuotedFieldQueryNode || text2.length() <= 0) {
                return node;
            }
            if (this.isWildcard(text2)) {
                Analyzer analyzer = this.getQueryConfigHandler().get(StandardQueryConfigHandler.ConfigurationKeys.ANALYZER);
                if (analyzer != null) {
                    text2 = WildcardQueryNodeProcessor.analyzeWildcard(analyzer, fqn.getFieldAsString(), text2.toString());
                }
                if (this.isPrefixWildcard(text2)) {
                    return new PrefixWildcardQueryNode(fqn.getField(), text2, fqn.getBegin(), fqn.getEnd());
                }
                return new WildcardQueryNode(fqn.getField(), text2, fqn.getBegin(), fqn.getEnd());
            }
        }
        return node;
    }

    private boolean isWildcard(CharSequence text2) {
        if (text2 == null || text2.length() <= 0) {
            return false;
        }
        for (int i = text2.length() - 1; i >= 0; --i) {
            if (text2.charAt(i) != '*' && text2.charAt(i) != '?' || UnescapedCharSequence.wasEscaped(text2, i)) continue;
            return true;
        }
        return false;
    }

    private boolean isPrefixWildcard(CharSequence text2) {
        if (text2 == null || text2.length() <= 0 || !this.isWildcard(text2)) {
            return false;
        }
        if (text2.charAt(text2.length() - 1) != '*') {
            return false;
        }
        if (UnescapedCharSequence.wasEscaped(text2, text2.length() - 1)) {
            return false;
        }
        if (text2.length() == 1) {
            return false;
        }
        for (int i = 0; i < text2.length(); ++i) {
            if (text2.charAt(i) == '?') {
                return false;
            }
            if (text2.charAt(i) != '*' || UnescapedCharSequence.wasEscaped(text2, i)) continue;
            return i == text2.length() - 1;
        }
        return false;
    }

    @Override
    protected QueryNode preProcessNode(QueryNode node) throws QueryNodeException {
        return node;
    }

    @Override
    protected List<QueryNode> setChildrenOrder(List<QueryNode> children2) throws QueryNodeException {
        return children2;
    }
}

