/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.flexible.standard.processors;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.List;
import org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import org.apache.lucene.queryparser.flexible.core.QueryNodeParseException;
import org.apache.lucene.queryparser.flexible.core.config.FieldConfig;
import org.apache.lucene.queryparser.flexible.core.config.QueryConfigHandler;
import org.apache.lucene.queryparser.flexible.core.messages.QueryParserMessages;
import org.apache.lucene.queryparser.flexible.core.nodes.FieldQueryNode;
import org.apache.lucene.queryparser.flexible.core.nodes.QueryNode;
import org.apache.lucene.queryparser.flexible.core.nodes.RangeQueryNode;
import org.apache.lucene.queryparser.flexible.core.processors.QueryNodeProcessorImpl;
import org.apache.lucene.queryparser.flexible.messages.MessageImpl;
import org.apache.lucene.queryparser.flexible.standard.config.PointsConfig;
import org.apache.lucene.queryparser.flexible.standard.config.StandardQueryConfigHandler;
import org.apache.lucene.queryparser.flexible.standard.nodes.PointQueryNode;
import org.apache.lucene.queryparser.flexible.standard.nodes.PointRangeQueryNode;

public class PointQueryNodeProcessor
extends QueryNodeProcessorImpl {
    @Override
    protected QueryNode postProcessNode(QueryNode node) throws QueryNodeException {
        PointsConfig numericConfig;
        FieldQueryNode fieldNode;
        FieldConfig fieldConfig;
        QueryConfigHandler config;
        if (node instanceof FieldQueryNode && !(node.getParent() instanceof RangeQueryNode) && (config = this.getQueryConfigHandler()) != null && (fieldConfig = config.getFieldConfig((fieldNode = (FieldQueryNode)node).getFieldAsString())) != null && (numericConfig = fieldConfig.get(StandardQueryConfigHandler.ConfigurationKeys.POINTS_CONFIG)) != null) {
            NumberFormat numberFormat = numericConfig.getNumberFormat();
            String text2 = fieldNode.getTextAsString();
            Number number2 = null;
            if (text2.length() > 0) {
                try {
                    number2 = numberFormat.parse(text2);
                }
                catch (ParseException e) {
                    throw new QueryNodeParseException(new MessageImpl(QueryParserMessages.COULD_NOT_PARSE_NUMBER, fieldNode.getTextAsString(), numberFormat.getClass().getCanonicalName()), (Throwable)e);
                }
                if (Integer.class.equals(numericConfig.getType())) {
                    number2 = number2.intValue();
                } else if (Long.class.equals(numericConfig.getType())) {
                    number2 = number2.longValue();
                } else if (Double.class.equals(numericConfig.getType())) {
                    number2 = number2.doubleValue();
                } else if (Float.class.equals(numericConfig.getType())) {
                    number2 = Float.valueOf(number2.floatValue());
                }
            } else {
                throw new QueryNodeParseException(new MessageImpl(QueryParserMessages.NUMERIC_CANNOT_BE_EMPTY, fieldNode.getFieldAsString()));
            }
            PointQueryNode lowerNode = new PointQueryNode(fieldNode.getField(), number2, numberFormat);
            PointQueryNode upperNode = new PointQueryNode(fieldNode.getField(), number2, numberFormat);
            return new PointRangeQueryNode(lowerNode, upperNode, true, true, numericConfig);
        }
        return node;
    }

    @Override
    protected QueryNode preProcessNode(QueryNode node) throws QueryNodeException {
        return node;
    }

    @Override
    protected List<QueryNode> setChildrenOrder(List<QueryNode> children2) throws QueryNodeException {
        return children2;
    }
}

