/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.ext;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.ext.ExtensionQuery;
import org.apache.lucene.queryparser.ext.Extensions;
import org.apache.lucene.queryparser.ext.ParserExtension;
import org.apache.lucene.search.Query;

public class ExtendableQueryParser
extends QueryParser {
    private final String defaultField;
    private final Extensions extensions;
    private static final Extensions DEFAULT_EXTENSION = new Extensions();

    public ExtendableQueryParser(String f2, Analyzer a) {
        this(f2, a, DEFAULT_EXTENSION);
    }

    public ExtendableQueryParser(String f2, Analyzer a, Extensions ext) {
        super(f2, a);
        this.defaultField = f2;
        this.extensions = ext;
    }

    public char getExtensionFieldDelimiter() {
        return this.extensions.getExtensionFieldDelimiter();
    }

    @Override
    protected Query getFieldQuery(String field2, String queryText, boolean quoted2) throws ParseException {
        Extensions.Pair<String, String> splitExtensionField = this.extensions.splitExtensionField(this.defaultField, field2);
        ParserExtension extension2 = this.extensions.getExtension((String)splitExtensionField.cud);
        if (extension2 != null) {
            return extension2.parse(new ExtensionQuery(this, (String)splitExtensionField.cur, queryText));
        }
        return super.getFieldQuery(field2, queryText, quoted2);
    }
}

