/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSourceScorer;
import org.apache.lucene.queries.function.docvalues.IntDocValues;
import org.apache.lucene.queries.function.valuesource.FieldCacheSource;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueInt;

public class EnumFieldSource
extends FieldCacheSource {
    static final Integer DEFAULT_VALUE = -1;
    final Map<Integer, String> enumIntToStringMap;
    final Map<String, Integer> enumStringToIntMap;

    public EnumFieldSource(String field2, Map<Integer, String> enumIntToStringMap, Map<String, Integer> enumStringToIntMap) {
        super(field2);
        this.enumIntToStringMap = enumIntToStringMap;
        this.enumStringToIntMap = enumStringToIntMap;
    }

    private static Integer tryParseInt(String valueStr) {
        Integer intValue = null;
        try {
            intValue = Integer.parseInt(valueStr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return intValue;
    }

    private String intValueToStringValue(Integer intVal) {
        if (intVal == null) {
            return null;
        }
        String enumString = this.enumIntToStringMap.get(intVal);
        if (enumString != null) {
            return enumString;
        }
        return DEFAULT_VALUE.toString();
    }

    private Integer stringValueToIntValue(String stringVal2) {
        String enumString;
        if (stringVal2 == null) {
            return null;
        }
        Integer enumInt = this.enumStringToIntMap.get(stringVal2);
        if (enumInt != null) {
            return enumInt;
        }
        Integer intValue = EnumFieldSource.tryParseInt(stringVal2);
        if (intValue == null) {
            intValue = DEFAULT_VALUE;
        }
        if ((enumString = this.enumIntToStringMap.get(intValue)) != null) {
            return intValue;
        }
        return DEFAULT_VALUE;
    }

    @Override
    public String description() {
        return "enum(" + this.field + ')';
    }

    @Override
    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        final NumericDocValues arr = DocValues.getNumeric(readerContext.reader(), this.field);
        return new IntDocValues(this){
            final MutableValueInt val;
            int lastDocID;
            {
                super(vs);
                this.val = new MutableValueInt();
            }

            private int getValueForDoc(int doc) throws IOException {
                if (doc < this.lastDocID) {
                    throw new AssertionError((Object)("docs were sent out-of-order: lastDocID=" + this.lastDocID + " vs doc=" + doc));
                }
                this.lastDocID = doc;
                int curDocID = arr.docID();
                if (doc > curDocID) {
                    curDocID = arr.advance(doc);
                }
                if (doc == curDocID) {
                    return (int)arr.longValue();
                }
                return 0;
            }

            @Override
            public int intVal(int doc) throws IOException {
                return this.getValueForDoc(doc);
            }

            @Override
            public String strVal(int doc) throws IOException {
                Integer intValue = this.intVal(doc);
                return EnumFieldSource.this.intValueToStringValue(intValue);
            }

            @Override
            public boolean exists(int doc) throws IOException {
                this.getValueForDoc(doc);
                return arr.docID() == doc;
            }

            @Override
            public ValueSourceScorer getRangeScorer(LeafReaderContext readerContext, String lowerVal, String upperVal, boolean includeLower, boolean includeUpper) {
                Integer n;
                Integer n2;
                Integer lower = EnumFieldSource.this.stringValueToIntValue(lowerVal);
                Integer upper = EnumFieldSource.this.stringValueToIntValue(upperVal);
                if (lower == null) {
                    lower = Integer.MIN_VALUE;
                } else if (!includeLower && lower < Integer.MAX_VALUE) {
                    n2 = lower;
                    n = lower = Integer.valueOf(lower + 1);
                }
                if (upper == null) {
                    upper = Integer.MAX_VALUE;
                } else if (!includeUpper && upper > Integer.MIN_VALUE) {
                    n2 = upper;
                    n = upper = Integer.valueOf(upper - 1);
                }
                final int ll = lower;
                final int uu = upper;
                return new ValueSourceScorer(readerContext, this){

                    @Override
                    public boolean matches(int doc) throws IOException {
                        if (!this.exists(doc)) {
                            return false;
                        }
                        int val = this.intVal(doc);
                        return val >= ll && val <= uu;
                    }
                };
            }

            @Override
            public FunctionValues.ValueFiller getValueFiller() {
                return new FunctionValues.ValueFiller(){
                    private final MutableValueInt mval = new MutableValueInt();

                    @Override
                    public MutableValue getValue() {
                        return this.mval;
                    }

                    @Override
                    public void fillValue(int doc) throws IOException {
                        this.mval.value = this.intVal(doc);
                        this.mval.exists = arr.docID() == doc;
                    }
                };
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EnumFieldSource that = (EnumFieldSource)o;
        if (!this.enumIntToStringMap.equals(that.enumIntToStringMap)) {
            return false;
        }
        return this.enumStringToIntMap.equals(that.enumStringToIntMap);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.enumIntToStringMap.hashCode();
        result2 = 31 * result2 + this.enumStringToIntMap.hashCode();
        return result2;
    }
}

