/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function;

import java.io.IOException;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LongValues;
import org.apache.lucene.search.LongValuesSource;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SimpleFieldComparator;
import org.apache.lucene.search.SortField;

public abstract class ValueSource {
    public abstract FunctionValues getValues(Map var1, LeafReaderContext var2) throws IOException;

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String description();

    public String toString() {
        return this.description();
    }

    public void createWeight(Map context, IndexSearcher searcher) throws IOException {
    }

    public static Map newContext(IndexSearcher searcher) {
        IdentityHashMap<String, IndexSearcher> context = new IdentityHashMap<String, IndexSearcher>();
        context.put("searcher", searcher);
        return context;
    }

    public LongValuesSource asLongValuesSource() {
        return new WrappedLongValuesSource(this);
    }

    public DoubleValuesSource asDoubleValuesSource() {
        return new WrappedDoubleValuesSource(this);
    }

    public static ValueSource fromDoubleValuesSource(DoubleValuesSource in) {
        return new FromDoubleValuesSource(in);
    }

    public SortField getSortField(boolean reverse2) {
        return new ValueSourceSortField(reverse2);
    }

    class ValueSourceComparator
    extends SimpleFieldComparator<Double> {
        private final double[] values;
        private FunctionValues docVals;
        private double bottom;
        private final Map fcontext;
        private double topValue;

        ValueSourceComparator(Map fcontext, int numHits) {
            this.fcontext = fcontext;
            this.values = new double[numHits];
        }

        @Override
        public int compare(int slot1, int slot2) {
            return Double.compare(this.values[slot1], this.values[slot2]);
        }

        @Override
        public int compareBottom(int doc) throws IOException {
            return Double.compare(this.bottom, this.docVals.doubleVal(doc));
        }

        @Override
        public void copy(int slot, int doc) throws IOException {
            this.values[slot] = this.docVals.doubleVal(doc);
        }

        @Override
        public void doSetNextReader(LeafReaderContext context) throws IOException {
            this.docVals = ValueSource.this.getValues(this.fcontext, context);
        }

        @Override
        public void setBottom(int bottom) {
            this.bottom = this.values[bottom];
        }

        @Override
        public void setTopValue(Double value2) {
            this.topValue = value2;
        }

        @Override
        public Double value(int slot) {
            return this.values[slot];
        }

        @Override
        public int compareTop(int doc) throws IOException {
            double docValue = this.docVals.doubleVal(doc);
            return Double.compare(this.topValue, docValue);
        }
    }

    class ValueSourceComparatorSource
    extends FieldComparatorSource {
        private final Map context;

        public ValueSourceComparatorSource(Map context) {
            this.context = context;
        }

        public FieldComparator<Double> newComparator(String fieldname, int numHits, int sortPos, boolean reversed2) {
            return new ValueSourceComparator(this.context, numHits);
        }
    }

    class ValueSourceSortField
    extends SortField {
        public ValueSourceSortField(boolean reverse2) {
            super(ValueSource.this.description(), SortField.Type.REWRITEABLE, reverse2);
        }

        @Override
        public SortField rewrite(IndexSearcher searcher) throws IOException {
            Map context = ValueSource.newContext(searcher);
            ValueSource.this.createWeight(context, searcher);
            return new SortField(this.getField(), new ValueSourceComparatorSource(context), this.getReverse());
        }
    }

    private static class FromDoubleValuesSource
    extends ValueSource {
        final DoubleValuesSource in;

        private FromDoubleValuesSource(DoubleValuesSource in) {
            this.in = in;
        }

        @Override
        public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
            Scorer scorer = (Scorer)context.get("scorer");
            DoubleValues scores = scorer == null ? null : DoubleValuesSource.fromScorer(scorer);
            IndexSearcher searcher = (IndexSearcher)context.get("searcher");
            final DoubleValues inner2 = searcher != null ? this.in.rewrite(searcher).getValues(readerContext, scores) : this.in.getValues(readerContext, scores);
            return new FunctionValues(){

                @Override
                public String toString(int doc) throws IOException {
                    return in.toString();
                }

                @Override
                public float floatVal(int doc) throws IOException {
                    if (!inner2.advanceExact(doc)) {
                        return 0.0f;
                    }
                    return (float)inner2.doubleValue();
                }

                @Override
                public double doubleVal(int doc) throws IOException {
                    if (!inner2.advanceExact(doc)) {
                        return 0.0;
                    }
                    return inner2.doubleValue();
                }

                @Override
                public boolean exists(int doc) throws IOException {
                    return inner2.advanceExact(doc);
                }
            };
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FromDoubleValuesSource that = (FromDoubleValuesSource)o;
            return Objects.equals(this.in, that.in);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.in);
        }

        @Override
        public String description() {
            return this.in.toString();
        }
    }

    private static class WrappedDoubleValuesSource
    extends DoubleValuesSource {
        private final ValueSource in;
        private IndexSearcher searcher;

        private WrappedDoubleValuesSource(ValueSource in) {
            this.in = in;
        }

        @Override
        public DoubleValues getValues(LeafReaderContext ctx, final DoubleValues scores) throws IOException {
            HashMap<String, Object> context = new HashMap<String, Object>();
            final FakeScorer scorer = new FakeScorer();
            context.put("scorer", scorer);
            context.put("searcher", this.searcher);
            final FunctionValues fv = this.in.getValues(context, ctx);
            return new DoubleValues(){

                @Override
                public double doubleValue() throws IOException {
                    return fv.doubleVal(scorer.current);
                }

                @Override
                public boolean advanceExact(int doc) throws IOException {
                    scorer.current = doc;
                    scorer.score = scores != null && scores.advanceExact(doc) ? (float)scores.doubleValue() : 0.0f;
                    return fv.exists(doc);
                }
            };
        }

        @Override
        public boolean needsScores() {
            return true;
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return false;
        }

        @Override
        public Explanation explain(LeafReaderContext ctx, int docId, Explanation scoreExplanation) throws IOException {
            HashMap<String, Object> context = new HashMap<String, Object>();
            FakeScorer scorer = new FakeScorer();
            scorer.score = scoreExplanation.getValue();
            context.put("scorer", scorer);
            context.put("searcher", this.searcher);
            FunctionValues fv = this.in.getValues(context, ctx);
            return fv.explain(docId);
        }

        @Override
        public DoubleValuesSource rewrite(IndexSearcher searcher) throws IOException {
            this.searcher = searcher;
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WrappedDoubleValuesSource that = (WrappedDoubleValuesSource)o;
            return Objects.equals(this.in, that.in);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.in);
        }

        @Override
        public String toString() {
            return this.in.toString();
        }
    }

    private static class WrappedLongValuesSource
    extends LongValuesSource {
        private final ValueSource in;

        private WrappedLongValuesSource(ValueSource in) {
            this.in = in;
        }

        @Override
        public LongValues getValues(LeafReaderContext ctx, final DoubleValues scores) throws IOException {
            IdentityHashMap<String, FakeScorer> context = new IdentityHashMap<String, FakeScorer>();
            final FakeScorer scorer = new FakeScorer();
            context.put("scorer", scorer);
            final FunctionValues fv = this.in.getValues(context, ctx);
            return new LongValues(){

                @Override
                public long longValue() throws IOException {
                    return fv.longVal(scorer.current);
                }

                @Override
                public boolean advanceExact(int doc) throws IOException {
                    scorer.current = doc;
                    scorer.score = scores != null && scores.advanceExact(doc) ? (float)scores.doubleValue() : 0.0f;
                    return fv.exists(doc);
                }
            };
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return false;
        }

        @Override
        public boolean needsScores() {
            return false;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WrappedLongValuesSource that = (WrappedLongValuesSource)o;
            return Objects.equals(this.in, that.in);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.in);
        }

        @Override
        public String toString() {
            return this.in.toString();
        }

        @Override
        public LongValuesSource rewrite(IndexSearcher searcher) throws IOException {
            return this;
        }
    }

    private static class FakeScorer
    extends Scorer {
        int current = -1;
        float score = 0.0f;

        FakeScorer() {
            super(null);
        }

        @Override
        public int docID() {
            return this.current;
        }

        @Override
        public float score() throws IOException {
            return this.score;
        }

        @Override
        public DocIdSetIterator iterator() {
            throw new UnsupportedOperationException();
        }
    }
}

