/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

public class FunctionQuery
extends Query {
    final ValueSource func;

    public FunctionQuery(ValueSource func) {
        this.func = func;
    }

    public ValueSource getValueSource() {
        return this.func;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
        return new FunctionWeight(searcher, boost);
    }

    @Override
    public String toString(String field2) {
        return this.func.toString();
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.func.equals(((FunctionQuery)other).func);
    }

    @Override
    public int hashCode() {
        return this.classHash() ^ this.func.hashCode();
    }

    protected class AllScorer
    extends Scorer {
        final IndexReader reader;
        final FunctionWeight weight;
        final int maxDoc;
        final float boost;
        final DocIdSetIterator iterator;
        final FunctionValues vals;

        public AllScorer(LeafReaderContext context, FunctionWeight w, float boost) throws IOException {
            super(w);
            this.weight = w;
            this.boost = boost;
            this.reader = context.reader();
            this.maxDoc = this.reader.maxDoc();
            this.iterator = DocIdSetIterator.all(context.reader().maxDoc());
            this.vals = FunctionQuery.this.func.getValues(this.weight.context, context);
        }

        @Override
        public DocIdSetIterator iterator() {
            return this.iterator;
        }

        @Override
        public int docID() {
            return this.iterator.docID();
        }

        @Override
        public float score() throws IOException {
            float score = this.boost * this.vals.floatVal(this.docID());
            return score > Float.NEGATIVE_INFINITY ? score : -3.4028235E38f;
        }

        public Explanation explain(int doc) throws IOException {
            float sc = this.boost * this.vals.floatVal(doc);
            return Explanation.match(sc, "FunctionQuery(" + FunctionQuery.this.func + "), product of:", this.vals.explain(doc), Explanation.match(this.weight.boost, "boost", new Explanation[0]));
        }
    }

    protected class FunctionWeight
    extends Weight {
        protected final IndexSearcher searcher;
        protected final float boost;
        protected final Map context;

        public FunctionWeight(IndexSearcher searcher, float boost) throws IOException {
            super(FunctionQuery.this);
            this.searcher = searcher;
            this.context = ValueSource.newContext(searcher);
            FunctionQuery.this.func.createWeight(this.context, searcher);
            this.boost = boost;
        }

        @Override
        public void extractTerms(Set<Term> terms) {
        }

        @Override
        public Scorer scorer(LeafReaderContext context) throws IOException {
            return new AllScorer(context, this, this.boost);
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return false;
        }

        @Override
        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            return ((AllScorer)this.scorer(context)).explain(doc);
        }
    }
}

