/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.payloads;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.spans.SpanCollector;
import org.apache.lucene.util.BytesRef;

public class PayloadSpanCollector
implements SpanCollector {
    private final Collection<byte[]> payloads = new ArrayList<byte[]>();

    @Override
    public void collectLeaf(PostingsEnum postings, int position2, Term term) throws IOException {
        BytesRef payload = postings.getPayload();
        if (payload == null) {
            return;
        }
        byte[] bytes2 = new byte[payload.length];
        System.arraycopy(payload.bytes, payload.offset, bytes2, 0, payload.length);
        this.payloads.add(bytes2);
    }

    @Override
    public void reset() {
        this.payloads.clear();
    }

    public Collection<byte[]> getPayloads() {
        return this.payloads;
    }
}

