/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.AutomatonTermsEnum;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.automaton.CompiledAutomaton;

public abstract class Terms {
    public static final Terms[] EMPTY_ARRAY = new Terms[0];

    protected Terms() {
    }

    public abstract TermsEnum iterator() throws IOException;

    public TermsEnum intersect(CompiledAutomaton compiled, final BytesRef startTerm) throws IOException {
        TermsEnum termsEnum = this.iterator();
        if (compiled.type != CompiledAutomaton.AUTOMATON_TYPE.NORMAL) {
            throw new IllegalArgumentException("please use CompiledAutomaton.getTermsEnum instead");
        }
        if (startTerm == null) {
            return new AutomatonTermsEnum(termsEnum, compiled);
        }
        return new AutomatonTermsEnum(termsEnum, compiled){

            @Override
            protected BytesRef nextSeekTerm(BytesRef term) throws IOException {
                if (term == null) {
                    term = startTerm;
                }
                return super.nextSeekTerm(term);
            }
        };
    }

    public abstract long size() throws IOException;

    public abstract long getSumTotalTermFreq() throws IOException;

    public abstract long getSumDocFreq() throws IOException;

    public abstract int getDocCount() throws IOException;

    public abstract boolean hasFreqs();

    public abstract boolean hasOffsets();

    public abstract boolean hasPositions();

    public abstract boolean hasPayloads();

    public BytesRef getMin() throws IOException {
        return this.iterator().next();
    }

    public BytesRef getMax() throws IOException {
        TermsEnum iterator2;
        BytesRef v;
        long size2 = this.size();
        if (size2 == 0L) {
            return null;
        }
        if (size2 >= 0L) {
            try {
                TermsEnum iterator3 = this.iterator();
                iterator3.seekExact(size2 - 1L);
                return iterator3.term();
            }
            catch (UnsupportedOperationException iterator3) {
                // empty catch block
            }
        }
        if ((v = (iterator2 = this.iterator()).next()) == null) {
            return v;
        }
        BytesRefBuilder scratch = new BytesRefBuilder();
        scratch.append((byte)0);
        while (true) {
            int low = 0;
            int high = 256;
            while (low != high) {
                int mid = low + high >>> 1;
                scratch.setByteAt(scratch.length() - 1, (byte)mid);
                if (iterator2.seekCeil(scratch.get()) == TermsEnum.SeekStatus.END) {
                    if (mid == 0) {
                        scratch.setLength(scratch.length() - 1);
                        return scratch.get();
                    }
                    high = mid;
                    continue;
                }
                if (low == mid) break;
                low = mid;
            }
            scratch.setLength(scratch.length() + 1);
            scratch.grow(scratch.length());
        }
    }

    public Object getStats() throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("impl=" + this.getClass().getSimpleName());
        sb.append(",size=" + this.size());
        sb.append(",docCount=" + this.getDocCount());
        sb.append(",sumTotalTermFreq=" + this.getSumTotalTermFreq());
        sb.append(",sumDocFreq=" + this.getSumDocFreq());
        return sb.toString();
    }
}

