/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.index.DocValuesWriter;
import org.apache.lucene.index.DocsWithFieldSet;
import org.apache.lucene.index.EmptyDocValuesProducer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.index.SortingLeafReader;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedSetSelector;
import org.apache.lucene.search.SortedSetSortField;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.ByteBlockPool;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.packed.PackedLongValues;

class SortedSetDocValuesWriter
extends DocValuesWriter {
    final BytesRefHash hash;
    private PackedLongValues.Builder pending;
    private PackedLongValues.Builder pendingCounts;
    private DocsWithFieldSet docsWithField;
    private final Counter iwBytesUsed;
    private long bytesUsed;
    private final FieldInfo fieldInfo;
    private int currentDoc = -1;
    private int[] currentValues = new int[8];
    private int currentUpto;
    private int maxCount;
    private PackedLongValues finalOrds;
    private PackedLongValues finalOrdCounts;
    private int[] finalSortedValues;
    private int[] finalOrdMap;

    public SortedSetDocValuesWriter(FieldInfo fieldInfo, Counter iwBytesUsed) {
        this.fieldInfo = fieldInfo;
        this.iwBytesUsed = iwBytesUsed;
        this.hash = new BytesRefHash(new ByteBlockPool(new ByteBlockPool.DirectTrackingAllocator(iwBytesUsed)), 16, new BytesRefHash.DirectBytesStartArray(16, iwBytesUsed));
        this.pending = PackedLongValues.packedBuilder(0.0f);
        this.pendingCounts = PackedLongValues.deltaPackedBuilder(0.0f);
        this.docsWithField = new DocsWithFieldSet();
        this.bytesUsed = this.pending.ramBytesUsed() + this.pendingCounts.ramBytesUsed();
        iwBytesUsed.addAndGet(this.bytesUsed);
    }

    public void addValue(int docID, BytesRef value2) {
        assert (docID >= this.currentDoc);
        if (value2 == null) {
            throw new IllegalArgumentException("field \"" + this.fieldInfo.name + "\": null value not allowed");
        }
        if (value2.length > 32766) {
            throw new IllegalArgumentException("DocValuesField \"" + this.fieldInfo.name + "\" is too large, must be <= " + 32766);
        }
        if (docID != this.currentDoc) {
            this.finishCurrentDoc();
            this.currentDoc = docID;
        }
        this.addOneValue(value2);
        this.updateBytesUsed();
    }

    private void finishCurrentDoc() {
        if (this.currentDoc == -1) {
            return;
        }
        Arrays.sort(this.currentValues, 0, this.currentUpto);
        int lastValue = -1;
        int count2 = 0;
        for (int i = 0; i < this.currentUpto; ++i) {
            int termID = this.currentValues[i];
            if (termID != lastValue) {
                this.pending.add(termID);
                ++count2;
            }
            lastValue = termID;
        }
        this.pendingCounts.add(count2);
        this.maxCount = Math.max(this.maxCount, count2);
        this.currentUpto = 0;
        this.docsWithField.add(this.currentDoc);
    }

    @Override
    public void finish(int maxDoc) {
        this.finishCurrentDoc();
    }

    private void addOneValue(BytesRef value2) {
        int termID = this.hash.add(value2);
        if (termID < 0) {
            termID = -termID - 1;
        } else {
            this.iwBytesUsed.addAndGet(8L);
        }
        if (this.currentUpto == this.currentValues.length) {
            this.currentValues = ArrayUtil.grow(this.currentValues, this.currentValues.length + 1);
            this.iwBytesUsed.addAndGet((this.currentValues.length - this.currentUpto) * 4);
        }
        this.currentValues[this.currentUpto] = termID;
        ++this.currentUpto;
    }

    private void updateBytesUsed() {
        long newBytesUsed = this.pending.ramBytesUsed() + this.pendingCounts.ramBytesUsed();
        this.iwBytesUsed.addAndGet(newBytesUsed - this.bytesUsed);
        this.bytesUsed = newBytesUsed;
    }

    private long[][] sortDocValues(int maxDoc, Sorter.DocMap sortMap, SortedSetDocValues oldValues) throws IOException {
        int docID;
        long[][] ords = new long[maxDoc][];
        while ((docID = oldValues.nextDoc()) != Integer.MAX_VALUE) {
            long ord;
            int newDocID = sortMap.oldToNew(docID);
            long[] docOrds = new long[1];
            int upto = 0;
            while ((ord = oldValues.nextOrd()) != -1L) {
                if (upto == docOrds.length) {
                    docOrds = ArrayUtil.grow(docOrds);
                }
                docOrds[upto++] = ord;
            }
            ords[newDocID] = Arrays.copyOfRange(docOrds, 0, upto);
        }
        return ords;
    }

    @Override
    Sorter.DocComparator getDocComparator(int maxDoc, SortField sortField) throws IOException {
        assert (sortField instanceof SortedSetSortField);
        assert (this.finalOrds == null && this.finalOrdCounts == null && this.finalSortedValues == null && this.finalOrdMap == null);
        int valueCount = this.hash.size();
        this.finalOrds = this.pending.build();
        this.finalOrdCounts = this.pendingCounts.build();
        this.finalSortedValues = this.hash.sort();
        this.finalOrdMap = new int[valueCount];
        for (int ord = 0; ord < valueCount; ++ord) {
            this.finalOrdMap[this.finalSortedValues[ord]] = ord;
        }
        SortedSetSortField sf = (SortedSetSortField)sortField;
        BufferedSortedSetDocValues dvs = new BufferedSortedSetDocValues(this.finalSortedValues, this.finalOrdMap, this.hash, this.finalOrds, this.finalOrdCounts, this.maxCount, this.docsWithField.iterator());
        return Sorter.getDocComparator(maxDoc, sf, () -> SortedSetSelector.wrap(dvs, sf.getSelector()), () -> null);
    }

    @Override
    public void flush(SegmentWriteState state, Sorter.DocMap sortMap, DocValuesConsumer dvConsumer) throws IOException {
        int[] ordMap;
        int[] sortedValues;
        PackedLongValues ordCounts;
        PackedLongValues ords;
        int valueCount = this.hash.size();
        if (this.finalOrdCounts == null) {
            ords = this.pending.build();
            ordCounts = this.pendingCounts.build();
            sortedValues = this.hash.sort();
            ordMap = new int[valueCount];
            for (int ord = 0; ord < valueCount; ++ord) {
                ordMap[sortedValues[ord]] = ord;
            }
        } else {
            ords = this.finalOrds;
            ordCounts = this.finalOrdCounts;
            sortedValues = this.finalSortedValues;
            ordMap = this.finalOrdMap;
        }
        final long[][] sorted2 = sortMap != null ? this.sortDocValues(state.segmentInfo.maxDoc(), sortMap, new BufferedSortedSetDocValues(sortedValues, ordMap, this.hash, ords, ordCounts, this.maxCount, this.docsWithField.iterator())) : (long[][])null;
        dvConsumer.addSortedSetField(this.fieldInfo, new EmptyDocValuesProducer(){

            @Override
            public SortedSetDocValues getSortedSet(FieldInfo fieldInfoIn) {
                if (fieldInfoIn != SortedSetDocValuesWriter.this.fieldInfo) {
                    throw new IllegalArgumentException("wrong fieldInfo");
                }
                BufferedSortedSetDocValues buf = new BufferedSortedSetDocValues(sortedValues, ordMap, SortedSetDocValuesWriter.this.hash, ords, ordCounts, SortedSetDocValuesWriter.this.maxCount, SortedSetDocValuesWriter.this.docsWithField.iterator());
                if (sorted2 == null) {
                    return buf;
                }
                return new SortingLeafReader.SortingSortedSetDocValues(buf, sorted2);
            }
        });
    }

    @Override
    DocIdSetIterator getDocIdSet() {
        return this.docsWithField.iterator();
    }

    private static class BufferedSortedSetDocValues
    extends SortedSetDocValues {
        final int[] sortedValues;
        final int[] ordMap;
        final BytesRefHash hash;
        final BytesRef scratch = new BytesRef();
        final PackedLongValues.Iterator ordsIter;
        final PackedLongValues.Iterator ordCountsIter;
        final DocIdSetIterator docsWithField;
        final int[] currentDoc;
        private int ordCount;
        private int ordUpto;

        public BufferedSortedSetDocValues(int[] sortedValues, int[] ordMap, BytesRefHash hash, PackedLongValues ords, PackedLongValues ordCounts, int maxCount, DocIdSetIterator docsWithField) {
            this.currentDoc = new int[maxCount];
            this.sortedValues = sortedValues;
            this.ordMap = ordMap;
            this.hash = hash;
            this.ordsIter = ords.iterator();
            this.ordCountsIter = ordCounts.iterator();
            this.docsWithField = docsWithField;
        }

        @Override
        public int docID() {
            return this.docsWithField.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            int docID = this.docsWithField.nextDoc();
            if (docID != Integer.MAX_VALUE) {
                this.ordCount = (int)this.ordCountsIter.next();
                assert (this.ordCount > 0);
                for (int i = 0; i < this.ordCount; ++i) {
                    this.currentDoc[i] = this.ordMap[Math.toIntExact(this.ordsIter.next())];
                }
                Arrays.sort(this.currentDoc, 0, this.ordCount);
                this.ordUpto = 0;
            }
            return docID;
        }

        @Override
        public long nextOrd() {
            if (this.ordUpto == this.ordCount) {
                return -1L;
            }
            return this.currentDoc[this.ordUpto++];
        }

        @Override
        public long cost() {
            return this.docsWithField.cost();
        }

        @Override
        public int advance(int target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getValueCount() {
            return this.ordMap.length;
        }

        @Override
        public BytesRef lookupOrd(long ord) {
            assert (ord >= 0L && ord < (long)this.ordMap.length) : "ord=" + ord + " is out of bounds 0 .. " + (this.ordMap.length - 1);
            this.hash.get(this.sortedValues[Math.toIntExact(ord)], this.scratch);
            return this.scratch;
        }
    }
}

