/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.util.InfoStream;

public class SimpleMergedSegmentWarmer
implements IndexWriter.IndexReaderWarmer {
    private final InfoStream infoStream;

    public SimpleMergedSegmentWarmer(InfoStream infoStream) {
        this.infoStream = infoStream;
    }

    @Override
    public void warm(LeafReader reader) throws IOException {
        long startTime = System.currentTimeMillis();
        int indexedCount = 0;
        int docValuesCount = 0;
        int normsCount = 0;
        for (FieldInfo info2 : reader.getFieldInfos()) {
            if (info2.getIndexOptions() != IndexOptions.NONE) {
                reader.terms(info2.name);
                ++indexedCount;
                if (info2.hasNorms()) {
                    reader.getNormValues(info2.name);
                    ++normsCount;
                }
            }
            if (info2.getDocValuesType() == DocValuesType.NONE) continue;
            switch (info2.getDocValuesType()) {
                case NUMERIC: {
                    reader.getNumericDocValues(info2.name);
                    break;
                }
                case BINARY: {
                    reader.getBinaryDocValues(info2.name);
                    break;
                }
                case SORTED: {
                    reader.getSortedDocValues(info2.name);
                    break;
                }
                case SORTED_NUMERIC: {
                    reader.getSortedNumericDocValues(info2.name);
                    break;
                }
                case SORTED_SET: {
                    reader.getSortedSetDocValues(info2.name);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            ++docValuesCount;
        }
        reader.document(0);
        reader.getTermVectors(0);
        if (this.infoStream.isEnabled("SMSW")) {
            this.infoStream.message("SMSW", "Finished warming segment: " + reader + ", indexed=" + indexedCount + ", docValues=" + docValuesCount + ", norms=" + normsCount + ", time=" + (System.currentTimeMillis() - startTime));
        }
    }
}

