/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.Version;

public final class SegmentInfos
implements Cloneable,
Iterable<SegmentCommitInfo> {
    public static final int VERSION_53 = 6;
    public static final int VERSION_70 = 7;
    public static final int VERSION_72 = 8;
    public static final int VERSION_74 = 9;
    static final int VERSION_CURRENT = 9;
    public long counter;
    public long version;
    private long generation;
    private long lastGeneration;
    public Map<String, String> userData = Collections.emptyMap();
    private List<SegmentCommitInfo> segments = new ArrayList<SegmentCommitInfo>();
    private static PrintStream infoStream = null;
    private byte[] id;
    private Version luceneVersion;
    private Version minSegmentLuceneVersion;
    private final int indexCreatedVersionMajor;
    boolean pendingCommit;

    public SegmentInfos(int indexCreatedVersionMajor) {
        if (indexCreatedVersionMajor > Version.LATEST.major) {
            throw new IllegalArgumentException("indexCreatedVersionMajor is in the future: " + indexCreatedVersionMajor);
        }
        if (indexCreatedVersionMajor < 6) {
            throw new IllegalArgumentException("indexCreatedVersionMajor must be >= 6, got: " + indexCreatedVersionMajor);
        }
        this.indexCreatedVersionMajor = indexCreatedVersionMajor;
    }

    public SegmentCommitInfo info(int i) {
        return this.segments.get(i);
    }

    public static long getLastCommitGeneration(String[] files2) {
        long max2 = -1L;
        for (String file : files2) {
            long gen;
            if (!file.startsWith("segments") || file.equals("segments.gen") || (gen = SegmentInfos.generationFromSegmentsFileName(file)) <= max2) continue;
            max2 = gen;
        }
        return max2;
    }

    public static long getLastCommitGeneration(Directory directory) throws IOException {
        return SegmentInfos.getLastCommitGeneration(directory.listAll());
    }

    public static String getLastCommitSegmentsFileName(String[] files2) {
        return IndexFileNames.fileNameFromGeneration("segments", "", SegmentInfos.getLastCommitGeneration(files2));
    }

    public static String getLastCommitSegmentsFileName(Directory directory) throws IOException {
        return IndexFileNames.fileNameFromGeneration("segments", "", SegmentInfos.getLastCommitGeneration(directory));
    }

    public String getSegmentsFileName() {
        return IndexFileNames.fileNameFromGeneration("segments", "", this.lastGeneration);
    }

    public static long generationFromSegmentsFileName(String fileName) {
        if (fileName.equals("segments")) {
            return 0L;
        }
        if (fileName.startsWith("segments")) {
            return Long.parseLong(fileName.substring(1 + "segments".length()), 36);
        }
        throw new IllegalArgumentException("fileName \"" + fileName + "\" is not a segments file");
    }

    private long getNextPendingGeneration() {
        if (this.generation == -1L) {
            return 1L;
        }
        return this.generation + 1L;
    }

    public byte[] getId() {
        return (byte[])this.id.clone();
    }

    public static final SegmentInfos readCommit(Directory directory, String segmentFileName) throws IOException {
        long generation = SegmentInfos.generationFromSegmentsFileName(segmentFileName);
        Throwable throwable2 = null;
        try (ChecksumIndexInput input2 = directory.openChecksumInput(segmentFileName, IOContext.READ);){
            SegmentInfos segmentInfos = SegmentInfos.readCommit(directory, input2, generation);
            return segmentInfos;
        }
        catch (EOFException | FileNotFoundException | NoSuchFileException e) {
            try {
                throw new CorruptIndexException("Unexpected file read error while reading index.", input2, (Throwable)e);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
        }
    }

    public static final SegmentInfos readCommit(Directory directory, ChecksumIndexInput input2, long generation) throws IOException {
        int magic = input2.readInt();
        if (magic != 1071082519) {
            throw new IndexFormatTooOldException(input2, magic, 1071082519, 1071082519);
        }
        int format2 = CodecUtil.checkHeaderNoMagic(input2, "segments", 6, 9);
        byte[] id = new byte[16];
        input2.readBytes(id, 0, id.length);
        CodecUtil.checkIndexHeaderSuffix(input2, Long.toString(generation, 36));
        Version luceneVersion = Version.fromBits(input2.readVInt(), input2.readVInt(), input2.readVInt());
        if (!luceneVersion.onOrAfter(Version.LUCENE_6_0_0)) {
            throw new IndexFormatTooOldException(input2, "this index is too old (version: " + luceneVersion + ")");
        }
        int indexCreatedVersion = 6;
        if (format2 >= 7) {
            indexCreatedVersion = input2.readVInt();
        }
        SegmentInfos infos = new SegmentInfos(indexCreatedVersion);
        infos.id = id;
        infos.generation = generation;
        infos.lastGeneration = generation;
        infos.luceneVersion = luceneVersion;
        infos.version = input2.readLong();
        infos.counter = format2 > 7 ? input2.readVLong() : (long)input2.readInt();
        int numSegments = input2.readInt();
        if (numSegments < 0) {
            throw new CorruptIndexException("invalid segment count: " + numSegments, input2);
        }
        if (numSegments > 0) {
            infos.minSegmentLuceneVersion = Version.fromBits(input2.readVInt(), input2.readVInt(), input2.readVInt());
        }
        long totalDocs = 0L;
        for (int seg = 0; seg < numSegments; ++seg) {
            Map<Integer, Set<String>> dvUpdateFiles;
            int softDelCount;
            String segName = input2.readString();
            if (format2 < 7) {
                byte hasID = input2.readByte();
                if (hasID == 0) {
                    throw new IndexFormatTooOldException(input2, "Segment is from Lucene 4.x");
                }
                if (hasID != 1) {
                    throw new CorruptIndexException("invalid hasID byte, got: " + hasID, input2);
                }
            }
            byte[] segmentID = new byte[16];
            input2.readBytes(segmentID, 0, segmentID.length);
            Codec codec = SegmentInfos.readCodec(input2);
            SegmentInfo info2 = codec.segmentInfoFormat().read(directory, segName, segmentID, IOContext.READ);
            info2.setCodec(codec);
            totalDocs += (long)info2.maxDoc();
            long delGen = input2.readLong();
            int delCount = input2.readInt();
            if (delCount < 0 || delCount > info2.maxDoc()) {
                throw new CorruptIndexException("invalid deletion count: " + delCount + " vs maxDoc=" + info2.maxDoc(), input2);
            }
            long fieldInfosGen = input2.readLong();
            long dvGen = input2.readLong();
            int n = softDelCount = format2 > 8 ? input2.readInt() : 0;
            if (softDelCount < 0 || softDelCount > info2.maxDoc()) {
                throw new CorruptIndexException("invalid deletion count: " + softDelCount + " vs maxDoc=" + info2.maxDoc(), input2);
            }
            if (softDelCount + delCount > info2.maxDoc()) {
                throw new CorruptIndexException("invalid deletion count: " + softDelCount + delCount + " vs maxDoc=" + info2.maxDoc(), input2);
            }
            SegmentCommitInfo siPerCommit = new SegmentCommitInfo(info2, delCount, softDelCount, delGen, fieldInfosGen, dvGen);
            siPerCommit.setFieldInfosFiles(input2.readSetOfStrings());
            int numDVFields = input2.readInt();
            if (numDVFields == 0) {
                dvUpdateFiles = Collections.emptyMap();
            } else {
                HashMap<Integer, Set<String>> map2 = new HashMap<Integer, Set<String>>(numDVFields);
                for (int i = 0; i < numDVFields; ++i) {
                    map2.put(input2.readInt(), input2.readSetOfStrings());
                }
                dvUpdateFiles = Collections.unmodifiableMap(map2);
            }
            siPerCommit.setDocValuesUpdatesFiles(dvUpdateFiles);
            infos.add(siPerCommit);
            Version segmentVersion = info2.getVersion();
            if (!segmentVersion.onOrAfter(infos.minSegmentLuceneVersion)) {
                throw new CorruptIndexException("segments file recorded minSegmentLuceneVersion=" + infos.minSegmentLuceneVersion + " but segment=" + info2 + " has older version=" + segmentVersion, input2);
            }
            if (infos.indexCreatedVersionMajor >= 7 && segmentVersion.major < infos.indexCreatedVersionMajor) {
                throw new CorruptIndexException("segments file recorded indexCreatedVersionMajor=" + infos.indexCreatedVersionMajor + " but segment=" + info2 + " has older version=" + segmentVersion, input2);
            }
            if (infos.indexCreatedVersionMajor < 7 || info2.getMinVersion() != null) continue;
            throw new CorruptIndexException("segments infos must record minVersion with indexCreatedVersionMajor=" + infos.indexCreatedVersionMajor, input2);
        }
        infos.userData = input2.readMapOfStrings();
        CodecUtil.checkFooter(input2);
        if (totalDocs > (long)IndexWriter.getActualMaxDocs()) {
            throw new CorruptIndexException("Too many documents: an index cannot exceed " + IndexWriter.getActualMaxDocs() + " but readers have total maxDoc=" + totalDocs, input2);
        }
        return infos;
    }

    private static Codec readCodec(DataInput input2) throws IOException {
        String name = input2.readString();
        try {
            return Codec.forName(name);
        }
        catch (IllegalArgumentException e) {
            if (name.startsWith("Lucene")) {
                throw new IllegalArgumentException("Could not load codec '" + name + "'.  Did you forget to add lucene-backward-codecs.jar?", e);
            }
            throw e;
        }
    }

    public static final SegmentInfos readLatestCommit(Directory directory) throws IOException {
        return (SegmentInfos)new FindSegmentsFile<SegmentInfos>(directory){

            @Override
            protected SegmentInfos doBody(String segmentFileName) throws IOException {
                return SegmentInfos.readCommit(this.directory, segmentFileName);
            }
        }.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(Directory directory) throws IOException {
        IndexOutput segnOutput;
        String segmentFileName;
        block4: {
            long nextGeneration = this.getNextPendingGeneration();
            segmentFileName = IndexFileNames.fileNameFromGeneration("pending_segments", "", nextGeneration);
            this.generation = nextGeneration;
            segnOutput = null;
            boolean success2 = false;
            try {
                segnOutput = directory.createOutput(segmentFileName, IOContext.DEFAULT);
                this.write(directory, segnOutput);
                segnOutput.close();
                directory.sync(Collections.singleton(segmentFileName));
                success2 = true;
                if (!success2) break block4;
                this.pendingCommit = true;
            }
            catch (Throwable throwable2) {
                if (success2) {
                    this.pendingCommit = true;
                } else {
                    IOUtils.closeWhileHandlingException(segnOutput);
                    IOUtils.deleteFilesIgnoringExceptions(directory, segmentFileName);
                }
                throw throwable2;
            }
        }
        IOUtils.closeWhileHandlingException(segnOutput);
        IOUtils.deleteFilesIgnoringExceptions(directory, segmentFileName);
    }

    public void write(Directory directory, IndexOutput out) throws IOException {
        CodecUtil.writeIndexHeader(out, "segments", 9, StringHelper.randomId(), Long.toString(this.generation, 36));
        out.writeVInt(Version.LATEST.major);
        out.writeVInt(Version.LATEST.minor);
        out.writeVInt(Version.LATEST.bugfix);
        out.writeVInt(this.indexCreatedVersionMajor);
        out.writeLong(this.version);
        out.writeVLong(this.counter);
        out.writeInt(this.size());
        if (this.size() > 0) {
            Version minSegmentVersion = null;
            for (SegmentCommitInfo siPerCommit : this) {
                Version segmentVersion = siPerCommit.info.getVersion();
                if (minSegmentVersion != null && segmentVersion.onOrAfter(minSegmentVersion)) continue;
                minSegmentVersion = segmentVersion;
            }
            out.writeVInt(minSegmentVersion.major);
            out.writeVInt(minSegmentVersion.minor);
            out.writeVInt(minSegmentVersion.bugfix);
        }
        for (SegmentCommitInfo siPerCommit : this) {
            SegmentInfo si = siPerCommit.info;
            if (this.indexCreatedVersionMajor >= 7 && si.minVersion == null) {
                throw new IllegalStateException("Segments must record minVersion if they have been created on or after Lucene 7: " + si);
            }
            out.writeString(si.name);
            byte[] segmentID = si.getId();
            if (segmentID.length != 16) {
                throw new IllegalStateException("cannot write segment: invalid id segment=" + si.name + "id=" + StringHelper.idToString(segmentID));
            }
            out.writeBytes(segmentID, segmentID.length);
            out.writeString(si.getCodec().getName());
            out.writeLong(siPerCommit.getDelGen());
            int delCount = siPerCommit.getDelCount();
            if (delCount < 0 || delCount > si.maxDoc()) {
                throw new IllegalStateException("cannot write segment: invalid maxDoc segment=" + si.name + " maxDoc=" + si.maxDoc() + " delCount=" + delCount);
            }
            out.writeInt(delCount);
            out.writeLong(siPerCommit.getFieldInfosGen());
            out.writeLong(siPerCommit.getDocValuesGen());
            int softDelCount = siPerCommit.getSoftDelCount();
            if (softDelCount < 0 || softDelCount > si.maxDoc()) {
                throw new IllegalStateException("cannot write segment: invalid maxDoc segment=" + si.name + " maxDoc=" + si.maxDoc() + " softDelCount=" + softDelCount);
            }
            out.writeInt(softDelCount);
            out.writeSetOfStrings(siPerCommit.getFieldInfosFiles());
            Map<Integer, Set<String>> dvUpdatesFiles = siPerCommit.getDocValuesUpdatesFiles();
            out.writeInt(dvUpdatesFiles.size());
            for (Map.Entry<Integer, Set<String>> e : dvUpdatesFiles.entrySet()) {
                out.writeInt(e.getKey());
                out.writeSetOfStrings(e.getValue());
            }
        }
        out.writeMapOfStrings(this.userData);
        CodecUtil.writeFooter(out);
    }

    public SegmentInfos clone() {
        try {
            SegmentInfos sis = (SegmentInfos)super.clone();
            sis.segments = new ArrayList<SegmentCommitInfo>(this.size());
            for (SegmentCommitInfo info2 : this) {
                assert (info2.info.getCodec() != null);
                sis.add(info2.clone());
            }
            sis.userData = new HashMap<String, String>(this.userData);
            return sis;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("should not happen", e);
        }
    }

    public long getVersion() {
        return this.version;
    }

    public long getGeneration() {
        return this.generation;
    }

    public long getLastGeneration() {
        return this.lastGeneration;
    }

    public static void setInfoStream(PrintStream infoStream) {
        SegmentInfos.infoStream = infoStream;
    }

    public static PrintStream getInfoStream() {
        return infoStream;
    }

    private static void message(String message) {
        infoStream.println("SIS [" + Thread.currentThread().getName() + "]: " + message);
    }

    public void updateGeneration(SegmentInfos other) {
        this.lastGeneration = other.lastGeneration;
        this.generation = other.generation;
    }

    void updateGenerationVersionAndCounter(SegmentInfos other) {
        this.updateGeneration(other);
        this.version = other.version;
        this.counter = other.counter;
    }

    public void setNextWriteGeneration(long generation) {
        if (generation < this.generation) {
            throw new IllegalStateException("cannot decrease generation to " + generation + " from current generation " + this.generation);
        }
        this.generation = generation;
    }

    final void rollbackCommit(Directory dir) {
        if (this.pendingCommit) {
            this.pendingCommit = false;
            String pending = IndexFileNames.fileNameFromGeneration("pending_segments", "", this.generation);
            IOUtils.deleteFilesIgnoringExceptions(dir, pending);
        }
    }

    final void prepareCommit(Directory dir) throws IOException {
        if (this.pendingCommit) {
            throw new IllegalStateException("prepareCommit was already called");
        }
        dir.syncMetaData();
        this.write(dir);
    }

    public Collection<String> files(boolean includeSegmentsFile) throws IOException {
        String segmentFileName;
        HashSet<String> files2 = new HashSet<String>();
        if (includeSegmentsFile && (segmentFileName = this.getSegmentsFileName()) != null) {
            files2.add(segmentFileName);
        }
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            SegmentCommitInfo info2 = this.info(i);
            files2.addAll(info2.files());
        }
        return files2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String finishCommit(Directory dir) throws IOException {
        String dest;
        if (!this.pendingCommit) {
            throw new IllegalStateException("prepareCommit was not called");
        }
        boolean success2 = false;
        try {
            String src = IndexFileNames.fileNameFromGeneration("pending_segments", "", this.generation);
            dest = IndexFileNames.fileNameFromGeneration("segments", "", this.generation);
            dir.rename(src, dest);
            dir.syncMetaData();
            success2 = true;
        }
        finally {
            if (!success2) {
                this.rollbackCommit(dir);
            }
        }
        this.pendingCommit = false;
        this.lastGeneration = this.generation;
        return dest;
    }

    public final void commit(Directory dir) throws IOException {
        this.prepareCommit(dir);
        this.finishCommit(dir);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getSegmentsFileName()).append(": ");
        int count2 = this.size();
        for (int i = 0; i < count2; ++i) {
            if (i > 0) {
                buffer.append(' ');
            }
            SegmentCommitInfo info2 = this.info(i);
            buffer.append(info2.toString(0));
        }
        return buffer.toString();
    }

    public Map<String, String> getUserData() {
        return this.userData;
    }

    public void setUserData(Map<String, String> data, boolean doIncrementVersion) {
        this.userData = data == null ? Collections.emptyMap() : data;
        if (doIncrementVersion) {
            this.changed();
        }
    }

    void replace(SegmentInfos other) {
        this.rollbackSegmentInfos(other.asList());
        this.lastGeneration = other.lastGeneration;
    }

    public int totalMaxDoc() {
        long count2 = 0L;
        for (SegmentCommitInfo info2 : this) {
            count2 += (long)info2.info.maxDoc();
        }
        assert (count2 <= (long)IndexWriter.getActualMaxDocs());
        return Math.toIntExact(count2);
    }

    public void changed() {
        ++this.version;
    }

    void setVersion(long newVersion) {
        if (newVersion < this.version) {
            throw new IllegalArgumentException("newVersion (=" + newVersion + ") cannot be less than current version (=" + this.version + ")");
        }
        this.version = newVersion;
    }

    void applyMergeChanges(MergePolicy.OneMerge merge2, boolean dropSegment) {
        if (this.indexCreatedVersionMajor >= 7 && merge2.info.info.minVersion == null) {
            throw new IllegalArgumentException("All segments must record the minVersion for indices created on or after Lucene 7");
        }
        HashSet<SegmentCommitInfo> mergedAway = new HashSet<SegmentCommitInfo>(merge2.segments);
        boolean inserted = false;
        int newSegIdx = 0;
        int cnt = this.segments.size();
        for (int segIdx = 0; segIdx < cnt; ++segIdx) {
            assert (segIdx >= newSegIdx);
            SegmentCommitInfo info2 = this.segments.get(segIdx);
            if (mergedAway.contains(info2)) {
                if (inserted || dropSegment) continue;
                this.segments.set(segIdx, merge2.info);
                inserted = true;
                ++newSegIdx;
                continue;
            }
            this.segments.set(newSegIdx, info2);
            ++newSegIdx;
        }
        this.segments.subList(newSegIdx, this.segments.size()).clear();
        if (!inserted && !dropSegment) {
            this.segments.add(0, merge2.info);
        }
    }

    List<SegmentCommitInfo> createBackupSegmentInfos() {
        ArrayList<SegmentCommitInfo> list2 = new ArrayList<SegmentCommitInfo>(this.size());
        for (SegmentCommitInfo info2 : this) {
            assert (info2.info.getCodec() != null);
            list2.add(info2.clone());
        }
        return list2;
    }

    void rollbackSegmentInfos(List<SegmentCommitInfo> infos) {
        this.clear();
        this.addAll(infos);
    }

    @Override
    public Iterator<SegmentCommitInfo> iterator() {
        return this.asList().iterator();
    }

    public List<SegmentCommitInfo> asList() {
        return Collections.unmodifiableList(this.segments);
    }

    public int size() {
        return this.segments.size();
    }

    public void add(SegmentCommitInfo si) {
        if (this.indexCreatedVersionMajor >= 7 && si.info.minVersion == null) {
            throw new IllegalArgumentException("All segments must record the minVersion for indices created on or after Lucene 7");
        }
        this.segments.add(si);
    }

    public void addAll(Iterable<SegmentCommitInfo> sis) {
        for (SegmentCommitInfo si : sis) {
            this.add(si);
        }
    }

    public void clear() {
        this.segments.clear();
    }

    public boolean remove(SegmentCommitInfo si) {
        return this.segments.remove(si);
    }

    void remove(int index2) {
        this.segments.remove(index2);
    }

    boolean contains(SegmentCommitInfo si) {
        return this.segments.contains(si);
    }

    int indexOf(SegmentCommitInfo si) {
        return this.segments.indexOf(si);
    }

    public Version getCommitLuceneVersion() {
        return this.luceneVersion;
    }

    public Version getMinSegmentLuceneVersion() {
        return this.minSegmentLuceneVersion;
    }

    public int getIndexCreatedVersionMajor() {
        return this.indexCreatedVersionMajor;
    }

    public static abstract class FindSegmentsFile<T> {
        final Directory directory;

        public FindSegmentsFile(Directory directory) {
            this.directory = directory;
        }

        public T run() throws IOException {
            return this.run(null);
        }

        public T run(IndexCommit commit2) throws IOException {
            if (commit2 != null) {
                if (this.directory != commit2.getDirectory()) {
                    throw new IOException("the specified commit does not match the specified Directory");
                }
                return this.doBody(commit2.getSegmentsFileName());
            }
            long lastGen = -1L;
            long gen = -1L;
            IOException exc = null;
            while (true) {
                lastGen = gen;
                Object[] files2 = this.directory.listAll();
                Object[] files22 = this.directory.listAll();
                Arrays.sort(files2);
                Arrays.sort(files22);
                if (!Arrays.equals(files2, files22)) continue;
                gen = SegmentInfos.getLastCommitGeneration((String[])files2);
                if (infoStream != null) {
                    SegmentInfos.message("directory listing gen=" + gen);
                }
                if (gen == -1L) {
                    throw new IndexNotFoundException("no segments* file found in " + this.directory + ": files: " + Arrays.toString(files2));
                }
                if (gen <= lastGen) break;
                String segmentFileName = IndexFileNames.fileNameFromGeneration("segments", "", gen);
                try {
                    T t = this.doBody(segmentFileName);
                    if (infoStream != null) {
                        SegmentInfos.message("success on " + segmentFileName);
                    }
                    return t;
                }
                catch (IOException err2) {
                    if (exc == null) {
                        exc = err2;
                    }
                    if (infoStream == null) continue;
                    SegmentInfos.message("primary Exception on '" + segmentFileName + "': " + err2 + "'; will retry: gen = " + gen);
                    continue;
                }
                break;
            }
            throw exc;
        }

        protected abstract T doBody(String var1) throws IOException;
    }
}

