/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.List;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;

public final class ReaderUtil {
    private ReaderUtil() {
    }

    public static IndexReaderContext getTopLevelContext(IndexReaderContext context) {
        while (context.parent != null) {
            context = context.parent;
        }
        return context;
    }

    public static int subIndex(int n, int[] docStarts) {
        int size2 = docStarts.length;
        int lo2 = 0;
        int hi2 = size2 - 1;
        while (hi2 >= lo2) {
            int mid = lo2 + hi2 >>> 1;
            int midValue = docStarts[mid];
            if (n < midValue) {
                hi2 = mid - 1;
                continue;
            }
            if (n > midValue) {
                lo2 = mid + 1;
                continue;
            }
            while (mid + 1 < size2 && docStarts[mid + 1] == midValue) {
                ++mid;
            }
            return mid;
        }
        return hi2;
    }

    public static int subIndex(int n, List<LeafReaderContext> leaves) {
        int size2 = leaves.size();
        int lo2 = 0;
        int hi2 = size2 - 1;
        while (hi2 >= lo2) {
            int mid = lo2 + hi2 >>> 1;
            int midValue = leaves.get((int)mid).docBase;
            if (n < midValue) {
                hi2 = mid - 1;
                continue;
            }
            if (n > midValue) {
                lo2 = mid + 1;
                continue;
            }
            while (mid + 1 < size2 && leaves.get((int)(mid + 1)).docBase == midValue) {
                ++mid;
            }
            return mid;
        }
        return hi2;
    }
}

