/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.codecs.FieldInfosFormat;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.DocValuesFieldUpdates;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.PendingDeletes;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IOSupplier;
import org.apache.lucene.util.IOUtils;

final class PendingSoftDeletes
extends PendingDeletes {
    private final String field;
    private long dvGeneration = -2L;
    private final PendingDeletes hardDeletes;

    PendingSoftDeletes(String field2, SegmentCommitInfo info2) {
        super(info2);
        this.field = field2;
        this.hardDeletes = new PendingDeletes(info2);
    }

    PendingSoftDeletes(String field2, SegmentReader reader, SegmentCommitInfo info2) {
        super(reader, info2);
        this.field = field2;
        this.hardDeletes = new PendingDeletes(reader, info2);
    }

    @Override
    boolean delete(int docID) throws IOException {
        FixedBitSet mutableBits = this.getMutableBits();
        if (this.hardDeletes.delete(docID)) {
            if (mutableBits.get(docID)) {
                mutableBits.clear(docID);
                assert (!this.hardDeletes.delete(docID));
            } else {
                --this.pendingDeleteCount;
                assert (this.assertPendingDeletes());
            }
            return true;
        }
        return false;
    }

    @Override
    protected int numPendingDeletes() {
        return super.numPendingDeletes() + this.hardDeletes.numPendingDeletes();
    }

    @Override
    void onNewReader(CodecReader reader, SegmentCommitInfo info2) throws IOException {
        super.onNewReader(reader, info2);
        this.hardDeletes.onNewReader(reader, info2);
        if (this.dvGeneration < info2.getDocValuesGen()) {
            int newDelCount;
            DocIdSetIterator iterator2 = DocValuesFieldExistsQuery.getDocValuesDocIdSetIterator(this.field, reader);
            if (iterator2 != null) {
                assert (info2.info.maxDoc() > 0) : "maxDoc is 0";
                newDelCount = PendingSoftDeletes.applySoftDeletes(iterator2, this.getMutableBits());
                assert (newDelCount >= 0) : " illegal pending delete count: " + newDelCount;
            } else {
                newDelCount = 0;
            }
            assert (info2.getSoftDelCount() == newDelCount) : "softDeleteCount doesn't match " + info2.getSoftDelCount() + " != " + newDelCount;
            this.dvGeneration = info2.getDocValuesGen();
        }
        assert (this.getDelCount() <= info2.info.maxDoc()) : this.getDelCount() + " > " + info2.info.maxDoc();
    }

    @Override
    boolean writeLiveDocs(Directory dir) throws IOException {
        this.info.setSoftDelCount(this.info.getSoftDelCount() + this.pendingDeleteCount);
        super.dropChanges();
        return this.hardDeletes.writeLiveDocs(dir);
    }

    @Override
    void dropChanges() {
        this.hardDeletes.dropChanges();
    }

    static int applySoftDeletes(DocIdSetIterator iterator2, FixedBitSet bits2) throws IOException {
        int docID;
        DocValuesFieldUpdates.Iterator hasValue2;
        assert (iterator2 != null);
        int newDeletes = 0;
        DocValuesFieldUpdates.Iterator iterator3 = hasValue2 = iterator2 instanceof DocValuesFieldUpdates.Iterator ? (DocValuesFieldUpdates.Iterator)iterator2 : null;
        while ((docID = iterator2.nextDoc()) != Integer.MAX_VALUE) {
            if (hasValue2 == null || hasValue2.hasValue()) {
                if (!bits2.get(docID)) continue;
                bits2.clear(docID);
                ++newDeletes;
                continue;
            }
            if (bits2.get(docID)) continue;
            bits2.set(docID);
            --newDeletes;
        }
        return newDeletes;
    }

    @Override
    void onDocValuesUpdate(FieldInfo info2, DocValuesFieldUpdates.Iterator iterator2) throws IOException {
        if (this.field.equals(info2.name)) {
            this.pendingDeleteCount += PendingSoftDeletes.applySoftDeletes(iterator2, this.getMutableBits());
            assert (this.assertPendingDeletes());
            assert (this.dvGeneration < info2.getDocValuesGen()) : "we have seen this generation update already: " + this.dvGeneration + " vs. " + info2.getDocValuesGen();
            assert (this.dvGeneration != -2L) : "docValues generation is still uninitialized";
            this.dvGeneration = info2.getDocValuesGen();
            this.info.setSoftDelCount(this.info.getSoftDelCount() + this.pendingDeleteCount);
            super.dropChanges();
        }
    }

    private boolean assertPendingDeletes() {
        assert (this.pendingDeleteCount + this.info.getSoftDelCount() >= 0) : " illegal pending delete count: " + this.pendingDeleteCount + this.info.getSoftDelCount();
        assert (this.info.info.maxDoc() >= this.getDelCount());
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PendingSoftDeletes(seg=").append(this.info);
        sb.append(" numPendingDeletes=").append(this.pendingDeleteCount);
        sb.append(" field=").append(this.field);
        sb.append(" dvGeneration=").append(this.dvGeneration);
        sb.append(" hardDeletes=").append(this.hardDeletes);
        return sb.toString();
    }

    @Override
    int numDeletesToMerge(MergePolicy policy, IOSupplier<CodecReader> readerIOSupplier) throws IOException {
        this.ensureInitialized(readerIOSupplier);
        return super.numDeletesToMerge(policy, readerIOSupplier);
    }

    private void ensureInitialized(IOSupplier<CodecReader> readerIOSupplier) throws IOException {
        if (this.dvGeneration == -2L) {
            FieldInfos fieldInfos = this.readFieldInfos();
            FieldInfo fieldInfo = fieldInfos.fieldInfo(this.field);
            if (fieldInfo != null && fieldInfo.getDocValuesType() != DocValuesType.NONE) {
                this.onNewReader(readerIOSupplier.get(), this.info);
            } else {
                this.dvGeneration = fieldInfo == null ? -1L : fieldInfo.getDocValuesGen();
            }
        }
    }

    @Override
    boolean isFullyDeleted(IOSupplier<CodecReader> readerIOSupplier) throws IOException {
        this.ensureInitialized(readerIOSupplier);
        return super.isFullyDeleted(readerIOSupplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FieldInfos readFieldInfos() throws IOException {
        SegmentInfo segInfo = this.info.info;
        Directory dir = segInfo.dir;
        if (!this.info.hasFieldUpdates()) {
            FieldInfos fieldInfos;
            Directory toClose;
            if (segInfo.getUseCompoundFile()) {
                toClose = dir = segInfo.getCodec().compoundFormat().getCompoundReader(segInfo.dir, segInfo, IOContext.READONCE);
            } else {
                toClose = null;
                dir = segInfo.dir;
            }
            try {
                fieldInfos = segInfo.getCodec().fieldInfosFormat().read(dir, segInfo, "", IOContext.READONCE);
            }
            catch (Throwable throwable2) {
                IOUtils.close(toClose);
                throw throwable2;
            }
            IOUtils.close(toClose);
            return fieldInfos;
        }
        FieldInfosFormat fisFormat = segInfo.getCodec().fieldInfosFormat();
        String segmentSuffix = Long.toString(this.info.getFieldInfosGen(), 36);
        return fisFormat.read(dir, segInfo, segmentSuffix, IOContext.READONCE);
    }

    @Override
    Bits getHardLiveDocs() {
        return this.hardDeletes.getLiveDocs();
    }

    static int countSoftDeletes(DocIdSetIterator softDeletedDocs, Bits hardDeletes) throws IOException {
        int count2 = 0;
        if (softDeletedDocs != null) {
            int doc;
            while ((doc = softDeletedDocs.nextDoc()) != Integer.MAX_VALUE) {
                if (hardDeletes != null && !hardDeletes.get(doc)) continue;
                ++count2;
            }
        }
        return count2;
    }
}

