/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.index.DocValuesFieldUpdates;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PagedGrowableWriter;
import org.apache.lucene.util.packed.PagedMutable;

final class NumericDocValuesFieldUpdates
extends DocValuesFieldUpdates {
    private PagedGrowableWriter values = new PagedGrowableWriter(1L, 1024, 1, 0.5f);

    public NumericDocValuesFieldUpdates(long delGen, String field2, int maxDoc) {
        super(maxDoc, delGen, field2, DocValuesType.NUMERIC);
    }

    @Override
    void add(int doc, BytesRef value2) {
        throw new UnsupportedOperationException();
    }

    @Override
    void add(int docId, DocValuesFieldUpdates.Iterator iterator2) {
        this.add(docId, iterator2.longValue());
    }

    @Override
    synchronized void add(int doc, long value2) {
        int add2 = this.add(doc);
        this.values.set(add2, value2);
    }

    @Override
    protected void swap(int i, int j) {
        super.swap(i, j);
        long tmpVal = this.values.get(j);
        this.values.set(j, this.values.get(i));
        this.values.set(i, tmpVal);
    }

    @Override
    protected void grow(int size2) {
        super.grow(size2);
        this.values = (PagedGrowableWriter)this.values.grow(size2);
    }

    @Override
    protected void resize(int size2) {
        super.resize(size2);
        this.values = (PagedGrowableWriter)this.values.resize(size2);
    }

    @Override
    Iterator iterator() {
        this.ensureFinished();
        return new Iterator(this.size, this.values, this.docs, this.delGen);
    }

    @Override
    public long ramBytesUsed() {
        return this.values.ramBytesUsed() + super.ramBytesUsed() + 8L + (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF;
    }

    static final class Iterator
    extends DocValuesFieldUpdates.AbstractIterator {
        private final PagedGrowableWriter values;
        private long value;

        Iterator(int size2, PagedGrowableWriter values2, PagedMutable docs, long delGen) {
            super(size2, docs, delGen);
            this.values = values2;
        }

        @Override
        long longValue() {
            return this.value;
        }

        @Override
        BytesRef binaryValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void set(long idx) {
            this.value = this.values.get(idx);
        }
    }
}

