/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.lucene.index.MultiPostingsEnum;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.ReaderSlice;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.PriorityQueue;

public final class MultiTermsEnum
extends TermsEnum {
    private static final Comparator<TermsEnumWithSlice> INDEX_COMPARATOR = new Comparator<TermsEnumWithSlice>(){

        @Override
        public int compare(TermsEnumWithSlice o1, TermsEnumWithSlice o2) {
            return o1.index - o2.index;
        }
    };
    private final TermMergeQueue queue;
    private final TermsEnumWithSlice[] subs;
    private final TermsEnumWithSlice[] currentSubs;
    private final TermsEnumWithSlice[] top;
    private final MultiPostingsEnum.EnumWithSlice[] subDocs;
    private BytesRef lastSeek;
    private boolean lastSeekExact;
    private final BytesRefBuilder lastSeekScratch = new BytesRefBuilder();
    private int numTop;
    private int numSubs;
    private BytesRef current;

    public int getMatchCount() {
        return this.numTop;
    }

    public TermsEnumWithSlice[] getMatchArray() {
        return this.top;
    }

    public MultiTermsEnum(ReaderSlice[] slices) {
        this.queue = new TermMergeQueue(slices.length);
        this.top = new TermsEnumWithSlice[slices.length];
        this.subs = new TermsEnumWithSlice[slices.length];
        this.subDocs = new MultiPostingsEnum.EnumWithSlice[slices.length];
        for (int i = 0; i < slices.length; ++i) {
            this.subs[i] = new TermsEnumWithSlice(i, slices[i]);
            this.subDocs[i] = new MultiPostingsEnum.EnumWithSlice();
            this.subDocs[i].slice = slices[i];
        }
        this.currentSubs = new TermsEnumWithSlice[slices.length];
    }

    @Override
    public BytesRef term() {
        return this.current;
    }

    public TermsEnum reset(TermsEnumIndex[] termsEnumsIndex) throws IOException {
        assert (termsEnumsIndex.length <= this.top.length);
        this.numSubs = 0;
        this.numTop = 0;
        this.queue.clear();
        for (int i = 0; i < termsEnumsIndex.length; ++i) {
            TermsEnumIndex termsEnumIndex = termsEnumsIndex[i];
            assert (termsEnumIndex != null);
            BytesRef term = termsEnumIndex.termsEnum.next();
            if (term == null) continue;
            TermsEnumWithSlice entry2 = this.subs[termsEnumIndex.subIndex];
            entry2.reset(termsEnumIndex.termsEnum, term);
            this.queue.add(entry2);
            this.currentSubs[this.numSubs++] = entry2;
        }
        if (this.queue.size() == 0) {
            return TermsEnum.EMPTY;
        }
        return this;
    }

    @Override
    public boolean seekExact(BytesRef term) throws IOException {
        this.queue.clear();
        this.numTop = 0;
        boolean seekOpt = false;
        if (this.lastSeek != null && this.lastSeek.compareTo(term) <= 0) {
            seekOpt = true;
        }
        this.lastSeek = null;
        this.lastSeekExact = true;
        for (int i = 0; i < this.numSubs; ++i) {
            int cmp;
            BytesRef curTerm;
            boolean status = seekOpt ? ((curTerm = this.currentSubs[i].current) != null ? ((cmp = term.compareTo(curTerm)) == 0 ? true : (cmp < 0 ? false : this.currentSubs[i].terms.seekExact(term))) : false) : this.currentSubs[i].terms.seekExact(term);
            if (!status) continue;
            this.top[this.numTop++] = this.currentSubs[i];
            this.current = this.currentSubs[i].current = this.currentSubs[i].terms.term();
            assert (term.equals(this.currentSubs[i].current));
        }
        return this.numTop > 0;
    }

    @Override
    public TermsEnum.SeekStatus seekCeil(BytesRef term) throws IOException {
        this.queue.clear();
        this.numTop = 0;
        this.lastSeekExact = false;
        boolean seekOpt = false;
        if (this.lastSeek != null && this.lastSeek.compareTo(term) <= 0) {
            seekOpt = true;
        }
        this.lastSeekScratch.copyBytes(term);
        this.lastSeek = this.lastSeekScratch.get();
        for (int i = 0; i < this.numSubs; ++i) {
            int cmp;
            BytesRef curTerm;
            TermsEnum.SeekStatus status = seekOpt ? ((curTerm = this.currentSubs[i].current) != null ? ((cmp = term.compareTo(curTerm)) == 0 ? TermsEnum.SeekStatus.FOUND : (cmp < 0 ? TermsEnum.SeekStatus.NOT_FOUND : this.currentSubs[i].terms.seekCeil(term))) : TermsEnum.SeekStatus.END) : this.currentSubs[i].terms.seekCeil(term);
            if (status == TermsEnum.SeekStatus.FOUND) {
                this.top[this.numTop++] = this.currentSubs[i];
                this.current = this.currentSubs[i].current = this.currentSubs[i].terms.term();
                this.queue.add(this.currentSubs[i]);
                continue;
            }
            if (status == TermsEnum.SeekStatus.NOT_FOUND) {
                this.currentSubs[i].current = this.currentSubs[i].terms.term();
                assert (this.currentSubs[i].current != null);
                this.queue.add(this.currentSubs[i]);
                continue;
            }
            assert (status == TermsEnum.SeekStatus.END);
            this.currentSubs[i].current = null;
        }
        if (this.numTop > 0) {
            return TermsEnum.SeekStatus.FOUND;
        }
        if (this.queue.size() > 0) {
            this.pullTop();
            return TermsEnum.SeekStatus.NOT_FOUND;
        }
        return TermsEnum.SeekStatus.END;
    }

    @Override
    public void seekExact(long ord) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long ord() {
        throw new UnsupportedOperationException();
    }

    private void pullTop() {
        assert (this.numTop == 0);
        this.numTop = this.queue.fillTop(this.top);
        this.current = this.top[0].current;
    }

    private void pushTop() throws IOException {
        for (int i = 0; i < this.numTop; ++i) {
            TermsEnumWithSlice top = (TermsEnumWithSlice)this.queue.top();
            top.current = top.terms.next();
            if (top.current == null) {
                this.queue.pop();
                continue;
            }
            this.queue.updateTop();
        }
        this.numTop = 0;
    }

    @Override
    public BytesRef next() throws IOException {
        if (this.lastSeekExact) {
            TermsEnum.SeekStatus status = this.seekCeil(this.current);
            assert (status == TermsEnum.SeekStatus.FOUND);
            this.lastSeekExact = false;
        }
        this.lastSeek = null;
        this.pushTop();
        if (this.queue.size() > 0) {
            this.pullTop();
        } else {
            this.current = null;
        }
        return this.current;
    }

    @Override
    public int docFreq() throws IOException {
        int sum2 = 0;
        for (int i = 0; i < this.numTop; ++i) {
            sum2 += this.top[i].terms.docFreq();
        }
        return sum2;
    }

    @Override
    public long totalTermFreq() throws IOException {
        long sum2 = 0L;
        for (int i = 0; i < this.numTop; ++i) {
            long v = this.top[i].terms.totalTermFreq();
            if (v == -1L) {
                return v;
            }
            sum2 += v;
        }
        return sum2;
    }

    @Override
    public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
        MultiPostingsEnum docsEnum;
        if (reuse != null && reuse instanceof MultiPostingsEnum) {
            docsEnum = (MultiPostingsEnum)reuse;
            if (!docsEnum.canReuse(this)) {
                docsEnum = new MultiPostingsEnum(this, this.subs.length);
            }
        } else {
            docsEnum = new MultiPostingsEnum(this, this.subs.length);
        }
        int upto = 0;
        ArrayUtil.timSort(this.top, 0, this.numTop, INDEX_COMPARATOR);
        for (int i = 0; i < this.numTop; ++i) {
            TermsEnumWithSlice entry2 = this.top[i];
            assert (entry2.index < docsEnum.subPostingsEnums.length) : entry2.index + " vs " + docsEnum.subPostingsEnums.length + "; " + this.subs.length;
            PostingsEnum subPostingsEnum = entry2.terms.postings(docsEnum.subPostingsEnums[entry2.index], flags);
            assert (subPostingsEnum != null);
            docsEnum.subPostingsEnums[entry2.index] = subPostingsEnum;
            this.subDocs[upto].postingsEnum = subPostingsEnum;
            this.subDocs[upto].slice = entry2.subSlice;
            ++upto;
        }
        return docsEnum.reset(this.subDocs, upto);
    }

    public String toString() {
        return "MultiTermsEnum(" + Arrays.toString(this.subs) + ")";
    }

    private static final class TermMergeQueue
    extends PriorityQueue<TermsEnumWithSlice> {
        final int[] stack;

        TermMergeQueue(int size2) {
            super(size2);
            this.stack = new int[size2];
        }

        @Override
        protected boolean lessThan(TermsEnumWithSlice termsA, TermsEnumWithSlice termsB) {
            return termsA.current.compareTo(termsB.current) < 0;
        }

        int fillTop(TermsEnumWithSlice[] tops) {
            int size2 = this.size();
            if (size2 == 0) {
                return 0;
            }
            tops[0] = (TermsEnumWithSlice)this.top();
            int numTop = 1;
            this.stack[0] = 1;
            int stackLen = 1;
            while (stackLen != 0) {
                int leftChild;
                int index2 = this.stack[--stackLen];
                int end = Math.min(size2, leftChild + 1);
                for (int child = leftChild = index2 << 1; child <= end; ++child) {
                    TermsEnumWithSlice te = this.get(child);
                    if (!te.current.equals(tops[0].current)) continue;
                    tops[numTop++] = te;
                    this.stack[stackLen++] = child;
                }
            }
            return numTop;
        }

        private TermsEnumWithSlice get(int i) {
            return (TermsEnumWithSlice)this.getHeapArray()[i];
        }
    }

    static final class TermsEnumWithSlice {
        private final ReaderSlice subSlice;
        TermsEnum terms;
        public BytesRef current;
        final int index;

        public TermsEnumWithSlice(int index2, ReaderSlice subSlice) {
            this.subSlice = subSlice;
            this.index = index2;
            assert (subSlice.length >= 0) : "length=" + subSlice.length;
        }

        public void reset(TermsEnum terms, BytesRef term) {
            this.terms = terms;
            this.current = term;
        }

        public String toString() {
            return this.subSlice.toString() + ":" + this.terms;
        }
    }

    static class TermsEnumIndex {
        public static final TermsEnumIndex[] EMPTY_ARRAY = new TermsEnumIndex[0];
        final int subIndex;
        final TermsEnum termsEnum;

        public TermsEnumIndex(TermsEnum termsEnum, int subIndex) {
            this.termsEnum = termsEnum;
            this.subIndex = subIndex;
        }
    }
}

