/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.PriorityQueue;
import org.apache.lucene.util.packed.PackedLongValues;

final class MultiSorter {
    MultiSorter() {
    }

    static MergeState.DocMap[] sort(Sort sort2, List<CodecReader> readers) throws IOException {
        SortField[] fields = sort2.getSort();
        final ComparableProvider[][] comparables = new ComparableProvider[fields.length][];
        for (int i = 0; i < fields.length; ++i) {
            comparables[i] = MultiSorter.getComparableProviders(readers, fields[i]);
        }
        int leafCount = readers.size();
        PriorityQueue<LeafAndDocID> queue = new PriorityQueue<LeafAndDocID>(leafCount){

            @Override
            public boolean lessThan(LeafAndDocID a, LeafAndDocID b) {
                for (int i = 0; i < comparables.length; ++i) {
                    int cmp = a.values[i].compareTo(b.values[i]);
                    if (cmp == 0) continue;
                    return cmp < 0;
                }
                if (a.readerIndex != b.readerIndex) {
                    return a.readerIndex < b.readerIndex;
                }
                return a.docID < b.docID;
            }
        };
        PackedLongValues.Builder[] builders = new PackedLongValues.Builder[leafCount];
        for (int i = 0; i < leafCount; ++i) {
            CodecReader reader = readers.get(i);
            LeafAndDocID leaf = new LeafAndDocID(i, reader.getLiveDocs(), reader.maxDoc(), comparables.length);
            for (int j = 0; j < comparables.length; ++j) {
                leaf.values[j] = comparables[j][i].getComparable(leaf.docID);
                assert (leaf.values[j] != null);
            }
            queue.add(leaf);
            builders[i] = PackedLongValues.monotonicBuilder(0.0f);
        }
        int mappedDocID = 0;
        int lastReaderIndex = 0;
        boolean isSorted = true;
        while (queue.size() != 0) {
            LeafAndDocID top = (LeafAndDocID)queue.top();
            if (lastReaderIndex > top.readerIndex) {
                isSorted = false;
            }
            lastReaderIndex = top.readerIndex;
            builders[top.readerIndex].add(mappedDocID);
            if (top.liveDocs == null || top.liveDocs.get(top.docID)) {
                ++mappedDocID;
            }
            ++top.docID;
            if (top.docID < top.maxDoc) {
                for (int j = 0; j < comparables.length; ++j) {
                    top.values[j] = comparables[j][top.readerIndex].getComparable(top.docID);
                    assert (top.values[j] != null);
                }
                queue.updateTop();
                continue;
            }
            queue.pop();
        }
        if (isSorted) {
            return null;
        }
        MergeState.DocMap[] docMaps = new MergeState.DocMap[leafCount];
        for (int i = 0; i < leafCount; ++i) {
            final PackedLongValues remapped = builders[i].build();
            final Bits liveDocs = readers.get(i).getLiveDocs();
            docMaps[i] = new MergeState.DocMap(){

                @Override
                public int get(int docID) {
                    if (liveDocs == null || liveDocs.get(docID)) {
                        return (int)remapped.get(docID);
                    }
                    return -1;
                }
            };
        }
        return docMaps;
    }

    private static ComparableProvider[] getComparableProviders(List<CodecReader> readers, SortField sortField) throws IOException {
        ComparableProvider[] providers = new ComparableProvider[readers.size()];
        final int reverseMul = sortField.getReverse() ? -1 : 1;
        SortField.Type sortType = Sorter.getSortFieldType(sortField);
        switch (sortType) {
            case STRING: {
                SortedDocValues[] values2 = new SortedDocValues[readers.size()];
                for (int i = 0; i < readers.size(); ++i) {
                    SortedDocValues sorted2;
                    values2[i] = sorted2 = Sorter.getOrWrapSorted(readers.get(i), sortField);
                }
                OrdinalMap ordinalMap = OrdinalMap.build(null, values2, 0.25f);
                final int missingOrd = sortField.getMissingValue() == SortField.STRING_LAST ? (sortField.getReverse() ? Integer.MIN_VALUE : Integer.MAX_VALUE) : (sortField.getReverse() ? Integer.MAX_VALUE : Integer.MIN_VALUE);
                for (int readerIndex = 0; readerIndex < readers.size(); ++readerIndex) {
                    final SortedDocValues readerValues = values2[readerIndex];
                    final LongValues globalOrds = ordinalMap.getGlobalOrds(readerIndex);
                    providers[readerIndex] = new ComparableProvider(){
                        int lastDocID = -1;

                        private boolean docsInOrder(int docID) {
                            if (docID < this.lastDocID) {
                                throw new AssertionError((Object)("docs must be sent in order, but lastDocID=" + this.lastDocID + " vs docID=" + docID));
                            }
                            this.lastDocID = docID;
                            return true;
                        }

                        @Override
                        public Comparable getComparable(int docID) throws IOException {
                            assert (this.docsInOrder(docID));
                            int readerDocID = readerValues.docID();
                            if (readerDocID < docID) {
                                readerDocID = readerValues.advance(docID);
                            }
                            if (readerDocID == docID) {
                                return Integer.valueOf(reverseMul * (int)globalOrds.get(readerValues.ordValue()));
                            }
                            return Integer.valueOf(missingOrd);
                        }
                    };
                }
                break;
            }
            case LONG: {
                final Long missingValue = sortField.getMissingValue() != null ? (Long)sortField.getMissingValue() : Long.valueOf(0L);
                for (int readerIndex = 0; readerIndex < readers.size(); ++readerIndex) {
                    final NumericDocValues values3 = Sorter.getOrWrapNumeric(readers.get(readerIndex), sortField);
                    providers[readerIndex] = new ComparableProvider(){
                        int lastDocID = -1;

                        private boolean docsInOrder(int docID) {
                            if (docID < this.lastDocID) {
                                throw new AssertionError((Object)("docs must be sent in order, but lastDocID=" + this.lastDocID + " vs docID=" + docID));
                            }
                            this.lastDocID = docID;
                            return true;
                        }

                        @Override
                        public Comparable getComparable(int docID) throws IOException {
                            assert (this.docsInOrder(docID));
                            int readerDocID = values3.docID();
                            if (readerDocID < docID) {
                                readerDocID = values3.advance(docID);
                            }
                            if (readerDocID == docID) {
                                return Long.valueOf((long)reverseMul * values3.longValue());
                            }
                            return Long.valueOf((long)reverseMul * missingValue);
                        }
                    };
                }
                break;
            }
            case INT: {
                final Integer missingValue = sortField.getMissingValue() != null ? (Integer)sortField.getMissingValue() : Integer.valueOf(0);
                for (int readerIndex = 0; readerIndex < readers.size(); ++readerIndex) {
                    final NumericDocValues values4 = Sorter.getOrWrapNumeric(readers.get(readerIndex), sortField);
                    providers[readerIndex] = new ComparableProvider(){
                        int lastDocID = -1;

                        private boolean docsInOrder(int docID) {
                            if (docID < this.lastDocID) {
                                throw new AssertionError((Object)("docs must be sent in order, but lastDocID=" + this.lastDocID + " vs docID=" + docID));
                            }
                            this.lastDocID = docID;
                            return true;
                        }

                        @Override
                        public Comparable getComparable(int docID) throws IOException {
                            assert (this.docsInOrder(docID));
                            int readerDocID = values4.docID();
                            if (readerDocID < docID) {
                                readerDocID = values4.advance(docID);
                            }
                            if (readerDocID == docID) {
                                return Integer.valueOf(reverseMul * (int)values4.longValue());
                            }
                            return Integer.valueOf(reverseMul * missingValue);
                        }
                    };
                }
                break;
            }
            case DOUBLE: {
                final Double missingValue = sortField.getMissingValue() != null ? (Double)sortField.getMissingValue() : Double.valueOf(0.0);
                for (int readerIndex = 0; readerIndex < readers.size(); ++readerIndex) {
                    final NumericDocValues values5 = Sorter.getOrWrapNumeric(readers.get(readerIndex), sortField);
                    providers[readerIndex] = new ComparableProvider(){
                        int lastDocID = -1;

                        private boolean docsInOrder(int docID) {
                            if (docID < this.lastDocID) {
                                throw new AssertionError((Object)("docs must be sent in order, but lastDocID=" + this.lastDocID + " vs docID=" + docID));
                            }
                            this.lastDocID = docID;
                            return true;
                        }

                        @Override
                        public Comparable getComparable(int docID) throws IOException {
                            assert (this.docsInOrder(docID));
                            int readerDocID = values5.docID();
                            if (readerDocID < docID) {
                                readerDocID = values5.advance(docID);
                            }
                            if (readerDocID == docID) {
                                return Double.valueOf((double)reverseMul * Double.longBitsToDouble(values5.longValue()));
                            }
                            return Double.valueOf((double)reverseMul * missingValue);
                        }
                    };
                }
                break;
            }
            case FLOAT: {
                final Float missingValue = sortField.getMissingValue() != null ? (Float)sortField.getMissingValue() : Float.valueOf(0.0f);
                for (int readerIndex = 0; readerIndex < readers.size(); ++readerIndex) {
                    final NumericDocValues values6 = Sorter.getOrWrapNumeric(readers.get(readerIndex), sortField);
                    providers[readerIndex] = new ComparableProvider(){
                        int lastDocID = -1;

                        private boolean docsInOrder(int docID) {
                            if (docID < this.lastDocID) {
                                throw new AssertionError((Object)("docs must be sent in order, but lastDocID=" + this.lastDocID + " vs docID=" + docID));
                            }
                            this.lastDocID = docID;
                            return true;
                        }

                        @Override
                        public Comparable getComparable(int docID) throws IOException {
                            assert (this.docsInOrder(docID));
                            int readerDocID = values6.docID();
                            if (readerDocID < docID) {
                                readerDocID = values6.advance(docID);
                            }
                            if (readerDocID == docID) {
                                return Float.valueOf((float)reverseMul * Float.intBitsToFloat((int)values6.longValue()));
                            }
                            return Float.valueOf((float)reverseMul * missingValue.floatValue());
                        }
                    };
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("unhandled SortField.getType()=" + (Object)((Object)sortField.getType()));
            }
        }
        return providers;
    }

    private static interface ComparableProvider {
        public Comparable getComparable(int var1) throws IOException;
    }

    private static class LeafAndDocID {
        final int readerIndex;
        final Bits liveDocs;
        final int maxDoc;
        final Comparable[] values;
        int docID;

        public LeafAndDocID(int readerIndex, Bits liveDocs, int maxDoc, int numComparables) {
            this.readerIndex = readerIndex;
            this.liveDocs = liveDocs;
            this.maxDoc = maxDoc;
            this.values = new Comparable[numComparables];
        }
    }
}

