/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.MergeInfo;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.IOSupplier;
import org.apache.lucene.util.InfoStream;

public abstract class MergePolicy {
    protected static final double DEFAULT_NO_CFS_RATIO = 1.0;
    protected static final long DEFAULT_MAX_CFS_SEGMENT_SIZE = Long.MAX_VALUE;
    protected double noCFSRatio = 1.0;
    protected long maxCFSSegmentSize = Long.MAX_VALUE;

    public MergePolicy() {
        this(1.0, Long.MAX_VALUE);
    }

    protected MergePolicy(double defaultNoCFSRatio, long defaultMaxCFSSegmentSize) {
        this.noCFSRatio = defaultNoCFSRatio;
        this.maxCFSSegmentSize = defaultMaxCFSSegmentSize;
    }

    public abstract MergeSpecification findMerges(MergeTrigger var1, SegmentInfos var2, MergeContext var3) throws IOException;

    public abstract MergeSpecification findForcedMerges(SegmentInfos var1, int var2, Map<SegmentCommitInfo, Boolean> var3, MergeContext var4) throws IOException;

    public abstract MergeSpecification findForcedDeletesMerges(SegmentInfos var1, MergeContext var2) throws IOException;

    public boolean useCompoundFile(SegmentInfos infos, SegmentCommitInfo mergedInfo, MergeContext mergeContext) throws IOException {
        if (this.getNoCFSRatio() == 0.0) {
            return false;
        }
        long mergedInfoSize = this.size(mergedInfo, mergeContext);
        if (mergedInfoSize > this.maxCFSSegmentSize) {
            return false;
        }
        if (this.getNoCFSRatio() >= 1.0) {
            return true;
        }
        long totalSize = 0L;
        for (SegmentCommitInfo info2 : infos) {
            totalSize += this.size(info2, mergeContext);
        }
        return (double)mergedInfoSize <= this.getNoCFSRatio() * (double)totalSize;
    }

    protected long size(SegmentCommitInfo info2, MergeContext mergeContext) throws IOException {
        double delRatio;
        long byteSize = info2.sizeInBytes();
        int delCount = mergeContext.numDeletesToMerge(info2);
        assert (this.assertDelCount(delCount, info2));
        double d = delRatio = info2.info.maxDoc() <= 0 ? 0.0 : (double)((float)delCount / (float)info2.info.maxDoc());
        assert (delRatio <= 1.0);
        return info2.info.maxDoc() <= 0 ? byteSize : (long)((double)byteSize * (1.0 - delRatio));
    }

    protected final boolean assertDelCount(int delCount, SegmentCommitInfo info2) {
        assert (delCount >= 0) : "delCount must be positive: " + delCount;
        assert (delCount <= info2.info.maxDoc()) : "delCount: " + delCount + " must be leq than maxDoc: " + info2.info.maxDoc();
        return true;
    }

    protected final boolean isMerged(SegmentInfos infos, SegmentCommitInfo info2, MergeContext mergeContext) throws IOException {
        assert (mergeContext != null);
        int delCount = mergeContext.numDeletesToMerge(info2);
        assert (this.assertDelCount(delCount, info2));
        return delCount == 0 && this.useCompoundFile(infos, info2, mergeContext) == info2.info.getUseCompoundFile();
    }

    public double getNoCFSRatio() {
        return this.noCFSRatio;
    }

    public void setNoCFSRatio(double noCFSRatio) {
        if (noCFSRatio < 0.0 || noCFSRatio > 1.0) {
            throw new IllegalArgumentException("noCFSRatio must be 0.0 to 1.0 inclusive; got " + noCFSRatio);
        }
        this.noCFSRatio = noCFSRatio;
    }

    public double getMaxCFSSegmentSizeMB() {
        return (double)(this.maxCFSSegmentSize / 1024L) / 1024.0;
    }

    public void setMaxCFSSegmentSizeMB(double v) {
        if (v < 0.0) {
            throw new IllegalArgumentException("maxCFSSegmentSizeMB must be >=0 (got " + v + ")");
        }
        this.maxCFSSegmentSize = (v *= 1048576.0) > 9.223372036854776E18 ? Long.MAX_VALUE : (long)v;
    }

    public boolean keepFullyDeletedSegment(IOSupplier<CodecReader> readerIOSupplier) throws IOException {
        return false;
    }

    public int numDeletesToMerge(SegmentCommitInfo info2, int delCount, IOSupplier<CodecReader> readerSupplier) throws IOException {
        return delCount;
    }

    protected final String segString(MergeContext mergeContext, Iterable<SegmentCommitInfo> infos) {
        return StreamSupport.stream(infos.spliterator(), false).map(info2 -> info2.toString(mergeContext.numDeletedDocs((SegmentCommitInfo)info2) - info2.getDelCount())).collect(Collectors.joining(" "));
    }

    protected final void message(String message, MergeContext mergeContext) {
        if (this.verbose(mergeContext)) {
            mergeContext.getInfoStream().message("MP", message);
        }
    }

    protected final boolean verbose(MergeContext mergeContext) {
        return mergeContext.getInfoStream().isEnabled("MP");
    }

    public static interface MergeContext {
        public int numDeletesToMerge(SegmentCommitInfo var1) throws IOException;

        public int numDeletedDocs(SegmentCommitInfo var1);

        public InfoStream getInfoStream();

        public Set<SegmentCommitInfo> getMergingSegments();
    }

    public static class MergeAbortedException
    extends IOException {
        public MergeAbortedException() {
            super("merge is aborted");
        }

        public MergeAbortedException(String message) {
            super(message);
        }
    }

    public static class MergeException
    extends RuntimeException {
        private Directory dir;

        public MergeException(String message, Directory dir) {
            super(message);
            this.dir = dir;
        }

        public MergeException(Throwable exc, Directory dir) {
            super(exc);
            this.dir = dir;
        }

        public Directory getDirectory() {
            return this.dir;
        }
    }

    public static class MergeSpecification {
        public final List<OneMerge> merges = new ArrayList<OneMerge>();

        public void add(OneMerge merge2) {
            this.merges.add(merge2);
        }

        public String segString(Directory dir) {
            StringBuilder b = new StringBuilder();
            b.append("MergeSpec:\n");
            int count2 = this.merges.size();
            for (int i = 0; i < count2; ++i) {
                b.append("  ").append(1 + i).append(": ").append(this.merges.get(i).segString());
            }
            return b.toString();
        }
    }

    public static class OneMerge {
        SegmentCommitInfo info;
        boolean registerDone;
        long mergeGen;
        boolean isExternal;
        int maxNumSegments = -1;
        public volatile long estimatedMergeBytes;
        volatile long totalMergeBytes;
        List<SegmentReader> readers;
        List<Bits> hardLiveDocs;
        public final List<SegmentCommitInfo> segments;
        private final OneMergeProgress mergeProgress;
        volatile long mergeStartNS = -1L;
        public final int totalMaxDoc;
        Throwable error;

        public OneMerge(List<SegmentCommitInfo> segments2) {
            if (0 == segments2.size()) {
                throw new RuntimeException("segments must include at least one segment");
            }
            this.segments = new ArrayList<SegmentCommitInfo>(segments2);
            int count2 = 0;
            for (SegmentCommitInfo info2 : segments2) {
                count2 += info2.info.maxDoc();
            }
            this.totalMaxDoc = count2;
            this.mergeProgress = new OneMergeProgress();
        }

        public void mergeInit() throws IOException {
            this.mergeProgress.setMergeThread(Thread.currentThread());
        }

        public void mergeFinished() throws IOException {
        }

        public CodecReader wrapForMerge(CodecReader reader) throws IOException {
            return reader;
        }

        public void setMergeInfo(SegmentCommitInfo info2) {
            this.info = info2;
        }

        public SegmentCommitInfo getMergeInfo() {
            return this.info;
        }

        synchronized void setException(Throwable error2) {
            this.error = error2;
        }

        synchronized Throwable getException() {
            return this.error;
        }

        public String segString() {
            StringBuilder b = new StringBuilder();
            int numSegments = this.segments.size();
            for (int i = 0; i < numSegments; ++i) {
                if (i > 0) {
                    b.append(' ');
                }
                b.append(this.segments.get(i).toString());
            }
            if (this.info != null) {
                b.append(" into ").append(this.info.info.name);
            }
            if (this.maxNumSegments != -1) {
                b.append(" [maxNumSegments=" + this.maxNumSegments + "]");
            }
            if (this.isAborted()) {
                b.append(" [ABORTED]");
            }
            return b.toString();
        }

        public long totalBytesSize() {
            return this.totalMergeBytes;
        }

        public int totalNumDocs() {
            int total2 = 0;
            for (SegmentCommitInfo info2 : this.segments) {
                total2 += info2.info.maxDoc();
            }
            return total2;
        }

        public MergeInfo getStoreMergeInfo() {
            return new MergeInfo(this.totalMaxDoc, this.estimatedMergeBytes, this.isExternal, this.maxNumSegments);
        }

        public boolean isAborted() {
            return this.mergeProgress.isAborted();
        }

        public void setAborted() {
            this.mergeProgress.abort();
        }

        public void checkAborted() throws MergeAbortedException {
            if (this.isAborted()) {
                throw new MergeAbortedException("merge is aborted: " + this.segString());
            }
        }

        public OneMergeProgress getMergeProgress() {
            return this.mergeProgress;
        }
    }

    public static class OneMergeProgress {
        private final ReentrantLock pauseLock = new ReentrantLock();
        private final Condition pausing = this.pauseLock.newCondition();
        private final EnumMap<PauseReason, AtomicLong> pauseTimesNS = new EnumMap(PauseReason.class);
        private volatile boolean aborted;
        private Thread owner;

        public OneMergeProgress() {
            for (PauseReason p : PauseReason.values()) {
                this.pauseTimesNS.put(p, new AtomicLong());
            }
        }

        public void abort() {
            this.aborted = true;
            this.wakeup();
        }

        public boolean isAborted() {
            return this.aborted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pauseNanos(long pauseNanos, PauseReason reason, BooleanSupplier condition) throws InterruptedException {
            if (Thread.currentThread() != this.owner) {
                throw new RuntimeException("Only the merge owner thread can call pauseNanos(). This thread: " + Thread.currentThread().getName() + ", owner thread: " + this.owner);
            }
            long start = System.nanoTime();
            AtomicLong timeUpdate = this.pauseTimesNS.get((Object)reason);
            this.pauseLock.lock();
            try {
                while (pauseNanos > 0L && !this.aborted && condition.getAsBoolean()) {
                    pauseNanos = this.pausing.awaitNanos(pauseNanos);
                }
            }
            finally {
                this.pauseLock.unlock();
                timeUpdate.addAndGet(System.nanoTime() - start);
            }
        }

        public void wakeup() {
            this.pauseLock.lock();
            try {
                this.pausing.signalAll();
            }
            finally {
                this.pauseLock.unlock();
            }
        }

        public Map<PauseReason, Long> getPauseTimes() {
            Set<Map.Entry<PauseReason, AtomicLong>> entries = this.pauseTimesNS.entrySet();
            return entries.stream().collect(Collectors.toMap(e -> (PauseReason)((Object)((Object)e.getKey())), e -> ((AtomicLong)e.getValue()).get()));
        }

        final void setMergeThread(Thread owner2) {
            assert (this.owner == null);
            this.owner = owner2;
        }

        public static enum PauseReason {
            STOPPED,
            PAUSED,
            OTHER;

        }
    }
}

