/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.util.ArrayUtil;

public class FieldInfos
implements Iterable<FieldInfo> {
    private final boolean hasFreq;
    private final boolean hasProx;
    private final boolean hasPayloads;
    private final boolean hasOffsets;
    private final boolean hasVectors;
    private final boolean hasNorms;
    private final boolean hasDocValues;
    private final boolean hasPointValues;
    private final String softDeletesField;
    private final FieldInfo[] byNumber;
    private final HashMap<String, FieldInfo> byName = new HashMap();
    private final Collection<FieldInfo> values;

    public FieldInfos(FieldInfo[] infos) {
        boolean hasVectors = false;
        boolean hasProx = false;
        boolean hasPayloads = false;
        boolean hasOffsets = false;
        boolean hasFreq = false;
        boolean hasNorms = false;
        boolean hasDocValues = false;
        boolean hasPointValues = false;
        String softDeletesField = null;
        int size2 = 0;
        FieldInfo[] byNumberTemp = new FieldInfo[10];
        for (FieldInfo info2 : infos) {
            FieldInfo previous;
            if (info2.number < 0) {
                throw new IllegalArgumentException("illegal field number: " + info2.number + " for field " + info2.name);
            }
            int n = size2 = info2.number >= size2 ? info2.number + 1 : size2;
            if (info2.number >= byNumberTemp.length) {
                byNumberTemp = ArrayUtil.grow(byNumberTemp, info2.number + 1);
            }
            if ((previous = byNumberTemp[info2.number]) != null) {
                throw new IllegalArgumentException("duplicate field numbers: " + previous.name + " and " + info2.name + " have: " + info2.number);
            }
            byNumberTemp[info2.number] = info2;
            previous = this.byName.put(info2.name, info2);
            if (previous != null) {
                throw new IllegalArgumentException("duplicate field names: " + previous.number + " and " + info2.number + " have: " + info2.name);
            }
            hasVectors |= info2.hasVectors();
            hasProx |= info2.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
            hasFreq |= info2.getIndexOptions() != IndexOptions.DOCS;
            hasOffsets |= info2.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
            hasNorms |= info2.hasNorms();
            hasDocValues |= info2.getDocValuesType() != DocValuesType.NONE;
            hasPayloads |= info2.hasPayloads();
            hasPointValues |= info2.getPointDimensionCount() != 0;
            if (!info2.isSoftDeletesField()) continue;
            if (softDeletesField != null && !softDeletesField.equals(info2.name)) {
                throw new IllegalArgumentException("multiple soft-deletes fields [" + info2.name + ", " + softDeletesField + "]");
            }
            softDeletesField = info2.name;
        }
        this.hasVectors = hasVectors;
        this.hasProx = hasProx;
        this.hasPayloads = hasPayloads;
        this.hasOffsets = hasOffsets;
        this.hasFreq = hasFreq;
        this.hasNorms = hasNorms;
        this.hasDocValues = hasDocValues;
        this.hasPointValues = hasPointValues;
        this.softDeletesField = softDeletesField;
        ArrayList<FieldInfo> valuesTemp = new ArrayList<FieldInfo>();
        this.byNumber = new FieldInfo[size2];
        for (int i = 0; i < size2; ++i) {
            this.byNumber[i] = byNumberTemp[i];
            if (byNumberTemp[i] == null) continue;
            valuesTemp.add(byNumberTemp[i]);
        }
        this.values = Collections.unmodifiableCollection(Arrays.asList(valuesTemp.toArray(new FieldInfo[0])));
    }

    public boolean hasFreq() {
        return this.hasFreq;
    }

    public boolean hasProx() {
        return this.hasProx;
    }

    public boolean hasPayloads() {
        return this.hasPayloads;
    }

    public boolean hasOffsets() {
        return this.hasOffsets;
    }

    public boolean hasVectors() {
        return this.hasVectors;
    }

    public boolean hasNorms() {
        return this.hasNorms;
    }

    public boolean hasDocValues() {
        return this.hasDocValues;
    }

    public boolean hasPointValues() {
        return this.hasPointValues;
    }

    public String getSoftDeletesField() {
        return this.softDeletesField;
    }

    public int size() {
        return this.byName.size();
    }

    @Override
    public Iterator<FieldInfo> iterator() {
        return this.values.iterator();
    }

    public FieldInfo fieldInfo(String fieldName) {
        return this.byName.get(fieldName);
    }

    public FieldInfo fieldInfo(int fieldNumber) {
        if (fieldNumber < 0) {
            throw new IllegalArgumentException("Illegal field number: " + fieldNumber);
        }
        if (fieldNumber >= this.byNumber.length) {
            return null;
        }
        return this.byNumber[fieldNumber];
    }

    static final class Builder {
        private final HashMap<String, FieldInfo> byName = new HashMap();
        final FieldNumbers globalFieldNumbers;
        private boolean finished;

        Builder(FieldNumbers globalFieldNumbers) {
            assert (globalFieldNumbers != null);
            this.globalFieldNumbers = globalFieldNumbers;
        }

        public void add(FieldInfos other) {
            assert (this.assertNotFinished());
            for (FieldInfo fieldInfo : other) {
                this.add(fieldInfo);
            }
        }

        public FieldInfo getOrAdd(String name) {
            FieldInfo fi = this.fieldInfo(name);
            if (fi == null) {
                assert (this.assertNotFinished());
                boolean isSoftDeletesField = name.equals(this.globalFieldNumbers.softDeletesFieldName);
                int fieldNumber = this.globalFieldNumbers.addOrGet(name, -1, DocValuesType.NONE, 0, 0, isSoftDeletesField);
                fi = new FieldInfo(name, fieldNumber, false, false, false, IndexOptions.NONE, DocValuesType.NONE, -1L, new HashMap<String, String>(), 0, 0, isSoftDeletesField);
                assert (!this.byName.containsKey(fi.name));
                this.globalFieldNumbers.verifyConsistent(fi.number, fi.name, DocValuesType.NONE);
                this.byName.put(fi.name, fi);
            }
            return fi;
        }

        private FieldInfo addOrUpdateInternal(String name, int preferredFieldNumber, boolean storeTermVector, boolean omitNorms, boolean storePayloads, IndexOptions indexOptions, DocValuesType docValues, long dvGen, int dimensionCount, int dimensionNumBytes, boolean isSoftDeletesField) {
            assert (this.assertNotFinished());
            if (docValues == null) {
                throw new NullPointerException("DocValuesType must not be null");
            }
            FieldInfo fi = this.fieldInfo(name);
            if (fi == null) {
                int fieldNumber = this.globalFieldNumbers.addOrGet(name, preferredFieldNumber, docValues, dimensionCount, dimensionNumBytes, isSoftDeletesField);
                fi = new FieldInfo(name, fieldNumber, storeTermVector, omitNorms, storePayloads, indexOptions, docValues, dvGen, new HashMap<String, String>(), dimensionCount, dimensionNumBytes, isSoftDeletesField);
                assert (!this.byName.containsKey(fi.name));
                this.globalFieldNumbers.verifyConsistent(fi.number, fi.name, fi.getDocValuesType());
                this.byName.put(fi.name, fi);
            } else {
                fi.update(storeTermVector, omitNorms, storePayloads, indexOptions, dimensionCount, dimensionNumBytes);
                if (docValues != DocValuesType.NONE) {
                    boolean updateGlobal;
                    boolean bl = updateGlobal = fi.getDocValuesType() == DocValuesType.NONE;
                    if (updateGlobal) {
                        this.globalFieldNumbers.setDocValuesType(fi.number, name, docValues);
                    }
                    fi.setDocValuesType(docValues);
                    fi.setDocValuesGen(dvGen);
                }
            }
            return fi;
        }

        public FieldInfo add(FieldInfo fi) {
            return this.add(fi, -1L);
        }

        public FieldInfo add(FieldInfo fi, long dvGen) {
            return this.addOrUpdateInternal(fi.name, fi.number, fi.hasVectors(), fi.omitsNorms(), fi.hasPayloads(), fi.getIndexOptions(), fi.getDocValuesType(), dvGen, fi.getPointDimensionCount(), fi.getPointNumBytes(), fi.isSoftDeletesField());
        }

        public FieldInfo fieldInfo(String fieldName) {
            return this.byName.get(fieldName);
        }

        private boolean assertNotFinished() {
            if (this.finished) {
                throw new IllegalStateException("FieldInfos.Builder was already finished; cannot add new fields");
            }
            return true;
        }

        FieldInfos finish() {
            this.finished = true;
            return new FieldInfos(this.byName.values().toArray(new FieldInfo[this.byName.size()]));
        }
    }

    static final class FieldNumbers {
        private final Map<Integer, String> numberToName;
        private final Map<String, Integer> nameToNumber = new HashMap<String, Integer>();
        private final Map<String, DocValuesType> docValuesType;
        private final Map<String, FieldDimensions> dimensions;
        private int lowestUnassignedFieldNumber = -1;
        private final String softDeletesFieldName;

        FieldNumbers(String softDeletesFieldName) {
            this.numberToName = new HashMap<Integer, String>();
            this.docValuesType = new HashMap<String, DocValuesType>();
            this.dimensions = new HashMap<String, FieldDimensions>();
            this.softDeletesFieldName = softDeletesFieldName;
        }

        synchronized int addOrGet(String fieldName, int preferredFieldNumber, DocValuesType dvType, int dimensionCount, int dimensionNumBytes, boolean isSoftDeletesField) {
            Integer fieldNumber;
            if (dvType != DocValuesType.NONE) {
                DocValuesType currentDVType = this.docValuesType.get(fieldName);
                if (currentDVType == null) {
                    this.docValuesType.put(fieldName, dvType);
                } else if (currentDVType != DocValuesType.NONE && currentDVType != dvType) {
                    throw new IllegalArgumentException("cannot change DocValues type from " + (Object)((Object)currentDVType) + " to " + (Object)((Object)dvType) + " for field \"" + fieldName + "\"");
                }
            }
            if (dimensionCount != 0) {
                FieldDimensions dims = this.dimensions.get(fieldName);
                if (dims != null) {
                    if (dims.dimensionCount != dimensionCount) {
                        throw new IllegalArgumentException("cannot change point dimension count from " + dims.dimensionCount + " to " + dimensionCount + " for field=\"" + fieldName + "\"");
                    }
                    if (dims.dimensionNumBytes != dimensionNumBytes) {
                        throw new IllegalArgumentException("cannot change point numBytes from " + dims.dimensionNumBytes + " to " + dimensionNumBytes + " for field=\"" + fieldName + "\"");
                    }
                } else {
                    this.dimensions.put(fieldName, new FieldDimensions(dimensionCount, dimensionNumBytes));
                }
            }
            if ((fieldNumber = this.nameToNumber.get(fieldName)) == null) {
                Integer preferredBoxed = preferredFieldNumber;
                if (preferredFieldNumber != -1 && !this.numberToName.containsKey(preferredBoxed)) {
                    fieldNumber = preferredBoxed;
                } else {
                    while (this.numberToName.containsKey(++this.lowestUnassignedFieldNumber)) {
                    }
                    fieldNumber = this.lowestUnassignedFieldNumber;
                }
                assert (fieldNumber >= 0);
                this.numberToName.put(fieldNumber, fieldName);
                this.nameToNumber.put(fieldName, fieldNumber);
            }
            if (isSoftDeletesField) {
                if (this.softDeletesFieldName == null) {
                    throw new IllegalArgumentException("this index has [" + fieldName + "] as soft-deletes already but soft-deletes field is not configured in IWC");
                }
                if (!fieldName.equals(this.softDeletesFieldName)) {
                    throw new IllegalArgumentException("cannot configure [" + this.softDeletesFieldName + "] as soft-deletes; this index uses [" + fieldName + "] as soft-deletes already");
                }
            } else if (fieldName.equals(this.softDeletesFieldName)) {
                throw new IllegalArgumentException("cannot configure [" + this.softDeletesFieldName + "] as soft-deletes; this index uses [" + fieldName + "] as non-soft-deletes already");
            }
            return fieldNumber;
        }

        synchronized void verifyConsistent(Integer number2, String name, DocValuesType dvType) {
            if (!name.equals(this.numberToName.get(number2))) {
                throw new IllegalArgumentException("field number " + number2 + " is already mapped to field name \"" + this.numberToName.get(number2) + "\", not \"" + name + "\"");
            }
            if (!number2.equals(this.nameToNumber.get(name))) {
                throw new IllegalArgumentException("field name \"" + name + "\" is already mapped to field number \"" + this.nameToNumber.get(name) + "\", not \"" + number2 + "\"");
            }
            DocValuesType currentDVType = this.docValuesType.get(name);
            if (dvType != DocValuesType.NONE && currentDVType != null && currentDVType != DocValuesType.NONE && dvType != currentDVType) {
                throw new IllegalArgumentException("cannot change DocValues type from " + (Object)((Object)currentDVType) + " to " + (Object)((Object)dvType) + " for field \"" + name + "\"");
            }
        }

        synchronized void verifyConsistentDimensions(Integer number2, String name, int dimensionCount, int dimensionNumBytes) {
            if (!name.equals(this.numberToName.get(number2))) {
                throw new IllegalArgumentException("field number " + number2 + " is already mapped to field name \"" + this.numberToName.get(number2) + "\", not \"" + name + "\"");
            }
            if (!number2.equals(this.nameToNumber.get(name))) {
                throw new IllegalArgumentException("field name \"" + name + "\" is already mapped to field number \"" + this.nameToNumber.get(name) + "\", not \"" + number2 + "\"");
            }
            FieldDimensions dim = this.dimensions.get(name);
            if (dim != null) {
                if (dim.dimensionCount != dimensionCount) {
                    throw new IllegalArgumentException("cannot change point dimension count from " + dim.dimensionCount + " to " + dimensionCount + " for field=\"" + name + "\"");
                }
                if (dim.dimensionNumBytes != dimensionNumBytes) {
                    throw new IllegalArgumentException("cannot change point numBytes from " + dim.dimensionNumBytes + " to " + dimensionNumBytes + " for field=\"" + name + "\"");
                }
            }
        }

        synchronized boolean contains(String fieldName, DocValuesType dvType) {
            if (!this.nameToNumber.containsKey(fieldName)) {
                return false;
            }
            return dvType == this.docValuesType.get(fieldName);
        }

        synchronized Set<String> getFieldNames() {
            return Collections.unmodifiableSet(new HashSet<String>(this.nameToNumber.keySet()));
        }

        synchronized void clear() {
            this.numberToName.clear();
            this.nameToNumber.clear();
            this.docValuesType.clear();
            this.dimensions.clear();
        }

        synchronized void setDocValuesType(int number2, String name, DocValuesType dvType) {
            this.verifyConsistent(number2, name, dvType);
            this.docValuesType.put(name, dvType);
        }

        synchronized void setDimensions(int number2, String name, int dimensionCount, int dimensionNumBytes) {
            if (dimensionNumBytes > 16) {
                throw new IllegalArgumentException("dimension numBytes must be <= PointValues.MAX_NUM_BYTES (= 16); got " + dimensionNumBytes + " for field=\"" + name + "\"");
            }
            if (dimensionCount > 8) {
                throw new IllegalArgumentException("pointDimensionCount must be <= PointValues.MAX_DIMENSIONS (= 8); got " + dimensionCount + " for field=\"" + name + "\"");
            }
            this.verifyConsistentDimensions(number2, name, dimensionCount, dimensionNumBytes);
            this.dimensions.put(name, new FieldDimensions(dimensionCount, dimensionNumBytes));
        }
    }

    static final class FieldDimensions {
        public final int dimensionCount;
        public final int dimensionNumBytes;

        public FieldDimensions(int dimensionCount, int dimensionNumBytes) {
            this.dimensionCount = dimensionCount;
            this.dimensionNumBytes = dimensionNumBytes;
        }
    }
}

