/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.index.DocValuesFieldUpdates;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PagedGrowableWriter;
import org.apache.lucene.util.packed.PagedMutable;

final class BinaryDocValuesFieldUpdates
extends DocValuesFieldUpdates {
    private PagedGrowableWriter offsets = new PagedGrowableWriter(1L, 1024, 1, 0.5f);
    private PagedGrowableWriter lengths = new PagedGrowableWriter(1L, 1024, 1, 0.5f);
    private BytesRefBuilder values = new BytesRefBuilder();

    public BinaryDocValuesFieldUpdates(long delGen, String field2, int maxDoc) {
        super(maxDoc, delGen, field2, DocValuesType.BINARY);
    }

    @Override
    public void add(int doc, long value2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int docId, DocValuesFieldUpdates.Iterator iterator2) {
        this.add(docId, iterator2.binaryValue());
    }

    @Override
    public synchronized void add(int doc, BytesRef value2) {
        int index2 = this.add(doc);
        this.offsets.set(index2, this.values.length());
        this.lengths.set(index2, value2.length);
        this.values.append(value2);
    }

    @Override
    protected void swap(int i, int j) {
        super.swap(i, j);
        long tmpOffset = this.offsets.get(j);
        this.offsets.set(j, this.offsets.get(i));
        this.offsets.set(i, tmpOffset);
        long tmpLength = this.lengths.get(j);
        this.lengths.set(j, this.lengths.get(i));
        this.lengths.set(i, tmpLength);
    }

    @Override
    protected void grow(int size2) {
        super.grow(size2);
        this.offsets = (PagedGrowableWriter)this.offsets.grow(size2);
        this.lengths = (PagedGrowableWriter)this.lengths.grow(size2);
    }

    @Override
    protected void resize(int size2) {
        super.resize(size2);
        this.offsets = (PagedGrowableWriter)this.offsets.resize(size2);
        this.lengths = (PagedGrowableWriter)this.lengths.resize(size2);
    }

    @Override
    public Iterator iterator() {
        this.ensureFinished();
        return new Iterator(this.size, this.offsets, this.lengths, this.docs, this.values.get(), this.delGen);
    }

    @Override
    public long ramBytesUsed() {
        return super.ramBytesUsed() + this.offsets.ramBytesUsed() + this.lengths.ramBytesUsed() + (long)RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 8L + (long)(3 * RamUsageEstimator.NUM_BYTES_OBJECT_REF) + (long)this.values.bytes().length;
    }

    static final class Iterator
    extends DocValuesFieldUpdates.AbstractIterator {
        private final PagedGrowableWriter offsets;
        private final PagedGrowableWriter lengths;
        private final BytesRef value;
        private int offset;
        private int length;

        Iterator(int size2, PagedGrowableWriter offsets, PagedGrowableWriter lengths, PagedMutable docs, BytesRef values2, long delGen) {
            super(size2, docs, delGen);
            this.offsets = offsets;
            this.lengths = lengths;
            this.value = values2.clone();
        }

        @Override
        BytesRef binaryValue() {
            this.value.offset = this.offset;
            this.value.length = this.length;
            return this.value;
        }

        @Override
        protected void set(long idx) {
            this.offset = (int)this.offsets.get(idx);
            this.length = (int)this.lengths.get(idx);
        }

        @Override
        long longValue() {
            throw new UnsupportedOperationException();
        }
    }
}

