/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.lucene.geo.Polygon;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.util.ArrayUtil;

public final class Polygon2D {
    public final double minLat;
    public final double maxLat;
    public final double minLon;
    public final double maxLon;
    private double maxY;
    private double maxX;
    private boolean splitX;
    private Polygon2D left;
    private Polygon2D right;
    private final Polygon2D holes;
    private final Edge tree;

    private Polygon2D(Polygon polygon, Polygon2D holes) {
        this.holes = holes;
        this.minLat = polygon.minLat;
        this.maxLat = polygon.maxLat;
        this.minLon = polygon.minLon;
        this.maxLon = polygon.maxLon;
        this.maxY = this.maxLat;
        this.maxX = this.maxLon;
        this.tree = Polygon2D.createTree(polygon.getPolyLats(), polygon.getPolyLons());
    }

    public boolean contains(double latitude, double longitude) {
        if (latitude <= this.maxY && longitude <= this.maxX) {
            if (this.componentContains(latitude, longitude)) {
                return true;
            }
            if (this.left != null && this.left.contains(latitude, longitude)) {
                return true;
            }
            if (this.right != null && (!this.splitX && latitude >= this.minLat || this.splitX && longitude >= this.minLon) && this.right.contains(latitude, longitude)) {
                return true;
            }
        }
        return false;
    }

    private boolean componentContains(double latitude, double longitude) {
        if (latitude < this.minLat || latitude > this.maxLat || longitude < this.minLon || longitude > this.maxLon) {
            return false;
        }
        if (this.tree.contains(latitude, longitude)) {
            return this.holes == null || !this.holes.contains(latitude, longitude);
        }
        return false;
    }

    public PointValues.Relation relate(double minLat, double maxLat, double minLon, double maxLon) {
        if (minLat <= this.maxY && minLon <= this.maxX) {
            PointValues.Relation relation = this.componentRelate(minLat, maxLat, minLon, maxLon);
            if (relation != PointValues.Relation.CELL_OUTSIDE_QUERY) {
                return relation;
            }
            if (this.left != null && (relation = this.left.relate(minLat, maxLat, minLon, maxLon)) != PointValues.Relation.CELL_OUTSIDE_QUERY) {
                return relation;
            }
            if (this.right != null && (!this.splitX && maxLat >= this.minLat || this.splitX && maxLon >= this.minLon) && (relation = this.right.relate(minLat, maxLat, minLon, maxLon)) != PointValues.Relation.CELL_OUTSIDE_QUERY) {
                return relation;
            }
        }
        return PointValues.Relation.CELL_OUTSIDE_QUERY;
    }

    private PointValues.Relation componentRelate(double minLat, double maxLat, double minLon, double maxLon) {
        int numCorners;
        if (maxLon < this.minLon || minLon > this.maxLon || maxLat < this.minLat || minLat > this.maxLat) {
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        if (minLat <= this.minLat && maxLat >= this.maxLat && minLon <= this.minLon && maxLon >= this.maxLon) {
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }
        if (this.holes != null) {
            PointValues.Relation holeRelation = this.holes.relate(minLat, maxLat, minLon, maxLon);
            if (holeRelation == PointValues.Relation.CELL_CROSSES_QUERY) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            if (holeRelation == PointValues.Relation.CELL_INSIDE_QUERY) {
                return PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
        }
        if ((numCorners = this.numberOfCorners(minLat, maxLat, minLon, maxLon)) == 4) {
            if (this.tree.crosses(minLat, maxLat, minLon, maxLon)) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            return PointValues.Relation.CELL_INSIDE_QUERY;
        }
        if (numCorners > 0) {
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }
        if (this.tree.crosses(minLat, maxLat, minLon, maxLon)) {
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }
        return PointValues.Relation.CELL_OUTSIDE_QUERY;
    }

    private int numberOfCorners(double minLat, double maxLat, double minLon, double maxLon) {
        int containsCount = 0;
        if (this.componentContains(minLat, minLon)) {
            ++containsCount;
        }
        if (this.componentContains(minLat, maxLon)) {
            ++containsCount;
        }
        if (containsCount == 1) {
            return containsCount;
        }
        if (this.componentContains(maxLat, maxLon)) {
            ++containsCount;
        }
        if (containsCount == 2) {
            return containsCount;
        }
        if (this.componentContains(maxLat, minLon)) {
            ++containsCount;
        }
        return containsCount;
    }

    private static Polygon2D createTree(Polygon2D[] components, int low, int high, boolean splitX) {
        if (low > high) {
            return null;
        }
        int mid = low + high >>> 1;
        if (low < high) {
            Comparator comparator = splitX ? (left, right) -> {
                int ret = Double.compare(left.minLon, right.minLon);
                if (ret == 0) {
                    ret = Double.compare(left.maxX, right.maxX);
                }
                return ret;
            } : (left, right) -> {
                int ret = Double.compare(left.minLat, right.minLat);
                if (ret == 0) {
                    ret = Double.compare(left.maxY, right.maxY);
                }
                return ret;
            };
            ArrayUtil.select(components, low, high + 1, mid, comparator);
        }
        Polygon2D newNode = components[mid];
        newNode.splitX = splitX;
        newNode.left = Polygon2D.createTree(components, low, mid - 1, !splitX);
        newNode.right = Polygon2D.createTree(components, mid + 1, high, !splitX);
        if (newNode.left != null) {
            newNode.maxX = Math.max(newNode.maxX, newNode.left.maxX);
            newNode.maxY = Math.max(newNode.maxY, newNode.left.maxY);
        }
        if (newNode.right != null) {
            newNode.maxX = Math.max(newNode.maxX, newNode.right.maxX);
            newNode.maxY = Math.max(newNode.maxY, newNode.right.maxY);
        }
        return newNode;
    }

    public static Polygon2D create(Polygon ... polygons) {
        Polygon2D[] components = new Polygon2D[polygons.length];
        for (int i = 0; i < components.length; ++i) {
            Polygon gon = polygons[i];
            Polygon[] gonHoles = gon.getHoles();
            Polygon2D holes = null;
            if (gonHoles.length > 0) {
                holes = Polygon2D.create(gonHoles);
            }
            components[i] = new Polygon2D(gon, holes);
        }
        return Polygon2D.createTree(components, 0, components.length - 1, false);
    }

    private static Edge createTree(double[] polyLats, double[] polyLons) {
        Edge[] edges2 = new Edge[polyLats.length - 1];
        for (int i = 1; i < polyLats.length; ++i) {
            double lat1 = polyLats[i - 1];
            double lon1 = polyLons[i - 1];
            double lat2 = polyLats[i];
            double lon2 = polyLons[i];
            edges2[i - 1] = new Edge(lat1, lon1, lat2, lon2, Math.min(lat1, lat2), Math.max(lat1, lat2));
        }
        Arrays.sort(edges2, (left, right) -> {
            int ret = Double.compare(left.low, right.low);
            if (ret == 0) {
                ret = Double.compare(left.max, right.max);
            }
            return ret;
        });
        return Polygon2D.createTree(edges2, 0, edges2.length - 1);
    }

    private static Edge createTree(Edge[] edges2, int low, int high) {
        if (low > high) {
            return null;
        }
        int mid = low + high >>> 1;
        Edge newNode = edges2[mid];
        newNode.left = Polygon2D.createTree(edges2, low, mid - 1);
        newNode.right = Polygon2D.createTree(edges2, mid + 1, high);
        if (newNode.left != null) {
            newNode.max = Math.max(newNode.max, newNode.left.max);
        }
        if (newNode.right != null) {
            newNode.max = Math.max(newNode.max, newNode.right.max);
        }
        return newNode;
    }

    private static int orient(double ax, double ay, double bx, double by2, double cx, double cy) {
        double v1 = (bx - ax) * (cy - ay);
        double v2 = (cx - ax) * (by2 - ay);
        if (v1 > v2) {
            return 1;
        }
        if (v1 < v2) {
            return -1;
        }
        return 0;
    }

    static final class Edge {
        final double lat1;
        final double lat2;
        final double lon1;
        final double lon2;
        final double low;
        double max;
        Edge left;
        Edge right;

        Edge(double lat1, double lon1, double lat2, double lon2, double low, double max2) {
            this.lat1 = lat1;
            this.lon1 = lon1;
            this.lat2 = lat2;
            this.lon2 = lon2;
            this.low = low;
            this.max = max2;
        }

        boolean contains(double latitude, double longitude) {
            boolean res = false;
            if (latitude <= this.max) {
                if (this.lat1 > latitude != this.lat2 > latitude && longitude < (this.lon1 - this.lon2) * (latitude - this.lat2) / (this.lat1 - this.lat2) + this.lon2) {
                    res = true;
                }
                if (this.left != null) {
                    res ^= this.left.contains(latitude, longitude);
                }
                if (this.right != null && latitude >= this.low) {
                    res ^= this.right.contains(latitude, longitude);
                }
            }
            return res;
        }

        boolean crosses(double minLat, double maxLat, double minLon, double maxLon) {
            if (minLat <= this.max) {
                boolean outside;
                double cy = this.lat1;
                double dy = this.lat2;
                double cx = this.lon1;
                double dx = this.lon2;
                boolean bl = outside = cy < minLat && dy < minLat || cy > maxLat && dy > maxLat || cx < minLon && dx < minLon || cx > maxLon && dx > maxLon;
                if (!outside) {
                    if (Polygon2D.orient(cx, cy, dx, dy, minLon, maxLat) * Polygon2D.orient(cx, cy, dx, dy, maxLon, maxLat) <= 0 && Polygon2D.orient(minLon, maxLat, maxLon, maxLat, cx, cy) * Polygon2D.orient(minLon, maxLat, maxLon, maxLat, dx, dy) <= 0) {
                        return true;
                    }
                    if (Polygon2D.orient(cx, cy, dx, dy, maxLon, maxLat) * Polygon2D.orient(cx, cy, dx, dy, maxLon, minLat) <= 0 && Polygon2D.orient(maxLon, maxLat, maxLon, minLat, cx, cy) * Polygon2D.orient(maxLon, maxLat, maxLon, minLat, dx, dy) <= 0) {
                        return true;
                    }
                    if (Polygon2D.orient(cx, cy, dx, dy, maxLon, minLat) * Polygon2D.orient(cx, cy, dx, dy, minLon, minLat) <= 0 && Polygon2D.orient(maxLon, minLat, minLon, minLat, cx, cy) * Polygon2D.orient(maxLon, minLat, minLon, minLat, dx, dy) <= 0) {
                        return true;
                    }
                    if (Polygon2D.orient(cx, cy, dx, dy, minLon, minLat) * Polygon2D.orient(cx, cy, dx, dy, minLon, maxLat) <= 0 && Polygon2D.orient(minLon, minLat, minLon, maxLat, cx, cy) * Polygon2D.orient(minLon, minLat, minLon, maxLat, dx, dy) <= 0) {
                        return true;
                    }
                }
                if (this.left != null && this.left.crosses(minLat, maxLat, minLon, maxLon)) {
                    return true;
                }
                if (this.right != null && maxLat >= this.low && this.right.crosses(minLat, maxLat, minLon, maxLon)) {
                    return true;
                }
            }
            return false;
        }
    }
}

