/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.SortedNumericDocValuesRangeQuery;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.Query;

public class SortedNumericDocValuesField
extends Field {
    public static final FieldType TYPE = new FieldType();

    public SortedNumericDocValuesField(String name, long value2) {
        super(name, TYPE);
        this.fieldsData = value2;
    }

    public static Query newSlowRangeQuery(String field2, long lowerValue, long upperValue) {
        return new SortedNumericDocValuesRangeQuery(field2, lowerValue, upperValue){

            @Override
            SortedNumericDocValues getValues(LeafReader reader, String field2) throws IOException {
                FieldInfo info2 = reader.getFieldInfos().fieldInfo(field2);
                if (info2 == null) {
                    return null;
                }
                return DocValues.getSortedNumeric(reader, field2);
            }
        };
    }

    public static Query newSlowExactQuery(String field2, long value2) {
        return SortedNumericDocValuesField.newSlowRangeQuery(field2, value2, value2);
    }

    static {
        TYPE.setDocValuesType(DocValuesType.SORTED_NUMERIC);
        TYPE.freeze();
    }
}

