/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.SortedSetDocValuesRangeQuery;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;

public class SortedDocValuesField
extends Field {
    public static final FieldType TYPE = new FieldType();

    public SortedDocValuesField(String name, BytesRef bytes2) {
        super(name, TYPE);
        this.fieldsData = bytes2;
    }

    public static Query newSlowRangeQuery(String field2, BytesRef lowerValue, BytesRef upperValue, boolean lowerInclusive, boolean upperInclusive) {
        return new SortedSetDocValuesRangeQuery(field2, lowerValue, upperValue, lowerInclusive, upperInclusive){

            @Override
            SortedSetDocValues getValues(LeafReader reader, String field2) throws IOException {
                return DocValues.singleton(DocValues.getSorted(reader, field2));
            }
        };
    }

    public static Query newSlowExactQuery(String field2, BytesRef value2) {
        return SortedDocValuesField.newSlowRangeQuery(field2, value2, value2, true, true);
    }

    static {
        TYPE.setDocValuesType(DocValuesType.SORTED);
        TYPE.freeze();
    }
}

