/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.Polygon;
import org.apache.lucene.geo.Polygon2D;
import org.apache.lucene.geo.Rectangle;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.DocIdSetBuilder;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.StringHelper;

final class LatLonPointInPolygonQuery
extends Query {
    final String field;
    final Polygon[] polygons;

    LatLonPointInPolygonQuery(String field2, Polygon[] polygons) {
        if (field2 == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        if (polygons == null) {
            throw new IllegalArgumentException("polygons must not be null");
        }
        if (polygons.length == 0) {
            throw new IllegalArgumentException("polygons must not be empty");
        }
        for (int i = 0; i < polygons.length; ++i) {
            if (polygons[i] != null) continue;
            throw new IllegalArgumentException("polygon[" + i + "] must not be null");
        }
        this.field = field2;
        this.polygons = (Polygon[])polygons.clone();
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
        Rectangle box2 = Rectangle.fromPolygon(this.polygons);
        final byte[] minLat = new byte[4];
        final byte[] maxLat = new byte[4];
        final byte[] minLon = new byte[4];
        final byte[] maxLon = new byte[4];
        NumericUtils.intToSortableBytes(GeoEncodingUtils.encodeLatitude(box2.minLat), minLat, 0);
        NumericUtils.intToSortableBytes(GeoEncodingUtils.encodeLatitude(box2.maxLat), maxLat, 0);
        NumericUtils.intToSortableBytes(GeoEncodingUtils.encodeLongitude(box2.minLon), minLon, 0);
        NumericUtils.intToSortableBytes(GeoEncodingUtils.encodeLongitude(box2.maxLon), maxLon, 0);
        final Polygon2D tree2 = Polygon2D.create(this.polygons);
        final GeoEncodingUtils.PolygonPredicate polygonPredicate = GeoEncodingUtils.createPolygonPredicate(this.polygons, tree2);
        return new ConstantScoreWeight(this, boost){

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                LeafReader reader = context.reader();
                PointValues values2 = reader.getPointValues(LatLonPointInPolygonQuery.this.field);
                if (values2 == null) {
                    return null;
                }
                FieldInfo fieldInfo = reader.getFieldInfos().fieldInfo(LatLonPointInPolygonQuery.this.field);
                if (fieldInfo == null) {
                    return null;
                }
                LatLonPoint.checkCompatible(fieldInfo);
                final DocIdSetBuilder result2 = new DocIdSetBuilder(reader.maxDoc(), values2, LatLonPointInPolygonQuery.this.field);
                values2.intersect(new PointValues.IntersectVisitor(){
                    DocIdSetBuilder.BulkAdder adder;

                    @Override
                    public void grow(int count2) {
                        this.adder = result2.grow(count2);
                    }

                    @Override
                    public void visit(int docID) {
                        this.adder.add(docID);
                    }

                    @Override
                    public void visit(int docID, byte[] packedValue) {
                        if (polygonPredicate.test(NumericUtils.sortableBytesToInt(packedValue, 0), NumericUtils.sortableBytesToInt(packedValue, 4))) {
                            this.adder.add(docID);
                        }
                    }

                    @Override
                    public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                        if (StringHelper.compare(4, minPackedValue, 0, maxLat, 0) > 0 || StringHelper.compare(4, maxPackedValue, 0, minLat, 0) < 0 || StringHelper.compare(4, minPackedValue, 4, maxLon, 0) > 0 || StringHelper.compare(4, maxPackedValue, 4, minLon, 0) < 0) {
                            return PointValues.Relation.CELL_OUTSIDE_QUERY;
                        }
                        double cellMinLat = GeoEncodingUtils.decodeLatitude(minPackedValue, 0);
                        double cellMinLon = GeoEncodingUtils.decodeLongitude(minPackedValue, 4);
                        double cellMaxLat = GeoEncodingUtils.decodeLatitude(maxPackedValue, 0);
                        double cellMaxLon = GeoEncodingUtils.decodeLongitude(maxPackedValue, 4);
                        return tree2.relate(cellMinLat, cellMaxLat, cellMinLon, cellMaxLon);
                    }
                });
                return new ConstantScoreScorer((Weight)this, this.score(), result2.build().iterator());
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }
        };
    }

    public String getField() {
        return this.field;
    }

    public Polygon[] getPolygons() {
        return (Polygon[])this.polygons.clone();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result2 = this.classHash();
        result2 = 31 * result2 + this.field.hashCode();
        result2 = 31 * result2 + Arrays.hashCode(this.polygons);
        return result2;
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((LatLonPointInPolygonQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(LatLonPointInPolygonQuery other) {
        return this.field.equals(other.field) && Arrays.equals(this.polygons, other.polygons);
    }

    @Override
    public String toString(String field2) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(':');
        if (!this.field.equals(field2)) {
            sb.append(" field=");
            sb.append(this.field);
            sb.append(':');
        }
        sb.append(Arrays.toString(this.polygons));
        return sb.toString();
    }
}

