/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.LatLonPointDistanceQuery;
import org.apache.lucene.document.LatLonPointInPolygonQuery;
import org.apache.lucene.document.NearestNeighbor;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.geo.Polygon;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.PointRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.bkd.BKDReader;

public class LatLonPoint
extends Field {
    public static final int BYTES = 4;
    public static final FieldType TYPE = new FieldType();

    public void setLocationValue(double latitude, double longitude) {
        byte[] bytes2;
        if (this.fieldsData == null) {
            bytes2 = new byte[8];
            this.fieldsData = new BytesRef(bytes2);
        } else {
            bytes2 = ((BytesRef)this.fieldsData).bytes;
        }
        int latitudeEncoded = GeoEncodingUtils.encodeLatitude(latitude);
        int longitudeEncoded = GeoEncodingUtils.encodeLongitude(longitude);
        NumericUtils.intToSortableBytes(latitudeEncoded, bytes2, 0);
        NumericUtils.intToSortableBytes(longitudeEncoded, bytes2, 4);
    }

    public LatLonPoint(String name, double latitude, double longitude) {
        super(name, TYPE);
        this.setLocationValue(latitude, longitude);
    }

    @Override
    public String toString() {
        StringBuilder result2 = new StringBuilder();
        result2.append(this.getClass().getSimpleName());
        result2.append(" <");
        result2.append(this.name);
        result2.append(':');
        byte[] bytes2 = ((BytesRef)this.fieldsData).bytes;
        result2.append(GeoEncodingUtils.decodeLatitude(bytes2, 0));
        result2.append(',');
        result2.append(GeoEncodingUtils.decodeLongitude(bytes2, 4));
        result2.append('>');
        return result2.toString();
    }

    private static byte[] encode(double latitude, double longitude) {
        byte[] bytes2 = new byte[8];
        NumericUtils.intToSortableBytes(GeoEncodingUtils.encodeLatitude(latitude), bytes2, 0);
        NumericUtils.intToSortableBytes(GeoEncodingUtils.encodeLongitude(longitude), bytes2, 4);
        return bytes2;
    }

    private static byte[] encodeCeil(double latitude, double longitude) {
        byte[] bytes2 = new byte[8];
        NumericUtils.intToSortableBytes(GeoEncodingUtils.encodeLatitudeCeil(latitude), bytes2, 0);
        NumericUtils.intToSortableBytes(GeoEncodingUtils.encodeLongitudeCeil(longitude), bytes2, 4);
        return bytes2;
    }

    static void checkCompatible(FieldInfo fieldInfo) {
        if (fieldInfo.getPointDimensionCount() != 0 && fieldInfo.getPointDimensionCount() != TYPE.pointDimensionCount()) {
            throw new IllegalArgumentException("field=\"" + fieldInfo.name + "\" was indexed with numDims=" + fieldInfo.getPointDimensionCount() + " but this point type has numDims=" + TYPE.pointDimensionCount() + ", is the field really a LatLonPoint?");
        }
        if (fieldInfo.getPointNumBytes() != 0 && fieldInfo.getPointNumBytes() != TYPE.pointNumBytes()) {
            throw new IllegalArgumentException("field=\"" + fieldInfo.name + "\" was indexed with bytesPerDim=" + fieldInfo.getPointNumBytes() + " but this point type has bytesPerDim=" + TYPE.pointNumBytes() + ", is the field really a LatLonPoint?");
        }
    }

    public static Query newBoxQuery(String field2, double minLatitude, double maxLatitude, double minLongitude, double maxLongitude) {
        if (minLatitude == 90.0) {
            return new MatchNoDocsQuery("LatLonPoint.newBoxQuery with minLatitude=90.0");
        }
        if (minLongitude == 180.0) {
            if (maxLongitude == 180.0) {
                return new MatchNoDocsQuery("LatLonPoint.newBoxQuery with minLongitude=maxLongitude=180.0");
            }
            if (maxLongitude < minLongitude) {
                minLongitude = -180.0;
            }
        }
        byte[] lower = LatLonPoint.encodeCeil(minLatitude, minLongitude);
        byte[] upper = LatLonPoint.encode(maxLatitude, maxLongitude);
        if (maxLongitude < minLongitude) {
            BooleanQuery.Builder q = new BooleanQuery.Builder();
            byte[] leftOpen = (byte[])lower.clone();
            NumericUtils.intToSortableBytes(Integer.MIN_VALUE, leftOpen, 4);
            Query left = LatLonPoint.newBoxInternal(field2, leftOpen, upper);
            q.add(new BooleanClause(left, BooleanClause.Occur.SHOULD));
            byte[] rightOpen = (byte[])upper.clone();
            NumericUtils.intToSortableBytes(Integer.MAX_VALUE, rightOpen, 4);
            Query right = LatLonPoint.newBoxInternal(field2, lower, rightOpen);
            q.add(new BooleanClause(right, BooleanClause.Occur.SHOULD));
            return new ConstantScoreQuery(q.build());
        }
        return LatLonPoint.newBoxInternal(field2, lower, upper);
    }

    private static Query newBoxInternal(String field2, byte[] min2, byte[] max2) {
        return new PointRangeQuery(field2, min2, max2, 2){

            @Override
            protected String toString(int dimension, byte[] value2) {
                if (dimension == 0) {
                    return Double.toString(GeoEncodingUtils.decodeLatitude(value2, 0));
                }
                if (dimension == 1) {
                    return Double.toString(GeoEncodingUtils.decodeLongitude(value2, 0));
                }
                throw new AssertionError();
            }
        };
    }

    public static Query newDistanceQuery(String field2, double latitude, double longitude, double radiusMeters) {
        return new LatLonPointDistanceQuery(field2, latitude, longitude, radiusMeters);
    }

    public static Query newPolygonQuery(String field2, Polygon ... polygons) {
        return new LatLonPointInPolygonQuery(field2, polygons);
    }

    public static TopFieldDocs nearest(IndexSearcher searcher, String field2, double latitude, double longitude, int n) throws IOException {
        GeoUtils.checkLatitude(latitude);
        GeoUtils.checkLongitude(longitude);
        if (n < 1) {
            throw new IllegalArgumentException("n must be at least 1; got " + n);
        }
        if (field2 == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        if (searcher == null) {
            throw new IllegalArgumentException("searcher must not be null");
        }
        ArrayList<BKDReader> readers = new ArrayList<BKDReader>();
        ArrayList<Integer> docBases = new ArrayList<Integer>();
        ArrayList<Bits> liveDocs = new ArrayList<Bits>();
        int totalHits = 0;
        for (LeafReaderContext leaf : searcher.getIndexReader().leaves()) {
            PointValues points = leaf.reader().getPointValues(field2);
            if (points == null) continue;
            if (!(points instanceof BKDReader)) {
                throw new IllegalArgumentException("can only run on Lucene60PointsReader points implementation, but got " + points);
            }
            totalHits += points.getDocCount();
            BKDReader reader = (BKDReader)points;
            if (reader == null) continue;
            readers.add(reader);
            docBases.add(leaf.docBase);
            liveDocs.add(leaf.reader().getLiveDocs());
        }
        NearestNeighbor.NearestHit[] hits = NearestNeighbor.nearest(latitude, longitude, readers, liveDocs, docBases, n);
        ScoreDoc[] scoreDocs = new ScoreDoc[hits.length];
        for (int i = 0; i < hits.length; ++i) {
            NearestNeighbor.NearestHit hit = hits[i];
            scoreDocs[i] = new FieldDoc(hit.docID, 0.0f, new Object[]{hit.distanceMeters});
        }
        return new TopFieldDocs(totalHits, scoreDocs, null, 0.0f);
    }

    static {
        TYPE.setDimensions(2, 4);
        TYPE.freeze();
    }
}

