/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableFieldType;

public class FieldType
implements IndexableFieldType {
    private boolean stored;
    private boolean tokenized = true;
    private boolean storeTermVectors;
    private boolean storeTermVectorOffsets;
    private boolean storeTermVectorPositions;
    private boolean storeTermVectorPayloads;
    private boolean omitNorms;
    private IndexOptions indexOptions = IndexOptions.NONE;
    private boolean frozen;
    private DocValuesType docValuesType = DocValuesType.NONE;
    private int dimensionCount;
    private int dimensionNumBytes;

    public FieldType(IndexableFieldType ref2) {
        this.stored = ref2.stored();
        this.tokenized = ref2.tokenized();
        this.storeTermVectors = ref2.storeTermVectors();
        this.storeTermVectorOffsets = ref2.storeTermVectorOffsets();
        this.storeTermVectorPositions = ref2.storeTermVectorPositions();
        this.storeTermVectorPayloads = ref2.storeTermVectorPayloads();
        this.omitNorms = ref2.omitNorms();
        this.indexOptions = ref2.indexOptions();
        this.docValuesType = ref2.docValuesType();
        this.dimensionCount = ref2.pointDimensionCount();
        this.dimensionNumBytes = ref2.pointNumBytes();
    }

    public FieldType() {
    }

    protected void checkIfFrozen() {
        if (this.frozen) {
            throw new IllegalStateException("this FieldType is already frozen and cannot be changed");
        }
    }

    public void freeze() {
        this.frozen = true;
    }

    @Override
    public boolean stored() {
        return this.stored;
    }

    public void setStored(boolean value2) {
        this.checkIfFrozen();
        this.stored = value2;
    }

    @Override
    public boolean tokenized() {
        return this.tokenized;
    }

    public void setTokenized(boolean value2) {
        this.checkIfFrozen();
        this.tokenized = value2;
    }

    @Override
    public boolean storeTermVectors() {
        return this.storeTermVectors;
    }

    public void setStoreTermVectors(boolean value2) {
        this.checkIfFrozen();
        this.storeTermVectors = value2;
    }

    @Override
    public boolean storeTermVectorOffsets() {
        return this.storeTermVectorOffsets;
    }

    public void setStoreTermVectorOffsets(boolean value2) {
        this.checkIfFrozen();
        this.storeTermVectorOffsets = value2;
    }

    @Override
    public boolean storeTermVectorPositions() {
        return this.storeTermVectorPositions;
    }

    public void setStoreTermVectorPositions(boolean value2) {
        this.checkIfFrozen();
        this.storeTermVectorPositions = value2;
    }

    @Override
    public boolean storeTermVectorPayloads() {
        return this.storeTermVectorPayloads;
    }

    public void setStoreTermVectorPayloads(boolean value2) {
        this.checkIfFrozen();
        this.storeTermVectorPayloads = value2;
    }

    @Override
    public boolean omitNorms() {
        return this.omitNorms;
    }

    public void setOmitNorms(boolean value2) {
        this.checkIfFrozen();
        this.omitNorms = value2;
    }

    @Override
    public IndexOptions indexOptions() {
        return this.indexOptions;
    }

    public void setIndexOptions(IndexOptions value2) {
        this.checkIfFrozen();
        if (value2 == null) {
            throw new NullPointerException("IndexOptions must not be null");
        }
        this.indexOptions = value2;
    }

    public void setDimensions(int dimensionCount, int dimensionNumBytes) {
        if (dimensionCount < 0) {
            throw new IllegalArgumentException("dimensionCount must be >= 0; got " + dimensionCount);
        }
        if (dimensionCount > 8) {
            throw new IllegalArgumentException("dimensionCount must be <= 8; got " + dimensionCount);
        }
        if (dimensionNumBytes < 0) {
            throw new IllegalArgumentException("dimensionNumBytes must be >= 0; got " + dimensionNumBytes);
        }
        if (dimensionNumBytes > 16) {
            throw new IllegalArgumentException("dimensionNumBytes must be <= 16; got " + dimensionNumBytes);
        }
        if (dimensionCount == 0) {
            if (dimensionNumBytes != 0) {
                throw new IllegalArgumentException("when dimensionCount is 0, dimensionNumBytes must 0; got " + dimensionNumBytes);
            }
        } else if (dimensionNumBytes == 0 && dimensionCount != 0) {
            throw new IllegalArgumentException("when dimensionNumBytes is 0, dimensionCount must 0; got " + dimensionCount);
        }
        this.dimensionCount = dimensionCount;
        this.dimensionNumBytes = dimensionNumBytes;
    }

    @Override
    public int pointDimensionCount() {
        return this.dimensionCount;
    }

    @Override
    public int pointNumBytes() {
        return this.dimensionNumBytes;
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        if (this.stored()) {
            result2.append("stored");
        }
        if (this.indexOptions != IndexOptions.NONE) {
            if (result2.length() > 0) {
                result2.append(",");
            }
            result2.append("indexed");
            if (this.tokenized()) {
                result2.append(",tokenized");
            }
            if (this.storeTermVectors()) {
                result2.append(",termVector");
            }
            if (this.storeTermVectorOffsets()) {
                result2.append(",termVectorOffsets");
            }
            if (this.storeTermVectorPositions()) {
                result2.append(",termVectorPosition");
            }
            if (this.storeTermVectorPayloads()) {
                result2.append(",termVectorPayloads");
            }
            if (this.omitNorms()) {
                result2.append(",omitNorms");
            }
            if (this.indexOptions != IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) {
                result2.append(",indexOptions=");
                result2.append((Object)this.indexOptions);
            }
        }
        if (this.dimensionCount != 0) {
            if (result2.length() > 0) {
                result2.append(",");
            }
            result2.append("pointDimensionCount=");
            result2.append(this.dimensionCount);
            result2.append(",pointNumBytes=");
            result2.append(this.dimensionNumBytes);
        }
        if (this.docValuesType != DocValuesType.NONE) {
            if (result2.length() > 0) {
                result2.append(",");
            }
            result2.append("docValuesType=");
            result2.append((Object)this.docValuesType);
        }
        return result2.toString();
    }

    @Override
    public DocValuesType docValuesType() {
        return this.docValuesType;
    }

    public void setDocValuesType(DocValuesType type) {
        this.checkIfFrozen();
        if (type == null) {
            throw new NullPointerException("DocValuesType must not be null");
        }
        this.docValuesType = type;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + this.dimensionCount;
        result2 = 31 * result2 + this.dimensionNumBytes;
        result2 = 31 * result2 + (this.docValuesType == null ? 0 : this.docValuesType.hashCode());
        result2 = 31 * result2 + this.indexOptions.hashCode();
        result2 = 31 * result2 + (this.omitNorms ? 1231 : 1237);
        result2 = 31 * result2 + (this.storeTermVectorOffsets ? 1231 : 1237);
        result2 = 31 * result2 + (this.storeTermVectorPayloads ? 1231 : 1237);
        result2 = 31 * result2 + (this.storeTermVectorPositions ? 1231 : 1237);
        result2 = 31 * result2 + (this.storeTermVectors ? 1231 : 1237);
        result2 = 31 * result2 + (this.stored ? 1231 : 1237);
        result2 = 31 * result2 + (this.tokenized ? 1231 : 1237);
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FieldType other = (FieldType)obj;
        if (this.dimensionCount != other.dimensionCount) {
            return false;
        }
        if (this.dimensionNumBytes != other.dimensionNumBytes) {
            return false;
        }
        if (this.docValuesType != other.docValuesType) {
            return false;
        }
        if (this.indexOptions != other.indexOptions) {
            return false;
        }
        if (this.omitNorms != other.omitNorms) {
            return false;
        }
        if (this.storeTermVectorOffsets != other.storeTermVectorOffsets) {
            return false;
        }
        if (this.storeTermVectorPayloads != other.storeTermVectorPayloads) {
            return false;
        }
        if (this.storeTermVectorPositions != other.storeTermVectorPositions) {
            return false;
        }
        if (this.storeTermVectors != other.storeTermVectors) {
            return false;
        }
        if (this.stored != other.stored) {
            return false;
        }
        return this.tokenized == other.tokenized;
    }
}

