/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.BytesTermAttribute;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.util.BytesRef;

public class Field
implements IndexableField {
    protected final IndexableFieldType type;
    protected final String name;
    protected Object fieldsData;
    protected TokenStream tokenStream;

    protected Field(String name, IndexableFieldType type) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        this.name = name;
        if (type == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        this.type = type;
    }

    public Field(String name, Reader reader, IndexableFieldType type) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        if (reader == null) {
            throw new NullPointerException("reader must not be null");
        }
        if (type.stored()) {
            throw new IllegalArgumentException("fields with a Reader value cannot be stored");
        }
        if (type.indexOptions() != IndexOptions.NONE && !type.tokenized()) {
            throw new IllegalArgumentException("non-tokenized fields must use String values");
        }
        this.name = name;
        this.fieldsData = reader;
        this.type = type;
    }

    public Field(String name, TokenStream tokenStream, IndexableFieldType type) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if (tokenStream == null) {
            throw new NullPointerException("tokenStream must not be null");
        }
        if (type.indexOptions() == IndexOptions.NONE || !type.tokenized()) {
            throw new IllegalArgumentException("TokenStream fields must be indexed and tokenized");
        }
        if (type.stored()) {
            throw new IllegalArgumentException("TokenStream fields cannot be stored");
        }
        this.name = name;
        this.fieldsData = null;
        this.tokenStream = tokenStream;
        this.type = type;
    }

    public Field(String name, byte[] value2, IndexableFieldType type) {
        this(name, value2, 0, value2.length, type);
    }

    public Field(String name, byte[] value2, int offset, int length, IndexableFieldType type) {
        this(name, new BytesRef(value2, offset, length), type);
    }

    public Field(String name, BytesRef bytes2, IndexableFieldType type) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if (bytes2 == null) {
            throw new IllegalArgumentException("bytes must not be null");
        }
        this.fieldsData = bytes2;
        this.type = type;
        this.name = name;
    }

    public Field(String name, String value2, IndexableFieldType type) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if (value2 == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        if (!type.stored() && type.indexOptions() == IndexOptions.NONE) {
            throw new IllegalArgumentException("it doesn't make sense to have a field that is neither indexed nor stored");
        }
        this.type = type;
        this.name = name;
        this.fieldsData = value2;
    }

    @Override
    public String stringValue() {
        if (this.fieldsData instanceof String || this.fieldsData instanceof Number) {
            return this.fieldsData.toString();
        }
        return null;
    }

    @Override
    public Reader readerValue() {
        return this.fieldsData instanceof Reader ? (Reader)this.fieldsData : null;
    }

    public TokenStream tokenStreamValue() {
        return this.tokenStream;
    }

    public void setStringValue(String value2) {
        if (!(this.fieldsData instanceof String)) {
            throw new IllegalArgumentException("cannot change value type from " + this.fieldsData.getClass().getSimpleName() + " to String");
        }
        if (value2 == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        this.fieldsData = value2;
    }

    public void setReaderValue(Reader value2) {
        if (!(this.fieldsData instanceof Reader)) {
            throw new IllegalArgumentException("cannot change value type from " + this.fieldsData.getClass().getSimpleName() + " to Reader");
        }
        this.fieldsData = value2;
    }

    public void setBytesValue(byte[] value2) {
        this.setBytesValue(new BytesRef(value2));
    }

    public void setBytesValue(BytesRef value2) {
        if (!(this.fieldsData instanceof BytesRef)) {
            throw new IllegalArgumentException("cannot change value type from " + this.fieldsData.getClass().getSimpleName() + " to BytesRef");
        }
        if (this.type.indexOptions() != IndexOptions.NONE) {
            throw new IllegalArgumentException("cannot set a BytesRef value on an indexed field");
        }
        if (value2 == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        this.fieldsData = value2;
    }

    public void setByteValue(byte value2) {
        if (!(this.fieldsData instanceof Byte)) {
            throw new IllegalArgumentException("cannot change value type from " + this.fieldsData.getClass().getSimpleName() + " to Byte");
        }
        this.fieldsData = value2;
    }

    public void setShortValue(short value2) {
        if (!(this.fieldsData instanceof Short)) {
            throw new IllegalArgumentException("cannot change value type from " + this.fieldsData.getClass().getSimpleName() + " to Short");
        }
        this.fieldsData = value2;
    }

    public void setIntValue(int value2) {
        if (!(this.fieldsData instanceof Integer)) {
            throw new IllegalArgumentException("cannot change value type from " + this.fieldsData.getClass().getSimpleName() + " to Integer");
        }
        this.fieldsData = value2;
    }

    public void setLongValue(long value2) {
        if (!(this.fieldsData instanceof Long)) {
            throw new IllegalArgumentException("cannot change value type from " + this.fieldsData.getClass().getSimpleName() + " to Long");
        }
        this.fieldsData = value2;
    }

    public void setFloatValue(float value2) {
        if (!(this.fieldsData instanceof Float)) {
            throw new IllegalArgumentException("cannot change value type from " + this.fieldsData.getClass().getSimpleName() + " to Float");
        }
        this.fieldsData = Float.valueOf(value2);
    }

    public void setDoubleValue(double value2) {
        if (!(this.fieldsData instanceof Double)) {
            throw new IllegalArgumentException("cannot change value type from " + this.fieldsData.getClass().getSimpleName() + " to Double");
        }
        this.fieldsData = value2;
    }

    public void setTokenStream(TokenStream tokenStream) {
        if (this.type.indexOptions() == IndexOptions.NONE || !this.type.tokenized()) {
            throw new IllegalArgumentException("TokenStream fields must be indexed and tokenized");
        }
        this.tokenStream = tokenStream;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Number numericValue() {
        if (this.fieldsData instanceof Number) {
            return (Number)this.fieldsData;
        }
        return null;
    }

    @Override
    public BytesRef binaryValue() {
        if (this.fieldsData instanceof BytesRef) {
            return (BytesRef)this.fieldsData;
        }
        return null;
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        result2.append(this.type.toString());
        result2.append('<');
        result2.append(this.name);
        result2.append(':');
        if (this.fieldsData != null) {
            result2.append(this.fieldsData);
        }
        result2.append('>');
        return result2.toString();
    }

    @Override
    public IndexableFieldType fieldType() {
        return this.type;
    }

    @Override
    public TokenStream tokenStream(Analyzer analyzer, TokenStream reuse) {
        if (this.fieldType().indexOptions() == IndexOptions.NONE) {
            return null;
        }
        if (!this.fieldType().tokenized()) {
            if (this.stringValue() != null) {
                if (!(reuse instanceof StringTokenStream)) {
                    reuse = new StringTokenStream();
                }
                ((StringTokenStream)reuse).setValue(this.stringValue());
                return reuse;
            }
            if (this.binaryValue() != null) {
                if (!(reuse instanceof BinaryTokenStream)) {
                    reuse = new BinaryTokenStream();
                }
                ((BinaryTokenStream)reuse).setValue(this.binaryValue());
                return reuse;
            }
            throw new IllegalArgumentException("Non-Tokenized Fields must have a String value");
        }
        if (this.tokenStream != null) {
            return this.tokenStream;
        }
        if (this.readerValue() != null) {
            return analyzer.tokenStream(this.name(), this.readerValue());
        }
        if (this.stringValue() != null) {
            return analyzer.tokenStream(this.name(), this.stringValue());
        }
        throw new IllegalArgumentException("Field must have either TokenStream, String, Reader or Number value; got " + this);
    }

    public static enum Store {
        YES,
        NO;

    }

    private static final class StringTokenStream
    extends TokenStream {
        private final CharTermAttribute termAttribute = this.addAttribute(CharTermAttribute.class);
        private final OffsetAttribute offsetAttribute = this.addAttribute(OffsetAttribute.class);
        private boolean used = true;
        private String value = null;

        StringTokenStream() {
        }

        void setValue(String value2) {
            this.value = value2;
        }

        @Override
        public boolean incrementToken() {
            if (this.used) {
                return false;
            }
            this.clearAttributes();
            this.termAttribute.append(this.value);
            this.offsetAttribute.setOffset(0, this.value.length());
            this.used = true;
            return true;
        }

        @Override
        public void end() throws IOException {
            super.end();
            int finalOffset = this.value.length();
            this.offsetAttribute.setOffset(finalOffset, finalOffset);
        }

        @Override
        public void reset() {
            this.used = false;
        }

        @Override
        public void close() {
            this.value = null;
        }
    }

    private static final class BinaryTokenStream
    extends TokenStream {
        private final BytesTermAttribute bytesAtt = this.addAttribute(BytesTermAttribute.class);
        private boolean used = true;
        private BytesRef value;

        BinaryTokenStream() {
        }

        public void setValue(BytesRef value2) {
            this.value = value2;
        }

        @Override
        public boolean incrementToken() {
            if (this.used) {
                return false;
            }
            this.clearAttributes();
            this.bytesAtt.setBytesRef(this.value);
            this.used = true;
            return true;
        }

        @Override
        public void reset() {
            this.used = false;
        }

        @Override
        public void close() {
            this.value = null;
        }
    }
}

