/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.util.Arrays;
import java.util.Collection;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.search.PointInSetQuery;
import org.apache.lucene.search.PointRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;

public final class DoublePoint
extends Field {
    public static double nextUp(double d) {
        if (Double.doubleToLongBits(d) == Long.MIN_VALUE) {
            return 0.0;
        }
        return Math.nextUp(d);
    }

    public static double nextDown(double d) {
        if (Double.doubleToLongBits(d) == 0L) {
            return -0.0;
        }
        return Math.nextDown(d);
    }

    private static FieldType getType(int numDims) {
        FieldType type = new FieldType();
        type.setDimensions(numDims, 8);
        type.freeze();
        return type;
    }

    @Override
    public void setDoubleValue(double value2) {
        this.setDoubleValues(value2);
    }

    public void setDoubleValues(double ... point) {
        if (this.type.pointDimensionCount() != point.length) {
            throw new IllegalArgumentException("this field (name=" + this.name + ") uses " + this.type.pointDimensionCount() + " dimensions; cannot change to (incoming) " + point.length + " dimensions");
        }
        this.fieldsData = DoublePoint.pack(point);
    }

    @Override
    public void setBytesValue(BytesRef bytes2) {
        throw new IllegalArgumentException("cannot change value type from double to BytesRef");
    }

    @Override
    public Number numericValue() {
        if (this.type.pointDimensionCount() != 1) {
            throw new IllegalStateException("this field (name=" + this.name + ") uses " + this.type.pointDimensionCount() + " dimensions; cannot convert to a single numeric value");
        }
        BytesRef bytes2 = (BytesRef)this.fieldsData;
        assert (bytes2.length == 8);
        return DoublePoint.decodeDimension(bytes2.bytes, bytes2.offset);
    }

    private static BytesRef pack(double ... point) {
        if (point == null) {
            throw new IllegalArgumentException("point must not be null");
        }
        if (point.length == 0) {
            throw new IllegalArgumentException("point must not be 0 dimensions");
        }
        byte[] packed = new byte[point.length * 8];
        for (int dim = 0; dim < point.length; ++dim) {
            DoublePoint.encodeDimension(point[dim], packed, dim * 8);
        }
        return new BytesRef(packed);
    }

    public DoublePoint(String name, double ... point) {
        super(name, DoublePoint.pack(point), (IndexableFieldType)DoublePoint.getType(point.length));
    }

    @Override
    public String toString() {
        StringBuilder result2 = new StringBuilder();
        result2.append(this.getClass().getSimpleName());
        result2.append(" <");
        result2.append(this.name);
        result2.append(':');
        BytesRef bytes2 = (BytesRef)this.fieldsData;
        for (int dim = 0; dim < this.type.pointDimensionCount(); ++dim) {
            if (dim > 0) {
                result2.append(',');
            }
            result2.append(DoublePoint.decodeDimension(bytes2.bytes, bytes2.offset + dim * 8));
        }
        result2.append('>');
        return result2.toString();
    }

    public static void encodeDimension(double value2, byte[] dest, int offset) {
        NumericUtils.longToSortableBytes(NumericUtils.doubleToSortableLong(value2), dest, offset);
    }

    public static double decodeDimension(byte[] value2, int offset) {
        return NumericUtils.sortableLongToDouble(NumericUtils.sortableBytesToLong(value2, offset));
    }

    public static Query newExactQuery(String field2, double value2) {
        return DoublePoint.newRangeQuery(field2, value2, value2);
    }

    public static Query newRangeQuery(String field2, double lowerValue, double upperValue) {
        return DoublePoint.newRangeQuery(field2, new double[]{lowerValue}, new double[]{upperValue});
    }

    public static Query newRangeQuery(String field2, double[] lowerValue, double[] upperValue) {
        PointRangeQuery.checkArgs(field2, lowerValue, upperValue);
        return new PointRangeQuery(field2, DoublePoint.pack((double[])lowerValue).bytes, DoublePoint.pack((double[])upperValue).bytes, lowerValue.length){

            @Override
            protected String toString(int dimension, byte[] value2) {
                return Double.toString(DoublePoint.decodeDimension(value2, 0));
            }
        };
    }

    public static Query newSetQuery(String field2, double ... values2) {
        final double[] sortedValues = (double[])values2.clone();
        Arrays.sort(sortedValues);
        final BytesRef encoded = new BytesRef(new byte[8]);
        return new PointInSetQuery(field2, 1, 8, new PointInSetQuery.Stream(){
            int upto;

            @Override
            public BytesRef next() {
                if (this.upto == sortedValues.length) {
                    return null;
                }
                DoublePoint.encodeDimension(sortedValues[this.upto], encoded.bytes, 0);
                ++this.upto;
                return encoded;
            }
        }){

            @Override
            protected String toString(byte[] value2) {
                assert (value2.length == 8);
                return Double.toString(DoublePoint.decodeDimension(value2, 0));
            }
        };
    }

    public static Query newSetQuery(String field2, Collection<Double> values2) {
        Double[] boxed = values2.toArray(new Double[0]);
        double[] unboxed = new double[boxed.length];
        for (int i = 0; i < boxed.length; ++i) {
            unboxed[i] = boxed[i];
        }
        return DoublePoint.newSetQuery(field2, unboxed);
    }
}

