/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene70;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.lucene70.IndexedDISI;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.util.IOUtils;

final class Lucene70NormsProducer
extends NormsProducer {
    private final Map<Integer, NormsEntry> norms;
    private final IndexInput data;
    private final int maxDoc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Lucene70NormsProducer(SegmentReadState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        int version;
        block20: {
            this.norms = new HashMap<Integer, NormsEntry>();
            this.maxDoc = state.segmentInfo.maxDoc();
            String metaName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, metaExtension);
            version = -1;
            try (ChecksumIndexInput in = state.directory.openChecksumInput(metaName, state.context);){
                Throwable priorE = null;
                try {
                    version = CodecUtil.checkIndexHeader(in, metaCodec, 0, 0, state.segmentInfo.getId(), state.segmentSuffix);
                    this.readFields(in, state.fieldInfos);
                }
                catch (Throwable exception) {
                    try {
                        priorE = exception;
                        break block20;
                    }
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                    finally {
                        CodecUtil.checkFooter(in, priorE);
                    }
                }
                CodecUtil.checkFooter(in, priorE);
            }
        }
        String dataName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, dataExtension);
        this.data = state.directory.openInput(dataName, state.context);
        boolean success2 = false;
        try {
            int version2 = CodecUtil.checkIndexHeader(this.data, dataCodec, 0, 0, state.segmentInfo.getId(), state.segmentSuffix);
            if (version != version2) {
                throw new CorruptIndexException("Format versions mismatch: meta=" + version + ",data=" + version2, this.data);
            }
            CodecUtil.retrieveChecksum(this.data);
            return;
        }
        catch (Throwable throwable3) {
            if (success2) throw throwable3;
            IOUtils.closeWhileHandlingException(this.data);
            throw throwable3;
        }
    }

    private void readFields(IndexInput meta, FieldInfos infos) throws IOException {
        int fieldNumber = meta.readInt();
        while (fieldNumber != -1) {
            FieldInfo info2 = infos.fieldInfo(fieldNumber);
            if (info2 == null) {
                throw new CorruptIndexException("Invalid field number: " + fieldNumber, meta);
            }
            if (!info2.hasNorms()) {
                throw new CorruptIndexException("Invalid field: " + info2.name, meta);
            }
            NormsEntry entry2 = new NormsEntry();
            entry2.docsWithFieldOffset = meta.readLong();
            entry2.docsWithFieldLength = meta.readLong();
            entry2.numDocsWithField = meta.readInt();
            entry2.bytesPerNorm = meta.readByte();
            switch (entry2.bytesPerNorm) {
                case 0: 
                case 1: 
                case 2: 
                case 4: 
                case 8: {
                    break;
                }
                default: {
                    throw new CorruptIndexException("Invalid bytesPerValue: " + entry2.bytesPerNorm + ", field: " + info2.name, meta);
                }
            }
            entry2.normsOffset = meta.readLong();
            this.norms.put(info2.number, entry2);
            fieldNumber = meta.readInt();
        }
    }

    @Override
    public NumericDocValues getNorms(FieldInfo field2) throws IOException {
        final NormsEntry entry2 = this.norms.get(field2.number);
        if (entry2.docsWithFieldOffset == -2L) {
            return DocValues.emptyNumeric();
        }
        if (entry2.docsWithFieldOffset == -1L) {
            if (entry2.bytesPerNorm == 0) {
                return new DenseNormsIterator(this.maxDoc){

                    @Override
                    public long longValue() throws IOException {
                        return entry2.normsOffset;
                    }
                };
            }
            final RandomAccessInput slice2 = this.data.randomAccessSlice(entry2.normsOffset, (long)entry2.numDocsWithField * (long)entry2.bytesPerNorm);
            switch (entry2.bytesPerNorm) {
                case 1: {
                    return new DenseNormsIterator(this.maxDoc){

                        @Override
                        public long longValue() throws IOException {
                            return slice2.readByte(this.doc);
                        }
                    };
                }
                case 2: {
                    return new DenseNormsIterator(this.maxDoc){

                        @Override
                        public long longValue() throws IOException {
                            return slice2.readShort((long)this.doc << 1);
                        }
                    };
                }
                case 4: {
                    return new DenseNormsIterator(this.maxDoc){

                        @Override
                        public long longValue() throws IOException {
                            return slice2.readInt((long)this.doc << 2);
                        }
                    };
                }
                case 8: {
                    return new DenseNormsIterator(this.maxDoc){

                        @Override
                        public long longValue() throws IOException {
                            return slice2.readLong((long)this.doc << 3);
                        }
                    };
                }
            }
            throw new AssertionError();
        }
        IndexedDISI disi = new IndexedDISI(this.data, entry2.docsWithFieldOffset, entry2.docsWithFieldLength, entry2.numDocsWithField);
        if (entry2.bytesPerNorm == 0) {
            return new SparseNormsIterator(disi){

                @Override
                public long longValue() throws IOException {
                    return entry2.normsOffset;
                }
            };
        }
        final RandomAccessInput slice3 = this.data.randomAccessSlice(entry2.normsOffset, (long)entry2.numDocsWithField * (long)entry2.bytesPerNorm);
        switch (entry2.bytesPerNorm) {
            case 1: {
                return new SparseNormsIterator(disi){

                    @Override
                    public long longValue() throws IOException {
                        return slice3.readByte(this.disi.index());
                    }
                };
            }
            case 2: {
                return new SparseNormsIterator(disi){

                    @Override
                    public long longValue() throws IOException {
                        return slice3.readShort((long)this.disi.index() << 1);
                    }
                };
            }
            case 4: {
                return new SparseNormsIterator(disi){

                    @Override
                    public long longValue() throws IOException {
                        return slice3.readInt((long)this.disi.index() << 2);
                    }
                };
            }
            case 8: {
                return new SparseNormsIterator(disi){

                    @Override
                    public long longValue() throws IOException {
                        return slice3.readLong((long)this.disi.index() << 3);
                    }
                };
            }
        }
        throw new AssertionError();
    }

    @Override
    public void close() throws IOException {
        this.data.close();
    }

    @Override
    public long ramBytesUsed() {
        return 64L * (long)this.norms.size();
    }

    @Override
    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile(this.data);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(fields=" + this.norms.size() + ")";
    }

    static abstract class SparseNormsIterator
    extends NumericDocValues {
        final IndexedDISI disi;

        SparseNormsIterator(IndexedDISI disi) {
            this.disi = disi;
        }

        @Override
        public int docID() {
            return this.disi.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            return this.disi.nextDoc();
        }

        @Override
        public int advance(int target) throws IOException {
            return this.disi.advance(target);
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            return this.disi.advanceExact(target);
        }

        @Override
        public long cost() {
            return this.disi.cost();
        }
    }

    static abstract class DenseNormsIterator
    extends NumericDocValues {
        final int maxDoc;
        int doc = -1;

        DenseNormsIterator(int maxDoc) {
            this.maxDoc = maxDoc;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.advance(this.doc + 1);
        }

        @Override
        public int advance(int target) throws IOException {
            if (target >= this.maxDoc) {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.doc = target;
            return this.doc;
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            this.doc = target;
            return true;
        }

        @Override
        public long cost() {
            return this.maxDoc;
        }
    }

    static class NormsEntry {
        byte bytesPerNorm;
        long docsWithFieldOffset;
        long docsWithFieldLength;
        int numDocsWithField;
        long normsOffset;

        NormsEntry() {
        }
    }
}

