/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene70;

import java.io.IOException;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.NormsConsumer;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.lucene70.IndexedDISI;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.IOUtils;

final class Lucene70NormsConsumer
extends NormsConsumer {
    IndexOutput data;
    IndexOutput meta;
    final int maxDoc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Lucene70NormsConsumer(SegmentWriteState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        boolean success2 = false;
        try {
            String dataName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, dataExtension);
            this.data = state.directory.createOutput(dataName, state.context);
            CodecUtil.writeIndexHeader(this.data, dataCodec, 0, state.segmentInfo.getId(), state.segmentSuffix);
            String metaName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, metaExtension);
            this.meta = state.directory.createOutput(metaName, state.context);
            CodecUtil.writeIndexHeader(this.meta, metaCodec, 0, state.segmentInfo.getId(), state.segmentSuffix);
            this.maxDoc = state.segmentInfo.maxDoc();
            return;
        }
        catch (Throwable throwable2) {
            if (success2) throw throwable2;
            IOUtils.closeWhileHandlingException(this);
            throw throwable2;
        }
    }

    @Override
    public void close() throws IOException {
        block7: {
            block6: {
                boolean success2 = false;
                try {
                    if (this.meta != null) {
                        this.meta.writeInt(-1);
                        CodecUtil.writeFooter(this.meta);
                    }
                    if (this.data != null) {
                        CodecUtil.writeFooter(this.data);
                    }
                    if (!(success2 = true)) break block6;
                }
                catch (Throwable throwable2) {
                    if (success2) {
                        IOUtils.close(this.data, this.meta);
                    } else {
                        IOUtils.closeWhileHandlingException(this.data, this.meta);
                    }
                    this.data = null;
                    this.meta = null;
                    throw throwable2;
                }
                IOUtils.close(this.data, this.meta);
                break block7;
            }
            IOUtils.closeWhileHandlingException(this.data, this.meta);
        }
        this.data = null;
        this.meta = null;
    }

    @Override
    public void addNormsField(FieldInfo field2, NormsProducer normsProducer) throws IOException {
        NumericDocValues values2 = normsProducer.getNorms(field2);
        int numDocsWithValue = 0;
        long min2 = Long.MAX_VALUE;
        long max2 = Long.MIN_VALUE;
        int doc = values2.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            ++numDocsWithValue;
            long v = values2.longValue();
            min2 = Math.min(min2, v);
            max2 = Math.max(max2, v);
            doc = values2.nextDoc();
        }
        assert (numDocsWithValue <= this.maxDoc);
        this.meta.writeInt(field2.number);
        if (numDocsWithValue == 0) {
            this.meta.writeLong(-2L);
            this.meta.writeLong(0L);
        } else if (numDocsWithValue == this.maxDoc) {
            this.meta.writeLong(-1L);
            this.meta.writeLong(0L);
        } else {
            long offset = this.data.getFilePointer();
            this.meta.writeLong(offset);
            values2 = normsProducer.getNorms(field2);
            IndexedDISI.writeBitSet(values2, this.data);
            this.meta.writeLong(this.data.getFilePointer() - offset);
        }
        this.meta.writeInt(numDocsWithValue);
        int numBytesPerValue = this.numBytesPerValue(min2, max2);
        this.meta.writeByte((byte)numBytesPerValue);
        if (numBytesPerValue == 0) {
            this.meta.writeLong(min2);
        } else {
            this.meta.writeLong(this.data.getFilePointer());
            values2 = normsProducer.getNorms(field2);
            this.writeValues(values2, numBytesPerValue, this.data);
        }
    }

    private int numBytesPerValue(long min2, long max2) {
        if (min2 >= max2) {
            return 0;
        }
        if (min2 >= -128L && max2 <= 127L) {
            return 1;
        }
        if (min2 >= -32768L && max2 <= 32767L) {
            return 2;
        }
        if (min2 >= Integer.MIN_VALUE && max2 <= Integer.MAX_VALUE) {
            return 4;
        }
        return 8;
    }

    private void writeValues(NumericDocValues values2, int numBytesPerValue, IndexOutput out) throws IOException, AssertionError {
        int doc = values2.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            long value2 = values2.longValue();
            switch (numBytesPerValue) {
                case 1: {
                    out.writeByte((byte)value2);
                    break;
                }
                case 2: {
                    out.writeShort((short)value2);
                    break;
                }
                case 4: {
                    out.writeInt((int)value2);
                    break;
                }
                case 8: {
                    out.writeLong(value2);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            doc = values2.nextDoc();
        }
    }
}

