/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene70;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.lucene70.IndexedDISI;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.DirectMonotonicReader;
import org.apache.lucene.util.packed.DirectReader;

final class Lucene70DocValuesProducer
extends DocValuesProducer
implements Closeable {
    private final Map<String, NumericEntry> numerics;
    private final Map<String, BinaryEntry> binaries;
    private final Map<String, SortedEntry> sorted;
    private final Map<String, SortedSetEntry> sortedSets;
    private final Map<String, SortedNumericEntry> sortedNumerics;
    private long ramBytesUsed;
    private final IndexInput data;
    private final int maxDoc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Lucene70DocValuesProducer(SegmentReadState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        int version;
        block20: {
            this.numerics = new HashMap<String, NumericEntry>();
            this.binaries = new HashMap<String, BinaryEntry>();
            this.sorted = new HashMap<String, SortedEntry>();
            this.sortedSets = new HashMap<String, SortedSetEntry>();
            this.sortedNumerics = new HashMap<String, SortedNumericEntry>();
            String metaName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, metaExtension);
            this.maxDoc = state.segmentInfo.maxDoc();
            this.ramBytesUsed = RamUsageEstimator.shallowSizeOfInstance(this.getClass());
            version = -1;
            try (ChecksumIndexInput in = state.directory.openChecksumInput(metaName, state.context);){
                Throwable priorE = null;
                try {
                    version = CodecUtil.checkIndexHeader(in, metaCodec, 0, 0, state.segmentInfo.getId(), state.segmentSuffix);
                    this.readFields(in, state.fieldInfos);
                }
                catch (Throwable exception) {
                    try {
                        priorE = exception;
                        break block20;
                    }
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                    finally {
                        CodecUtil.checkFooter(in, priorE);
                    }
                }
                CodecUtil.checkFooter(in, priorE);
            }
        }
        String dataName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, dataExtension);
        this.data = state.directory.openInput(dataName, state.context);
        boolean success2 = false;
        try {
            int version2 = CodecUtil.checkIndexHeader(this.data, dataCodec, 0, 0, state.segmentInfo.getId(), state.segmentSuffix);
            if (version != version2) {
                throw new CorruptIndexException("Format versions mismatch: meta=" + version + ", data=" + version2, this.data);
            }
            CodecUtil.retrieveChecksum(this.data);
            return;
        }
        catch (Throwable throwable3) {
            if (success2) throw throwable3;
            IOUtils.closeWhileHandlingException(this.data);
            throw throwable3;
        }
    }

    private void readFields(ChecksumIndexInput meta, FieldInfos infos) throws IOException {
        int fieldNumber = meta.readInt();
        while (fieldNumber != -1) {
            FieldInfo info2 = infos.fieldInfo(fieldNumber);
            if (info2 == null) {
                throw new CorruptIndexException("Invalid field number: " + fieldNumber, meta);
            }
            byte type = meta.readByte();
            if (type == 0) {
                this.numerics.put(info2.name, this.readNumeric(meta));
            } else if (type == 1) {
                this.binaries.put(info2.name, this.readBinary(meta));
            } else if (type == 2) {
                this.sorted.put(info2.name, this.readSorted(meta));
            } else if (type == 3) {
                this.sortedSets.put(info2.name, this.readSortedSet(meta));
            } else if (type == 4) {
                this.sortedNumerics.put(info2.name, this.readSortedNumeric(meta));
            } else {
                throw new CorruptIndexException("invalid type: " + type, meta);
            }
            fieldNumber = meta.readInt();
        }
    }

    private NumericEntry readNumeric(ChecksumIndexInput meta) throws IOException {
        NumericEntry entry2 = new NumericEntry();
        this.readNumeric(meta, entry2);
        return entry2;
    }

    private void readNumeric(ChecksumIndexInput meta, NumericEntry entry2) throws IOException {
        entry2.docsWithFieldOffset = meta.readLong();
        entry2.docsWithFieldLength = meta.readLong();
        entry2.numValues = meta.readLong();
        int tableSize = meta.readInt();
        if (tableSize > 256) {
            throw new CorruptIndexException("invalid table size: " + tableSize, meta);
        }
        if (tableSize >= 0) {
            entry2.table = new long[tableSize];
            this.ramBytesUsed += RamUsageEstimator.sizeOf(entry2.table);
            for (int i = 0; i < tableSize; ++i) {
                entry2.table[i] = meta.readLong();
            }
        }
        entry2.blockShift = tableSize < -1 ? -2 - tableSize : -1;
        entry2.bitsPerValue = meta.readByte();
        entry2.minValue = meta.readLong();
        entry2.gcd = meta.readLong();
        entry2.valuesOffset = meta.readLong();
        entry2.valuesLength = meta.readLong();
    }

    private BinaryEntry readBinary(ChecksumIndexInput meta) throws IOException {
        BinaryEntry entry2 = new BinaryEntry();
        entry2.dataOffset = meta.readLong();
        entry2.dataLength = meta.readLong();
        entry2.docsWithFieldOffset = meta.readLong();
        entry2.docsWithFieldLength = meta.readLong();
        entry2.numDocsWithField = meta.readInt();
        entry2.minLength = meta.readInt();
        entry2.maxLength = meta.readInt();
        if (entry2.minLength < entry2.maxLength) {
            entry2.addressesOffset = meta.readLong();
            int blockShift = meta.readVInt();
            entry2.addressesMeta = DirectMonotonicReader.loadMeta(meta, (long)entry2.numDocsWithField + 1L, blockShift);
            this.ramBytesUsed += entry2.addressesMeta.ramBytesUsed();
            entry2.addressesLength = meta.readLong();
        }
        return entry2;
    }

    private SortedEntry readSorted(ChecksumIndexInput meta) throws IOException {
        SortedEntry entry2 = new SortedEntry();
        entry2.docsWithFieldOffset = meta.readLong();
        entry2.docsWithFieldLength = meta.readLong();
        entry2.numDocsWithField = meta.readInt();
        entry2.bitsPerValue = meta.readByte();
        entry2.ordsOffset = meta.readLong();
        entry2.ordsLength = meta.readLong();
        Lucene70DocValuesProducer.readTermDict(meta, entry2);
        return entry2;
    }

    private SortedSetEntry readSortedSet(ChecksumIndexInput meta) throws IOException {
        SortedSetEntry entry2 = new SortedSetEntry();
        byte multiValued = meta.readByte();
        switch (multiValued) {
            case 0: {
                entry2.singleValueEntry = this.readSorted(meta);
                return entry2;
            }
            case 1: {
                break;
            }
            default: {
                throw new CorruptIndexException("Invalid multiValued flag: " + multiValued, meta);
            }
        }
        entry2.docsWithFieldOffset = meta.readLong();
        entry2.docsWithFieldLength = meta.readLong();
        entry2.bitsPerValue = meta.readByte();
        entry2.ordsOffset = meta.readLong();
        entry2.ordsLength = meta.readLong();
        entry2.numDocsWithField = meta.readInt();
        entry2.addressesOffset = meta.readLong();
        int blockShift = meta.readVInt();
        entry2.addressesMeta = DirectMonotonicReader.loadMeta(meta, entry2.numDocsWithField + 1, blockShift);
        this.ramBytesUsed += entry2.addressesMeta.ramBytesUsed();
        entry2.addressesLength = meta.readLong();
        Lucene70DocValuesProducer.readTermDict(meta, entry2);
        return entry2;
    }

    private static void readTermDict(ChecksumIndexInput meta, TermsDictEntry entry2) throws IOException {
        entry2.termsDictSize = meta.readVLong();
        entry2.termsDictBlockShift = meta.readInt();
        int blockShift = meta.readInt();
        long addressesSize = entry2.termsDictSize + (1L << entry2.termsDictBlockShift) - 1L >>> entry2.termsDictBlockShift;
        entry2.termsAddressesMeta = DirectMonotonicReader.loadMeta(meta, addressesSize, blockShift);
        entry2.maxTermLength = meta.readInt();
        entry2.termsDataOffset = meta.readLong();
        entry2.termsDataLength = meta.readLong();
        entry2.termsAddressesOffset = meta.readLong();
        entry2.termsAddressesLength = meta.readLong();
        entry2.termsDictIndexShift = meta.readInt();
        long indexSize = entry2.termsDictSize + (1L << entry2.termsDictIndexShift) - 1L >>> entry2.termsDictIndexShift;
        entry2.termsIndexAddressesMeta = DirectMonotonicReader.loadMeta(meta, 1L + indexSize, blockShift);
        entry2.termsIndexOffset = meta.readLong();
        entry2.termsIndexLength = meta.readLong();
        entry2.termsIndexAddressesOffset = meta.readLong();
        entry2.termsIndexAddressesLength = meta.readLong();
    }

    private SortedNumericEntry readSortedNumeric(ChecksumIndexInput meta) throws IOException {
        SortedNumericEntry entry2 = new SortedNumericEntry();
        this.readNumeric(meta, entry2);
        entry2.numDocsWithField = meta.readInt();
        if ((long)entry2.numDocsWithField != entry2.numValues) {
            entry2.addressesOffset = meta.readLong();
            int blockShift = meta.readVInt();
            entry2.addressesMeta = DirectMonotonicReader.loadMeta(meta, entry2.numDocsWithField + 1, blockShift);
            this.ramBytesUsed += entry2.addressesMeta.ramBytesUsed();
            entry2.addressesLength = meta.readLong();
        }
        return entry2;
    }

    @Override
    public void close() throws IOException {
        this.data.close();
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }

    @Override
    public NumericDocValues getNumeric(FieldInfo field2) throws IOException {
        NumericEntry entry2 = this.numerics.get(field2.name);
        return this.getNumeric(entry2);
    }

    private NumericDocValues getNumeric(final NumericEntry entry2) throws IOException {
        if (entry2.docsWithFieldOffset == -2L) {
            return DocValues.emptyNumeric();
        }
        if (entry2.docsWithFieldOffset == -1L) {
            if (entry2.bitsPerValue == 0) {
                return new DenseNumericDocValues(this.maxDoc){

                    @Override
                    public long longValue() throws IOException {
                        return entry2.minValue;
                    }
                };
            }
            final RandomAccessInput slice2 = this.data.randomAccessSlice(entry2.valuesOffset, entry2.valuesLength);
            if (entry2.blockShift >= 0) {
                final int shift = entry2.blockShift;
                final long mul = entry2.gcd;
                final int mask = (1 << shift) - 1;
                return new DenseNumericDocValues(this.maxDoc){
                    int block;
                    long delta;
                    long offset;
                    long blockEndOffset;
                    LongValues values;
                    {
                        super(maxDoc);
                        this.block = -1;
                    }

                    @Override
                    public long longValue() throws IOException {
                        int block = this.doc >>> shift;
                        if (this.block != block) {
                            byte bitsPerValue;
                            do {
                                this.offset = this.blockEndOffset;
                                bitsPerValue = slice2.readByte(this.offset++);
                                this.delta = slice2.readLong(this.offset);
                                this.offset += 8L;
                                if (bitsPerValue == 0) {
                                    this.blockEndOffset = this.offset;
                                } else {
                                    int length = slice2.readInt(this.offset);
                                    this.offset += 4L;
                                    this.blockEndOffset = this.offset + (long)length;
                                }
                                ++this.block;
                            } while (this.block != block);
                            this.values = bitsPerValue == 0 ? LongValues.ZEROES : DirectReader.getInstance(slice2, bitsPerValue, this.offset);
                        }
                        return mul * this.values.get(this.doc & mask) + this.delta;
                    }
                };
            }
            final LongValues values2 = DirectReader.getInstance(slice2, entry2.bitsPerValue);
            if (entry2.table != null) {
                final long[] table = entry2.table;
                return new DenseNumericDocValues(this.maxDoc){

                    @Override
                    public long longValue() throws IOException {
                        return table[(int)values2.get(this.doc)];
                    }
                };
            }
            final long mul = entry2.gcd;
            final long delta = entry2.minValue;
            return new DenseNumericDocValues(this.maxDoc){

                @Override
                public long longValue() throws IOException {
                    return mul * values2.get(this.doc) + delta;
                }
            };
        }
        IndexedDISI disi = new IndexedDISI(this.data, entry2.docsWithFieldOffset, entry2.docsWithFieldLength, entry2.numValues);
        if (entry2.bitsPerValue == 0) {
            return new SparseNumericDocValues(disi){

                @Override
                public long longValue() throws IOException {
                    return entry2.minValue;
                }
            };
        }
        final RandomAccessInput slice3 = this.data.randomAccessSlice(entry2.valuesOffset, entry2.valuesLength);
        if (entry2.blockShift >= 0) {
            final int shift = entry2.blockShift;
            final long mul = entry2.gcd;
            final int mask = (1 << shift) - 1;
            return new SparseNumericDocValues(disi){
                int block;
                long delta;
                long offset;
                long blockEndOffset;
                LongValues values;
                {
                    super(disi);
                    this.block = -1;
                }

                @Override
                public long longValue() throws IOException {
                    int index2 = this.disi.index();
                    int block = index2 >>> shift;
                    if (this.block != block) {
                        byte bitsPerValue;
                        do {
                            this.offset = this.blockEndOffset;
                            bitsPerValue = slice3.readByte(this.offset++);
                            this.delta = slice3.readLong(this.offset);
                            this.offset += 8L;
                            if (bitsPerValue == 0) {
                                this.blockEndOffset = this.offset;
                            } else {
                                int length = slice3.readInt(this.offset);
                                this.offset += 4L;
                                this.blockEndOffset = this.offset + (long)length;
                            }
                            ++this.block;
                        } while (this.block != block);
                        this.values = bitsPerValue == 0 ? LongValues.ZEROES : DirectReader.getInstance(slice3, bitsPerValue, this.offset);
                    }
                    return mul * this.values.get(index2 & mask) + this.delta;
                }
            };
        }
        final LongValues values3 = DirectReader.getInstance(slice3, entry2.bitsPerValue);
        if (entry2.table != null) {
            final long[] table = entry2.table;
            return new SparseNumericDocValues(disi){

                @Override
                public long longValue() throws IOException {
                    return table[(int)values3.get(this.disi.index())];
                }
            };
        }
        final long mul = entry2.gcd;
        final long delta = entry2.minValue;
        return new SparseNumericDocValues(disi){

            @Override
            public long longValue() throws IOException {
                return mul * values3.get(this.disi.index()) + delta;
            }
        };
    }

    private LongValues getNumericValues(final NumericEntry entry2) throws IOException {
        if (entry2.bitsPerValue == 0) {
            return new LongValues(){

                @Override
                public long get(long index2) {
                    return entry2.minValue;
                }
            };
        }
        final RandomAccessInput slice2 = this.data.randomAccessSlice(entry2.valuesOffset, entry2.valuesLength);
        if (entry2.blockShift >= 0) {
            final int shift = entry2.blockShift;
            final long mul = entry2.gcd;
            final long mask = (1L << shift) - 1L;
            return new LongValues(){
                long block = -1L;
                long delta;
                long offset;
                long blockEndOffset;
                LongValues values;

                @Override
                public long get(long index2) {
                    long block = index2 >>> shift;
                    if (this.block != block) {
                        byte bitsPerValue;
                        assert (block > this.block) : "Reading backwards is illegal: " + this.block + " < " + block;
                        do {
                            this.offset = this.blockEndOffset;
                            try {
                                bitsPerValue = slice2.readByte(this.offset++);
                                this.delta = slice2.readLong(this.offset);
                                this.offset += 8L;
                                if (bitsPerValue == 0) {
                                    this.blockEndOffset = this.offset;
                                } else {
                                    int length = slice2.readInt(this.offset);
                                    this.offset += 4L;
                                    this.blockEndOffset = this.offset + (long)length;
                                }
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                            ++this.block;
                        } while (this.block != block);
                        this.values = bitsPerValue == 0 ? LongValues.ZEROES : DirectReader.getInstance(slice2, bitsPerValue, this.offset);
                    }
                    return mul * this.values.get(index2 & mask) + this.delta;
                }
            };
        }
        final LongValues values2 = DirectReader.getInstance(slice2, entry2.bitsPerValue);
        if (entry2.table != null) {
            final long[] table = entry2.table;
            return new LongValues(){

                @Override
                public long get(long index2) {
                    return table[(int)values2.get(index2)];
                }
            };
        }
        if (entry2.gcd != 1L) {
            final long gcd = entry2.gcd;
            final long minValue = entry2.minValue;
            return new LongValues(){

                @Override
                public long get(long index2) {
                    return values2.get(index2) * gcd + minValue;
                }
            };
        }
        if (entry2.minValue != 0L) {
            final long minValue = entry2.minValue;
            return new LongValues(){

                @Override
                public long get(long index2) {
                    return values2.get(index2) + minValue;
                }
            };
        }
        return values2;
    }

    @Override
    public BinaryDocValues getBinary(FieldInfo field2) throws IOException {
        final BinaryEntry entry2 = this.binaries.get(field2.name);
        if (entry2.docsWithFieldOffset == -2L) {
            return DocValues.emptyBinary();
        }
        final IndexInput bytesSlice = this.data.slice("fixed-binary", entry2.dataOffset, entry2.dataLength);
        if (entry2.docsWithFieldOffset == -1L) {
            if (entry2.minLength == entry2.maxLength) {
                final int length = entry2.maxLength;
                return new DenseBinaryDocValues(this.maxDoc){
                    final BytesRef bytes;
                    {
                        super(maxDoc);
                        this.bytes = new BytesRef(new byte[length], 0, length);
                    }

                    @Override
                    public BytesRef binaryValue() throws IOException {
                        bytesSlice.seek((long)this.doc * (long)length);
                        bytesSlice.readBytes(this.bytes.bytes, 0, length);
                        return this.bytes;
                    }
                };
            }
            RandomAccessInput addressesData = this.data.randomAccessSlice(entry2.addressesOffset, entry2.addressesLength);
            final LongValues addresses = DirectMonotonicReader.getInstance(entry2.addressesMeta, addressesData);
            return new DenseBinaryDocValues(this.maxDoc){
                final BytesRef bytes;
                {
                    super(maxDoc);
                    this.bytes = new BytesRef(new byte[entry2.maxLength], 0, entry2.maxLength);
                }

                @Override
                public BytesRef binaryValue() throws IOException {
                    long startOffset = addresses.get(this.doc);
                    this.bytes.length = (int)(addresses.get((long)this.doc + 1L) - startOffset);
                    bytesSlice.seek(startOffset);
                    bytesSlice.readBytes(this.bytes.bytes, 0, this.bytes.length);
                    return this.bytes;
                }
            };
        }
        IndexedDISI disi = new IndexedDISI(this.data, entry2.docsWithFieldOffset, entry2.docsWithFieldLength, entry2.numDocsWithField);
        if (entry2.minLength == entry2.maxLength) {
            final int length = entry2.maxLength;
            return new SparseBinaryDocValues(disi){
                final BytesRef bytes;
                {
                    super(disi);
                    this.bytes = new BytesRef(new byte[length], 0, length);
                }

                @Override
                public BytesRef binaryValue() throws IOException {
                    bytesSlice.seek((long)this.disi.index() * (long)length);
                    bytesSlice.readBytes(this.bytes.bytes, 0, length);
                    return this.bytes;
                }
            };
        }
        RandomAccessInput addressesData = this.data.randomAccessSlice(entry2.addressesOffset, entry2.addressesLength);
        final LongValues addresses = DirectMonotonicReader.getInstance(entry2.addressesMeta, addressesData);
        return new SparseBinaryDocValues(disi){
            final BytesRef bytes;
            {
                super(disi);
                this.bytes = new BytesRef(new byte[entry2.maxLength], 0, entry2.maxLength);
            }

            @Override
            public BytesRef binaryValue() throws IOException {
                int index2 = this.disi.index();
                long startOffset = addresses.get(index2);
                this.bytes.length = (int)(addresses.get((long)index2 + 1L) - startOffset);
                bytesSlice.seek(startOffset);
                bytesSlice.readBytes(this.bytes.bytes, 0, this.bytes.length);
                return this.bytes;
            }
        };
    }

    @Override
    public SortedDocValues getSorted(FieldInfo field2) throws IOException {
        SortedEntry entry2 = this.sorted.get(field2.name);
        return this.getSorted(entry2);
    }

    private SortedDocValues getSorted(SortedEntry entry2) throws IOException {
        LongValues ords;
        if (entry2.docsWithFieldOffset == -2L) {
            return DocValues.emptySorted();
        }
        if (entry2.bitsPerValue == 0) {
            ords = new LongValues(){

                @Override
                public long get(long index2) {
                    return 0L;
                }
            };
        } else {
            RandomAccessInput slice2 = this.data.randomAccessSlice(entry2.ordsOffset, entry2.ordsLength);
            ords = DirectReader.getInstance(slice2, entry2.bitsPerValue);
        }
        if (entry2.docsWithFieldOffset == -1L) {
            return new BaseSortedDocValues(entry2, this.data){
                int doc;
                {
                    super(entry2, data);
                    this.doc = -1;
                }

                @Override
                public int nextDoc() throws IOException {
                    return this.advance(this.doc + 1);
                }

                @Override
                public int docID() {
                    return this.doc;
                }

                @Override
                public long cost() {
                    return Lucene70DocValuesProducer.this.maxDoc;
                }

                @Override
                public int advance(int target) throws IOException {
                    if (target >= Lucene70DocValuesProducer.this.maxDoc) {
                        this.doc = Integer.MAX_VALUE;
                        return Integer.MAX_VALUE;
                    }
                    this.doc = target;
                    return this.doc;
                }

                @Override
                public boolean advanceExact(int target) {
                    this.doc = target;
                    return true;
                }

                @Override
                public int ordValue() {
                    return (int)ords.get(this.doc);
                }
            };
        }
        final IndexedDISI disi = new IndexedDISI(this.data, entry2.docsWithFieldOffset, entry2.docsWithFieldLength, entry2.numDocsWithField);
        return new BaseSortedDocValues(entry2, this.data){

            @Override
            public int nextDoc() throws IOException {
                return disi.nextDoc();
            }

            @Override
            public int docID() {
                return disi.docID();
            }

            @Override
            public long cost() {
                return disi.cost();
            }

            @Override
            public int advance(int target) throws IOException {
                return disi.advance(target);
            }

            @Override
            public boolean advanceExact(int target) throws IOException {
                return disi.advanceExact(target);
            }

            @Override
            public int ordValue() {
                return (int)ords.get(disi.index());
            }
        };
    }

    @Override
    public SortedNumericDocValues getSortedNumeric(FieldInfo field2) throws IOException {
        SortedNumericEntry entry2 = this.sortedNumerics.get(field2.name);
        if (entry2.numValues == (long)entry2.numDocsWithField) {
            return DocValues.singleton(this.getNumeric(entry2));
        }
        RandomAccessInput addressesInput = this.data.randomAccessSlice(entry2.addressesOffset, entry2.addressesLength);
        final LongValues addresses = DirectMonotonicReader.getInstance(entry2.addressesMeta, addressesInput);
        final LongValues values2 = this.getNumericValues(entry2);
        if (entry2.docsWithFieldOffset == -1L) {
            return new SortedNumericDocValues(){
                int doc = -1;
                long start;
                long end;
                int count;

                @Override
                public int nextDoc() throws IOException {
                    return this.advance(this.doc + 1);
                }

                @Override
                public int docID() {
                    return this.doc;
                }

                @Override
                public long cost() {
                    return Lucene70DocValuesProducer.this.maxDoc;
                }

                @Override
                public int advance(int target) throws IOException {
                    if (target >= Lucene70DocValuesProducer.this.maxDoc) {
                        this.doc = Integer.MAX_VALUE;
                        return Integer.MAX_VALUE;
                    }
                    this.start = addresses.get(target);
                    this.end = addresses.get((long)target + 1L);
                    this.count = (int)(this.end - this.start);
                    this.doc = target;
                    return this.doc;
                }

                @Override
                public boolean advanceExact(int target) throws IOException {
                    this.start = addresses.get(target);
                    this.end = addresses.get((long)target + 1L);
                    this.count = (int)(this.end - this.start);
                    this.doc = target;
                    return true;
                }

                @Override
                public long nextValue() throws IOException {
                    return values2.get(this.start++);
                }

                @Override
                public int docValueCount() {
                    return this.count;
                }
            };
        }
        final IndexedDISI disi = new IndexedDISI(this.data, entry2.docsWithFieldOffset, entry2.docsWithFieldLength, entry2.numDocsWithField);
        return new SortedNumericDocValues(){
            boolean set;
            long start;
            long end;
            int count;

            @Override
            public int nextDoc() throws IOException {
                this.set = false;
                return disi.nextDoc();
            }

            @Override
            public int docID() {
                return disi.docID();
            }

            @Override
            public long cost() {
                return disi.cost();
            }

            @Override
            public int advance(int target) throws IOException {
                this.set = false;
                return disi.advance(target);
            }

            @Override
            public boolean advanceExact(int target) throws IOException {
                this.set = false;
                return disi.advanceExact(target);
            }

            @Override
            public long nextValue() throws IOException {
                this.set();
                return values2.get(this.start++);
            }

            @Override
            public int docValueCount() {
                this.set();
                return this.count;
            }

            private void set() {
                if (!this.set) {
                    int index2 = disi.index();
                    this.start = addresses.get(index2);
                    this.end = addresses.get((long)index2 + 1L);
                    this.count = (int)(this.end - this.start);
                    this.set = true;
                }
            }
        };
    }

    @Override
    public SortedSetDocValues getSortedSet(FieldInfo field2) throws IOException {
        SortedSetEntry entry2 = this.sortedSets.get(field2.name);
        if (entry2.singleValueEntry != null) {
            return DocValues.singleton(this.getSorted(entry2.singleValueEntry));
        }
        RandomAccessInput slice2 = this.data.randomAccessSlice(entry2.ordsOffset, entry2.ordsLength);
        final LongValues ords = DirectReader.getInstance(slice2, entry2.bitsPerValue);
        RandomAccessInput addressesInput = this.data.randomAccessSlice(entry2.addressesOffset, entry2.addressesLength);
        final LongValues addresses = DirectMonotonicReader.getInstance(entry2.addressesMeta, addressesInput);
        if (entry2.docsWithFieldOffset == -1L) {
            return new BaseSortedSetDocValues(entry2, this.data){
                int doc;
                long start;
                long end;
                {
                    super(entry2, data);
                    this.doc = -1;
                }

                @Override
                public int nextDoc() throws IOException {
                    return this.advance(this.doc + 1);
                }

                @Override
                public int docID() {
                    return this.doc;
                }

                @Override
                public long cost() {
                    return Lucene70DocValuesProducer.this.maxDoc;
                }

                @Override
                public int advance(int target) throws IOException {
                    if (target >= Lucene70DocValuesProducer.this.maxDoc) {
                        this.doc = Integer.MAX_VALUE;
                        return Integer.MAX_VALUE;
                    }
                    this.start = addresses.get(target);
                    this.end = addresses.get((long)target + 1L);
                    this.doc = target;
                    return this.doc;
                }

                @Override
                public boolean advanceExact(int target) throws IOException {
                    this.start = addresses.get(target);
                    this.end = addresses.get((long)target + 1L);
                    this.doc = target;
                    return true;
                }

                @Override
                public long nextOrd() throws IOException {
                    if (this.start == this.end) {
                        return -1L;
                    }
                    return ords.get(this.start++);
                }
            };
        }
        final IndexedDISI disi = new IndexedDISI(this.data, entry2.docsWithFieldOffset, entry2.docsWithFieldLength, entry2.numDocsWithField);
        return new BaseSortedSetDocValues(entry2, this.data){
            boolean set;
            long start;
            long end;
            {
                super(entry2, data);
                this.end = 0L;
            }

            @Override
            public int nextDoc() throws IOException {
                this.set = false;
                return disi.nextDoc();
            }

            @Override
            public int docID() {
                return disi.docID();
            }

            @Override
            public long cost() {
                return disi.cost();
            }

            @Override
            public int advance(int target) throws IOException {
                this.set = false;
                return disi.advance(target);
            }

            @Override
            public boolean advanceExact(int target) throws IOException {
                this.set = false;
                return disi.advanceExact(target);
            }

            @Override
            public long nextOrd() throws IOException {
                if (!this.set) {
                    int index2 = disi.index();
                    long start = addresses.get(index2);
                    this.start = start + 1L;
                    this.end = addresses.get((long)index2 + 1L);
                    this.set = true;
                    return ords.get(start);
                }
                if (this.start == this.end) {
                    return -1L;
                }
                return ords.get(this.start++);
            }
        };
    }

    @Override
    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile(this.data);
    }

    private static class TermsDict
    extends TermsEnum {
        final TermsDictEntry entry;
        final LongValues blockAddresses;
        final IndexInput bytes;
        final long blockMask;
        final LongValues indexAddresses;
        final IndexInput indexBytes;
        final BytesRef term;
        long ord = -1L;

        TermsDict(TermsDictEntry entry2, IndexInput data) throws IOException {
            this.entry = entry2;
            RandomAccessInput addressesSlice = data.randomAccessSlice(entry2.termsAddressesOffset, entry2.termsAddressesLength);
            this.blockAddresses = DirectMonotonicReader.getInstance(entry2.termsAddressesMeta, addressesSlice);
            this.bytes = data.slice("terms", entry2.termsDataOffset, entry2.termsDataLength);
            this.blockMask = (1L << entry2.termsDictBlockShift) - 1L;
            RandomAccessInput indexAddressesSlice = data.randomAccessSlice(entry2.termsIndexAddressesOffset, entry2.termsIndexAddressesLength);
            this.indexAddresses = DirectMonotonicReader.getInstance(entry2.termsIndexAddressesMeta, indexAddressesSlice);
            this.indexBytes = data.slice("terms-index", entry2.termsIndexOffset, entry2.termsIndexLength);
            this.term = new BytesRef(entry2.maxTermLength);
        }

        @Override
        public BytesRef next() throws IOException {
            if (++this.ord >= this.entry.termsDictSize) {
                return null;
            }
            if ((this.ord & this.blockMask) == 0L) {
                this.term.length = this.bytes.readVInt();
                this.bytes.readBytes(this.term.bytes, 0, this.term.length);
            } else {
                int token2 = Byte.toUnsignedInt(this.bytes.readByte());
                int prefixLength = token2 & 0xF;
                int suffixLength = 1 + (token2 >>> 4);
                if (prefixLength == 15) {
                    prefixLength += this.bytes.readVInt();
                }
                if (suffixLength == 16) {
                    suffixLength += this.bytes.readVInt();
                }
                this.term.length = prefixLength + suffixLength;
                this.bytes.readBytes(this.term.bytes, prefixLength, suffixLength);
            }
            return this.term;
        }

        @Override
        public void seekExact(long ord) throws IOException {
            if (ord < 0L || ord >= this.entry.termsDictSize) {
                throw new IndexOutOfBoundsException();
            }
            long blockIndex = ord >>> this.entry.termsDictBlockShift;
            long blockAddress = this.blockAddresses.get(blockIndex);
            this.bytes.seek(blockAddress);
            this.ord = (blockIndex << this.entry.termsDictBlockShift) - 1L;
            do {
                this.next();
            } while (this.ord < ord);
        }

        private BytesRef getTermFromIndex(long index2) throws IOException {
            assert (index2 >= 0L && index2 <= this.entry.termsDictSize - 1L >>> this.entry.termsDictIndexShift);
            long start = this.indexAddresses.get(index2);
            this.term.length = (int)(this.indexAddresses.get(index2 + 1L) - start);
            this.indexBytes.seek(start);
            this.indexBytes.readBytes(this.term.bytes, 0, this.term.length);
            return this.term;
        }

        private long seekTermsIndex(BytesRef text2) throws IOException {
            long lo2 = 0L;
            long hi2 = this.entry.termsDictSize - 1L >>> this.entry.termsDictIndexShift;
            while (lo2 <= hi2) {
                long mid = lo2 + hi2 >>> 1;
                this.getTermFromIndex(mid);
                int cmp = this.term.compareTo(text2);
                if (cmp <= 0) {
                    lo2 = mid + 1L;
                    continue;
                }
                hi2 = mid - 1L;
            }
            assert (hi2 < 0L || this.getTermFromIndex(hi2).compareTo(text2) <= 0);
            assert (hi2 == this.entry.termsDictSize - 1L >>> this.entry.termsDictIndexShift || this.getTermFromIndex(hi2 + 1L).compareTo(text2) > 0);
            return hi2;
        }

        private BytesRef getFirstTermFromBlock(long block) throws IOException {
            assert (block >= 0L && block <= this.entry.termsDictSize - 1L >>> this.entry.termsDictBlockShift);
            long blockAddress = this.blockAddresses.get(block);
            this.bytes.seek(blockAddress);
            this.term.length = this.bytes.readVInt();
            this.bytes.readBytes(this.term.bytes, 0, this.term.length);
            return this.term;
        }

        private long seekBlock(BytesRef text2) throws IOException {
            long index2 = this.seekTermsIndex(text2);
            if (index2 == -1L) {
                return -1L;
            }
            long ordLo = index2 << this.entry.termsDictIndexShift;
            long ordHi = Math.min(this.entry.termsDictSize, ordLo + (1L << this.entry.termsDictIndexShift)) - 1L;
            long blockLo = ordLo >>> this.entry.termsDictBlockShift;
            long blockHi = ordHi >>> this.entry.termsDictBlockShift;
            while (blockLo <= blockHi) {
                long blockMid = blockLo + blockHi >>> 1;
                this.getFirstTermFromBlock(blockMid);
                int cmp = this.term.compareTo(text2);
                if (cmp <= 0) {
                    blockLo = blockMid + 1L;
                    continue;
                }
                blockHi = blockMid - 1L;
            }
            assert (blockHi < 0L || this.getFirstTermFromBlock(blockHi).compareTo(text2) <= 0);
            assert (blockHi == this.entry.termsDictSize - 1L >>> this.entry.termsDictBlockShift || this.getFirstTermFromBlock(blockHi + 1L).compareTo(text2) > 0);
            return blockHi;
        }

        @Override
        public TermsEnum.SeekStatus seekCeil(BytesRef text2) throws IOException {
            long block = this.seekBlock(text2);
            if (block == -1L) {
                this.seekExact(0L);
                return TermsEnum.SeekStatus.NOT_FOUND;
            }
            long blockAddress = this.blockAddresses.get(block);
            this.ord = block << this.entry.termsDictBlockShift;
            this.bytes.seek(blockAddress);
            this.term.length = this.bytes.readVInt();
            this.bytes.readBytes(this.term.bytes, 0, this.term.length);
            do {
                int cmp;
                if ((cmp = this.term.compareTo(text2)) == 0) {
                    return TermsEnum.SeekStatus.FOUND;
                }
                if (cmp <= 0) continue;
                return TermsEnum.SeekStatus.NOT_FOUND;
            } while (this.next() != null);
            return TermsEnum.SeekStatus.END;
        }

        @Override
        public BytesRef term() throws IOException {
            return this.term;
        }

        @Override
        public long ord() throws IOException {
            return this.ord;
        }

        @Override
        public long totalTermFreq() throws IOException {
            return -1L;
        }

        @Override
        public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int docFreq() throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private static abstract class BaseSortedSetDocValues
    extends SortedSetDocValues {
        final SortedSetEntry entry;
        final IndexInput data;
        final TermsEnum termsEnum;

        BaseSortedSetDocValues(SortedSetEntry entry2, IndexInput data) throws IOException {
            this.entry = entry2;
            this.data = data;
            this.termsEnum = this.termsEnum();
        }

        @Override
        public long getValueCount() {
            return this.entry.termsDictSize;
        }

        @Override
        public BytesRef lookupOrd(long ord) throws IOException {
            this.termsEnum.seekExact(ord);
            return this.termsEnum.term();
        }

        @Override
        public long lookupTerm(BytesRef key) throws IOException {
            TermsEnum.SeekStatus status = this.termsEnum.seekCeil(key);
            switch (status) {
                case FOUND: {
                    return this.termsEnum.ord();
                }
            }
            return -1L - this.termsEnum.ord();
        }

        @Override
        public TermsEnum termsEnum() throws IOException {
            return new TermsDict(this.entry, this.data);
        }
    }

    private static abstract class BaseSortedDocValues
    extends SortedDocValues {
        final SortedEntry entry;
        final IndexInput data;
        final TermsEnum termsEnum;

        BaseSortedDocValues(SortedEntry entry2, IndexInput data) throws IOException {
            this.entry = entry2;
            this.data = data;
            this.termsEnum = this.termsEnum();
        }

        @Override
        public int getValueCount() {
            return Math.toIntExact(this.entry.termsDictSize);
        }

        @Override
        public BytesRef lookupOrd(int ord) throws IOException {
            this.termsEnum.seekExact(ord);
            return this.termsEnum.term();
        }

        @Override
        public int lookupTerm(BytesRef key) throws IOException {
            TermsEnum.SeekStatus status = this.termsEnum.seekCeil(key);
            switch (status) {
                case FOUND: {
                    return Math.toIntExact(this.termsEnum.ord());
                }
            }
            return Math.toIntExact(-1L - this.termsEnum.ord());
        }

        @Override
        public TermsEnum termsEnum() throws IOException {
            return new TermsDict(this.entry, this.data);
        }
    }

    private static abstract class SparseBinaryDocValues
    extends BinaryDocValues {
        final IndexedDISI disi;

        SparseBinaryDocValues(IndexedDISI disi) {
            this.disi = disi;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.disi.nextDoc();
        }

        @Override
        public int docID() {
            return this.disi.docID();
        }

        @Override
        public long cost() {
            return this.disi.cost();
        }

        @Override
        public int advance(int target) throws IOException {
            return this.disi.advance(target);
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            return this.disi.advanceExact(target);
        }
    }

    private static abstract class DenseBinaryDocValues
    extends BinaryDocValues {
        final int maxDoc;
        int doc = -1;

        DenseBinaryDocValues(int maxDoc) {
            this.maxDoc = maxDoc;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.advance(this.doc + 1);
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public long cost() {
            return this.maxDoc;
        }

        @Override
        public int advance(int target) throws IOException {
            if (target >= this.maxDoc) {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.doc = target;
            return this.doc;
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            this.doc = target;
            return true;
        }
    }

    private static abstract class SparseNumericDocValues
    extends NumericDocValues {
        final IndexedDISI disi;

        SparseNumericDocValues(IndexedDISI disi) {
            this.disi = disi;
        }

        @Override
        public int advance(int target) throws IOException {
            return this.disi.advance(target);
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            return this.disi.advanceExact(target);
        }

        @Override
        public int nextDoc() throws IOException {
            return this.disi.nextDoc();
        }

        @Override
        public int docID() {
            return this.disi.docID();
        }

        @Override
        public long cost() {
            return this.disi.cost();
        }
    }

    private static abstract class DenseNumericDocValues
    extends NumericDocValues {
        final int maxDoc;
        int doc = -1;

        DenseNumericDocValues(int maxDoc) {
            this.maxDoc = maxDoc;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.advance(this.doc + 1);
        }

        @Override
        public int advance(int target) throws IOException {
            if (target >= this.maxDoc) {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.doc = target;
            return this.doc;
        }

        @Override
        public boolean advanceExact(int target) {
            this.doc = target;
            return true;
        }

        @Override
        public long cost() {
            return this.maxDoc;
        }
    }

    private static class SortedNumericEntry
    extends NumericEntry {
        int numDocsWithField;
        DirectMonotonicReader.Meta addressesMeta;
        long addressesOffset;
        long addressesLength;

        private SortedNumericEntry() {
        }
    }

    private static class SortedSetEntry
    extends TermsDictEntry {
        SortedEntry singleValueEntry;
        long docsWithFieldOffset;
        long docsWithFieldLength;
        int numDocsWithField;
        byte bitsPerValue;
        long ordsOffset;
        long ordsLength;
        DirectMonotonicReader.Meta addressesMeta;
        long addressesOffset;
        long addressesLength;

        private SortedSetEntry() {
        }
    }

    private static class SortedEntry
    extends TermsDictEntry {
        long docsWithFieldOffset;
        long docsWithFieldLength;
        int numDocsWithField;
        byte bitsPerValue;
        long ordsOffset;
        long ordsLength;

        private SortedEntry() {
        }
    }

    private static class TermsDictEntry {
        long termsDictSize;
        int termsDictBlockShift;
        DirectMonotonicReader.Meta termsAddressesMeta;
        int maxTermLength;
        long termsDataOffset;
        long termsDataLength;
        long termsAddressesOffset;
        long termsAddressesLength;
        int termsDictIndexShift;
        DirectMonotonicReader.Meta termsIndexAddressesMeta;
        long termsIndexOffset;
        long termsIndexLength;
        long termsIndexAddressesOffset;
        long termsIndexAddressesLength;

        private TermsDictEntry() {
        }
    }

    private static class BinaryEntry {
        long dataOffset;
        long dataLength;
        long docsWithFieldOffset;
        long docsWithFieldLength;
        int numDocsWithField;
        int minLength;
        int maxLength;
        long addressesOffset;
        long addressesLength;
        DirectMonotonicReader.Meta addressesMeta;

        private BinaryEntry() {
        }
    }

    private static class NumericEntry {
        long[] table;
        int blockShift;
        byte bitsPerValue;
        long docsWithFieldOffset;
        long docsWithFieldLength;
        long numValues;
        long minValue;
        long gcd;
        long valuesOffset;
        long valuesLength;

        private NumericEntry() {
        }
    }
}

