/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene50;

import java.io.IOException;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.PushPostingsWriterBase;
import org.apache.lucene.codecs.lucene50.ForUtil;
import org.apache.lucene.codecs.lucene50.Lucene50PostingsFormat;
import org.apache.lucene.codecs.lucene50.Lucene50SkipWriter;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;

public final class Lucene50PostingsWriter
extends PushPostingsWriterBase {
    IndexOutput docOut;
    IndexOutput posOut;
    IndexOutput payOut;
    static final Lucene50PostingsFormat.IntBlockTermState emptyState = new Lucene50PostingsFormat.IntBlockTermState();
    Lucene50PostingsFormat.IntBlockTermState lastState;
    private long docStartFP;
    private long posStartFP;
    private long payStartFP;
    final int[] docDeltaBuffer;
    final int[] freqBuffer;
    private int docBufferUpto;
    final int[] posDeltaBuffer;
    final int[] payloadLengthBuffer;
    final int[] offsetStartDeltaBuffer;
    final int[] offsetLengthBuffer;
    private int posBufferUpto;
    private byte[] payloadBytes;
    private int payloadByteUpto;
    private int lastBlockDocID;
    private long lastBlockPosFP;
    private long lastBlockPayFP;
    private int lastBlockPosBufferUpto;
    private int lastBlockPayloadByteUpto;
    private int lastDocID;
    private int lastPosition;
    private int lastStartOffset;
    private int docCount;
    final byte[] encoded;
    private final ForUtil forUtil;
    private final Lucene50SkipWriter skipWriter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Lucene50PostingsWriter(SegmentWriteState state) throws IOException {
        IndexOutput payOut;
        IndexOutput posOut;
        block10: {
            float acceptableOverheadRatio = 0.0f;
            String docFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "doc");
            this.docOut = state.directory.createOutput(docFileName, state.context);
            posOut = null;
            payOut = null;
            boolean success2 = false;
            try {
                CodecUtil.writeIndexHeader(this.docOut, "Lucene50PostingsWriterDoc", 0, state.segmentInfo.getId(), state.segmentSuffix);
                this.forUtil = new ForUtil(0.0f, this.docOut);
                if (state.fieldInfos.hasProx()) {
                    this.posDeltaBuffer = new int[ForUtil.MAX_DATA_SIZE];
                    String posFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "pos");
                    posOut = state.directory.createOutput(posFileName, state.context);
                    CodecUtil.writeIndexHeader(posOut, "Lucene50PostingsWriterPos", 0, state.segmentInfo.getId(), state.segmentSuffix);
                    if (state.fieldInfos.hasPayloads()) {
                        this.payloadBytes = new byte[128];
                        this.payloadLengthBuffer = new int[ForUtil.MAX_DATA_SIZE];
                    } else {
                        this.payloadBytes = null;
                        this.payloadLengthBuffer = null;
                    }
                    if (state.fieldInfos.hasOffsets()) {
                        this.offsetStartDeltaBuffer = new int[ForUtil.MAX_DATA_SIZE];
                        this.offsetLengthBuffer = new int[ForUtil.MAX_DATA_SIZE];
                    } else {
                        this.offsetStartDeltaBuffer = null;
                        this.offsetLengthBuffer = null;
                    }
                    if (state.fieldInfos.hasPayloads() || state.fieldInfos.hasOffsets()) {
                        String payFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "pay");
                        payOut = state.directory.createOutput(payFileName, state.context);
                        CodecUtil.writeIndexHeader(payOut, "Lucene50PostingsWriterPay", 0, state.segmentInfo.getId(), state.segmentSuffix);
                    }
                } else {
                    this.posDeltaBuffer = null;
                    this.payloadLengthBuffer = null;
                    this.offsetStartDeltaBuffer = null;
                    this.offsetLengthBuffer = null;
                    this.payloadBytes = null;
                }
                this.payOut = payOut;
                this.posOut = posOut;
                success2 = true;
                if (success2) break block10;
            }
            catch (Throwable throwable2) {
                if (!success2) {
                    IOUtils.closeWhileHandlingException(this.docOut, posOut, payOut);
                }
                throw throwable2;
            }
            IOUtils.closeWhileHandlingException(this.docOut, posOut, payOut);
        }
        this.docDeltaBuffer = new int[ForUtil.MAX_DATA_SIZE];
        this.freqBuffer = new int[ForUtil.MAX_DATA_SIZE];
        this.skipWriter = new Lucene50SkipWriter(10, 128, state.segmentInfo.maxDoc(), this.docOut, posOut, payOut);
        this.encoded = new byte[512];
    }

    @Override
    public Lucene50PostingsFormat.IntBlockTermState newTermState() {
        return new Lucene50PostingsFormat.IntBlockTermState();
    }

    @Override
    public void init(IndexOutput termsOut, SegmentWriteState state) throws IOException {
        CodecUtil.writeIndexHeader(termsOut, "Lucene50PostingsWriterTerms", 0, state.segmentInfo.getId(), state.segmentSuffix);
        termsOut.writeVInt(128);
    }

    @Override
    public int setField(FieldInfo fieldInfo) {
        super.setField(fieldInfo);
        this.skipWriter.setField(this.writePositions, this.writeOffsets, this.writePayloads);
        this.lastState = emptyState;
        if (this.writePositions) {
            if (this.writePayloads || this.writeOffsets) {
                return 3;
            }
            return 2;
        }
        return 1;
    }

    @Override
    public void startTerm() {
        this.docStartFP = this.docOut.getFilePointer();
        if (this.writePositions) {
            this.posStartFP = this.posOut.getFilePointer();
            if (this.writePayloads || this.writeOffsets) {
                this.payStartFP = this.payOut.getFilePointer();
            }
        }
        this.lastDocID = 0;
        this.lastBlockDocID = -1;
        this.skipWriter.resetSkip();
    }

    @Override
    public void startDoc(int docID, int termDocFreq) throws IOException {
        if (this.lastBlockDocID != -1 && this.docBufferUpto == 0) {
            this.skipWriter.bufferSkip(this.lastBlockDocID, this.docCount, this.lastBlockPosFP, this.lastBlockPayFP, this.lastBlockPosBufferUpto, this.lastBlockPayloadByteUpto);
        }
        int docDelta = docID - this.lastDocID;
        if (docID < 0 || this.docCount > 0 && docDelta <= 0) {
            throw new CorruptIndexException("docs out of order (" + docID + " <= " + this.lastDocID + " )", this.docOut);
        }
        this.docDeltaBuffer[this.docBufferUpto] = docDelta;
        if (this.writeFreqs) {
            this.freqBuffer[this.docBufferUpto] = termDocFreq;
        }
        ++this.docBufferUpto;
        ++this.docCount;
        if (this.docBufferUpto == 128) {
            this.forUtil.writeBlock(this.docDeltaBuffer, this.encoded, this.docOut);
            if (this.writeFreqs) {
                this.forUtil.writeBlock(this.freqBuffer, this.encoded, this.docOut);
            }
        }
        this.lastDocID = docID;
        this.lastPosition = 0;
        this.lastStartOffset = 0;
    }

    @Override
    public void addPosition(int position2, BytesRef payload, int startOffset, int endOffset) throws IOException {
        if (position2 > 0x7FFFFF7F) {
            throw new CorruptIndexException("position=" + position2 + " is too large (> IndexWriter.MAX_POSITION=" + 0x7FFFFF7F + ")", this.docOut);
        }
        if (position2 < 0) {
            throw new CorruptIndexException("position=" + position2 + " is < 0", this.docOut);
        }
        this.posDeltaBuffer[this.posBufferUpto] = position2 - this.lastPosition;
        if (this.writePayloads) {
            if (payload == null || payload.length == 0) {
                this.payloadLengthBuffer[this.posBufferUpto] = 0;
            } else {
                this.payloadLengthBuffer[this.posBufferUpto] = payload.length;
                if (this.payloadByteUpto + payload.length > this.payloadBytes.length) {
                    this.payloadBytes = ArrayUtil.grow(this.payloadBytes, this.payloadByteUpto + payload.length);
                }
                System.arraycopy(payload.bytes, payload.offset, this.payloadBytes, this.payloadByteUpto, payload.length);
                this.payloadByteUpto += payload.length;
            }
        }
        if (this.writeOffsets) {
            assert (startOffset >= this.lastStartOffset);
            assert (endOffset >= startOffset);
            this.offsetStartDeltaBuffer[this.posBufferUpto] = startOffset - this.lastStartOffset;
            this.offsetLengthBuffer[this.posBufferUpto] = endOffset - startOffset;
            this.lastStartOffset = startOffset;
        }
        ++this.posBufferUpto;
        this.lastPosition = position2;
        if (this.posBufferUpto == 128) {
            this.forUtil.writeBlock(this.posDeltaBuffer, this.encoded, this.posOut);
            if (this.writePayloads) {
                this.forUtil.writeBlock(this.payloadLengthBuffer, this.encoded, this.payOut);
                this.payOut.writeVInt(this.payloadByteUpto);
                this.payOut.writeBytes(this.payloadBytes, 0, this.payloadByteUpto);
                this.payloadByteUpto = 0;
            }
            if (this.writeOffsets) {
                this.forUtil.writeBlock(this.offsetStartDeltaBuffer, this.encoded, this.payOut);
                this.forUtil.writeBlock(this.offsetLengthBuffer, this.encoded, this.payOut);
            }
            this.posBufferUpto = 0;
        }
    }

    @Override
    public void finishDoc() throws IOException {
        if (this.docBufferUpto == 128) {
            this.lastBlockDocID = this.lastDocID;
            if (this.posOut != null) {
                if (this.payOut != null) {
                    this.lastBlockPayFP = this.payOut.getFilePointer();
                }
                this.lastBlockPosFP = this.posOut.getFilePointer();
                this.lastBlockPosBufferUpto = this.posBufferUpto;
                this.lastBlockPayloadByteUpto = this.payloadByteUpto;
            }
            this.docBufferUpto = 0;
        }
    }

    @Override
    public void finishTerm(BlockTermState _state) throws IOException {
        long lastPosBlockOffset;
        int singletonDocID;
        Lucene50PostingsFormat.IntBlockTermState state = (Lucene50PostingsFormat.IntBlockTermState)_state;
        assert (state.docFreq > 0);
        assert (state.docFreq == this.docCount) : state.docFreq + " vs " + this.docCount;
        if (state.docFreq == 1) {
            singletonDocID = this.docDeltaBuffer[0];
        } else {
            singletonDocID = -1;
            for (int i = 0; i < this.docBufferUpto; ++i) {
                int docDelta = this.docDeltaBuffer[i];
                int freq2 = this.freqBuffer[i];
                if (!this.writeFreqs) {
                    this.docOut.writeVInt(docDelta);
                    continue;
                }
                if (this.freqBuffer[i] == 1) {
                    this.docOut.writeVInt(docDelta << 1 | 1);
                    continue;
                }
                this.docOut.writeVInt(docDelta << 1);
                this.docOut.writeVInt(freq2);
            }
        }
        if (this.writePositions) {
            assert (state.totalTermFreq != -1L);
            lastPosBlockOffset = state.totalTermFreq > 128L ? this.posOut.getFilePointer() - this.posStartFP : -1L;
            if (this.posBufferUpto > 0) {
                int lastPayloadLength = -1;
                int lastOffsetLength = -1;
                int payloadBytesReadUpto = 0;
                for (int i = 0; i < this.posBufferUpto; ++i) {
                    int posDelta = this.posDeltaBuffer[i];
                    if (this.writePayloads) {
                        int payloadLength = this.payloadLengthBuffer[i];
                        if (payloadLength != lastPayloadLength) {
                            lastPayloadLength = payloadLength;
                            this.posOut.writeVInt(posDelta << 1 | 1);
                            this.posOut.writeVInt(payloadLength);
                        } else {
                            this.posOut.writeVInt(posDelta << 1);
                        }
                        if (payloadLength != 0) {
                            this.posOut.writeBytes(this.payloadBytes, payloadBytesReadUpto, payloadLength);
                            payloadBytesReadUpto += payloadLength;
                        }
                    } else {
                        this.posOut.writeVInt(posDelta);
                    }
                    if (!this.writeOffsets) continue;
                    int delta = this.offsetStartDeltaBuffer[i];
                    int length = this.offsetLengthBuffer[i];
                    if (length == lastOffsetLength) {
                        this.posOut.writeVInt(delta << 1);
                        continue;
                    }
                    this.posOut.writeVInt(delta << 1 | 1);
                    this.posOut.writeVInt(length);
                    lastOffsetLength = length;
                }
                if (this.writePayloads) {
                    assert (payloadBytesReadUpto == this.payloadByteUpto);
                    this.payloadByteUpto = 0;
                }
            }
        } else {
            lastPosBlockOffset = -1L;
        }
        long skipOffset = this.docCount > 128 ? this.skipWriter.writeSkip(this.docOut) - this.docStartFP : -1L;
        state.docStartFP = this.docStartFP;
        state.posStartFP = this.posStartFP;
        state.payStartFP = this.payStartFP;
        state.singletonDocID = singletonDocID;
        state.skipOffset = skipOffset;
        state.lastPosBlockOffset = lastPosBlockOffset;
        this.docBufferUpto = 0;
        this.posBufferUpto = 0;
        this.lastDocID = 0;
        this.docCount = 0;
    }

    @Override
    public void encodeTerm(long[] longs, DataOutput out, FieldInfo fieldInfo, BlockTermState _state, boolean absolute) throws IOException {
        Lucene50PostingsFormat.IntBlockTermState state = (Lucene50PostingsFormat.IntBlockTermState)_state;
        if (absolute) {
            this.lastState = emptyState;
        }
        longs[0] = state.docStartFP - this.lastState.docStartFP;
        if (this.writePositions) {
            longs[1] = state.posStartFP - this.lastState.posStartFP;
            if (this.writePayloads || this.writeOffsets) {
                longs[2] = state.payStartFP - this.lastState.payStartFP;
            }
        }
        if (state.singletonDocID != -1) {
            out.writeVInt(state.singletonDocID);
        }
        if (this.writePositions && state.lastPosBlockOffset != -1L) {
            out.writeVLong(state.lastPosBlockOffset);
        }
        if (state.skipOffset != -1L) {
            out.writeVLong(state.skipOffset);
        }
        this.lastState = state;
    }

    @Override
    public void close() throws IOException {
        block8: {
            block7: {
                boolean success2 = false;
                try {
                    if (this.docOut != null) {
                        CodecUtil.writeFooter(this.docOut);
                    }
                    if (this.posOut != null) {
                        CodecUtil.writeFooter(this.posOut);
                    }
                    if (this.payOut != null) {
                        CodecUtil.writeFooter(this.payOut);
                    }
                    if (!(success2 = true)) break block7;
                }
                catch (Throwable throwable2) {
                    if (success2) {
                        IOUtils.close(this.docOut, this.posOut, this.payOut);
                    } else {
                        IOUtils.closeWhileHandlingException(this.docOut, this.posOut, this.payOut);
                    }
                    this.payOut = null;
                    this.posOut = null;
                    this.docOut = null;
                    throw throwable2;
                }
                IOUtils.close(this.docOut, this.posOut, this.payOut);
                break block8;
            }
            IOUtils.closeWhileHandlingException(this.docOut, this.posOut, this.payOut);
        }
        this.payOut = null;
        this.posOut = null;
        this.docOut = null;
    }
}

