/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene50;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.LiveDocsFormat;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;

public final class Lucene50LiveDocsFormat
extends LiveDocsFormat {
    private static final String EXTENSION = "liv";
    private static final String CODEC_NAME = "Lucene50LiveDocs";
    private static final int VERSION_START = 0;
    private static final int VERSION_CURRENT = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bits readLiveDocs(Directory dir, SegmentCommitInfo info2, IOContext context) throws IOException {
        block21: {
            long gen = info2.getDelGen();
            String name = IndexFileNames.fileNameFromGeneration(info2.info.name, EXTENSION, gen);
            int length = info2.info.maxDoc();
            Throwable throwable2 = null;
            try (ChecksumIndexInput input2 = dir.openChecksumInput(name, context);){
                Bits bits2;
                Throwable priorE = null;
                try {
                    CodecUtil.checkIndexHeader(input2, CODEC_NAME, 0, 0, info2.info.getId(), Long.toString(gen, 36));
                    long[] data = new long[FixedBitSet.bits2words(length)];
                    for (int i = 0; i < data.length; ++i) {
                        data[i] = input2.readLong();
                    }
                    FixedBitSet fbs = new FixedBitSet(data, length);
                    if (fbs.length() - fbs.cardinality() != info2.getDelCount()) {
                        throw new CorruptIndexException("bits.deleted=" + (fbs.length() - fbs.cardinality()) + " info.delcount=" + info2.getDelCount(), input2);
                    }
                    bits2 = fbs.asReadOnlyBits();
                }
                catch (Throwable exception) {
                    try {
                        try {
                            priorE = exception;
                        }
                        catch (Throwable throwable3) {
                            CodecUtil.checkFooter(input2, priorE);
                            throw throwable3;
                        }
                        CodecUtil.checkFooter(input2, priorE);
                        break block21;
                    }
                    catch (Throwable throwable4) {
                        throwable2 = throwable4;
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        throw throwable5;
                    }
                }
                CodecUtil.checkFooter(input2, priorE);
                return bits2;
            }
        }
        throw new AssertionError();
    }

    @Override
    public void writeLiveDocs(Bits bits2, Directory dir, SegmentCommitInfo info2, int newDelCount, IOContext context) throws IOException {
        long gen = info2.getNextDelGen();
        String name = IndexFileNames.fileNameFromGeneration(info2.info.name, EXTENSION, gen);
        int delCount = 0;
        try (IndexOutput output = dir.createOutput(name, context);){
            CodecUtil.writeIndexHeader(output, CODEC_NAME, 0, info2.info.getId(), Long.toString(gen, 36));
            int longCount = FixedBitSet.bits2words(bits2.length());
            for (int i = 0; i < longCount; ++i) {
                int j;
                long currentBits = 0L;
                int end = Math.min(j + 63, bits2.length() - 1);
                for (j = i << 6; j <= end; ++j) {
                    if (bits2.get(j)) {
                        currentBits |= 1L << j;
                        continue;
                    }
                    ++delCount;
                }
                output.writeLong(currentBits);
            }
            CodecUtil.writeFooter(output);
        }
        if (delCount != info2.getDelCount() + newDelCount) {
            throw new CorruptIndexException("bits.deleted=" + delCount + " info.delcount=" + info2.getDelCount() + " newdelcount=" + newDelCount, name);
        }
    }

    @Override
    public void files(SegmentCommitInfo info2, Collection<String> files2) throws IOException {
        if (info2.hasDeletions()) {
            files2.add(IndexFileNames.fileNameFromGeneration(info2.info.name, EXTENSION, info2.getDelGen()));
        }
    }
}

