/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene50;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldInfosFormat;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;

public final class Lucene50FieldInfosFormat
extends FieldInfosFormat {
    static final String EXTENSION = "fnm";
    static final String CODEC_NAME = "Lucene50FieldInfos";
    static final int FORMAT_SAFE_MAPS = 1;
    static final int FORMAT_START = 1;
    static final int FORMAT_CURRENT = 1;
    static final byte STORE_TERMVECTOR = 1;
    static final byte OMIT_NORMS = 2;
    static final byte STORE_PAYLOADS = 4;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldInfos read(Directory directory, SegmentInfo segmentInfo, String segmentSuffix, IOContext context) throws IOException {
        String fileName = IndexFileNames.segmentFileName(segmentInfo.name, segmentSuffix, EXTENSION);
        try (ChecksumIndexInput input2 = directory.openChecksumInput(fileName, context);){
            Throwable priorE = null;
            FieldInfo[] infos = null;
            try {
                CodecUtil.checkIndexHeader(input2, CODEC_NAME, 1, 1, segmentInfo.getId(), segmentSuffix);
                int size2 = input2.readVInt();
                infos = new FieldInfo[size2];
                Map<Object, Object> lastAttributes = Collections.emptyMap();
                for (int i = 0; i < size2; ++i) {
                    String name = input2.readString();
                    int fieldNumber = input2.readVInt();
                    if (fieldNumber < 0) {
                        throw new CorruptIndexException("invalid field number for field: " + name + ", fieldNumber=" + fieldNumber, input2);
                    }
                    byte bits2 = input2.readByte();
                    boolean storeTermVector = (bits2 & 1) != 0;
                    boolean omitNorms = (bits2 & 2) != 0;
                    boolean storePayloads = (bits2 & 4) != 0;
                    IndexOptions indexOptions = Lucene50FieldInfosFormat.getIndexOptions(input2, input2.readByte());
                    DocValuesType docValuesType = Lucene50FieldInfosFormat.getDocValuesType(input2, input2.readByte());
                    long dvGen = input2.readLong();
                    Map<String, String> attributes = input2.readMapOfStrings();
                    if (attributes.equals(lastAttributes)) {
                        attributes = lastAttributes;
                    }
                    lastAttributes = attributes;
                    try {
                        infos[i] = new FieldInfo(name, fieldNumber, storeTermVector, omitNorms, storePayloads, indexOptions, docValuesType, dvGen, attributes, 0, 0, false);
                        infos[i].checkConsistency();
                        continue;
                    }
                    catch (IllegalStateException e) {
                        throw new CorruptIndexException("invalid fieldinfo for field: " + name + ", fieldNumber=" + fieldNumber, input2, (Throwable)e);
                    }
                }
            }
            catch (Throwable exception) {
                priorE = exception;
            }
            finally {
                CodecUtil.checkFooter(input2, priorE);
            }
            FieldInfos fieldInfos = new FieldInfos(infos);
            return fieldInfos;
        }
    }

    private static byte docValuesByte(DocValuesType type) {
        switch (type) {
            case NONE: {
                return 0;
            }
            case NUMERIC: {
                return 1;
            }
            case BINARY: {
                return 2;
            }
            case SORTED: {
                return 3;
            }
            case SORTED_SET: {
                return 4;
            }
            case SORTED_NUMERIC: {
                return 5;
            }
        }
        throw new AssertionError((Object)("unhandled DocValuesType: " + (Object)((Object)type)));
    }

    private static DocValuesType getDocValuesType(IndexInput input2, byte b) throws IOException {
        switch (b) {
            case 0: {
                return DocValuesType.NONE;
            }
            case 1: {
                return DocValuesType.NUMERIC;
            }
            case 2: {
                return DocValuesType.BINARY;
            }
            case 3: {
                return DocValuesType.SORTED;
            }
            case 4: {
                return DocValuesType.SORTED_SET;
            }
            case 5: {
                return DocValuesType.SORTED_NUMERIC;
            }
        }
        throw new CorruptIndexException("invalid docvalues byte: " + b, input2);
    }

    private static byte indexOptionsByte(IndexOptions indexOptions) {
        switch (indexOptions) {
            case NONE: {
                return 0;
            }
            case DOCS: {
                return 1;
            }
            case DOCS_AND_FREQS: {
                return 2;
            }
            case DOCS_AND_FREQS_AND_POSITIONS: {
                return 3;
            }
            case DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS: {
                return 4;
            }
        }
        throw new AssertionError((Object)("unhandled IndexOptions: " + (Object)((Object)indexOptions)));
    }

    private static IndexOptions getIndexOptions(IndexInput input2, byte b) throws IOException {
        switch (b) {
            case 0: {
                return IndexOptions.NONE;
            }
            case 1: {
                return IndexOptions.DOCS;
            }
            case 2: {
                return IndexOptions.DOCS_AND_FREQS;
            }
            case 3: {
                return IndexOptions.DOCS_AND_FREQS_AND_POSITIONS;
            }
            case 4: {
                return IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS;
            }
        }
        throw new CorruptIndexException("invalid IndexOptions byte: " + b, input2);
    }

    @Override
    public void write(Directory directory, SegmentInfo segmentInfo, String segmentSuffix, FieldInfos infos, IOContext context) throws IOException {
        String fileName = IndexFileNames.segmentFileName(segmentInfo.name, segmentSuffix, EXTENSION);
        try (IndexOutput output = directory.createOutput(fileName, context);){
            CodecUtil.writeIndexHeader(output, CODEC_NAME, 1, segmentInfo.getId(), segmentSuffix);
            output.writeVInt(infos.size());
            for (FieldInfo fi : infos) {
                fi.checkConsistency();
                output.writeString(fi.name);
                output.writeVInt(fi.number);
                byte bits2 = 0;
                if (fi.hasVectors()) {
                    bits2 = (byte)(bits2 | 1);
                }
                if (fi.omitsNorms()) {
                    bits2 = (byte)(bits2 | 2);
                }
                if (fi.hasPayloads()) {
                    bits2 = (byte)(bits2 | 4);
                }
                output.writeByte(bits2);
                output.writeByte(Lucene50FieldInfosFormat.indexOptionsByte(fi.getIndexOptions()));
                output.writeByte(Lucene50FieldInfosFormat.docValuesByte(fi.getDocValuesType()));
                output.writeLong(fi.getDocValuesGen());
                output.writeMapOfStrings(fi.attributes());
            }
            CodecUtil.writeFooter(output);
        }
    }

    static {
        boolean bl = $assertionsDisabled = !Lucene50FieldInfosFormat.class.desiredAssertionStatus();
        if (!$assertionsDisabled && DocValuesType.values().length != 6) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && IndexOptions.values().length != 5) {
            throw new AssertionError();
        }
    }
}

