/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.blocktree;

import java.io.IOException;
import java.io.PrintStream;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.blocktree.BlockTreeTermsReader;
import org.apache.lucene.codecs.blocktree.FieldReader;
import org.apache.lucene.codecs.blocktree.SegmentTermsEnumFrame;
import org.apache.lucene.codecs.blocktree.Stats;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Util;

final class SegmentTermsEnum
extends TermsEnum {
    IndexInput in;
    private SegmentTermsEnumFrame[] stack;
    private final SegmentTermsEnumFrame staticFrame;
    SegmentTermsEnumFrame currentFrame;
    boolean termExists;
    final FieldReader fr;
    private int targetBeforeCurrentLength;
    private final ByteArrayDataInput scratchReader = new ByteArrayDataInput();
    private int validIndexPrefix;
    private boolean eof;
    final BytesRefBuilder term = new BytesRefBuilder();
    private final FST.BytesReader fstReader;
    private FST.Arc<BytesRef>[] arcs = new FST.Arc[1];

    public SegmentTermsEnum(FieldReader fr) throws IOException {
        this.fr = fr;
        this.stack = new SegmentTermsEnumFrame[0];
        this.staticFrame = new SegmentTermsEnumFrame(this, -1);
        this.fstReader = fr.index == null ? null : fr.index.getBytesReader();
        for (int arcIdx = 0; arcIdx < this.arcs.length; ++arcIdx) {
            this.arcs[arcIdx] = new FST.Arc();
        }
        this.currentFrame = this.staticFrame;
        if (fr.index != null) {
            FST.Arc<BytesRef> arc = fr.index.getFirstArc(this.arcs[0]);
            assert (arc.isFinal());
        } else {
            Object arc = null;
        }
        this.validIndexPrefix = 0;
    }

    void initIndexInput() {
        if (this.in == null) {
            this.in = this.fr.parent.termsIn.clone();
        }
    }

    public Stats computeBlockStats() throws IOException {
        FST.Arc<BytesRef> arc;
        Stats stats = new Stats(this.fr.parent.segment, this.fr.fieldInfo.name);
        if (this.fr.index != null) {
            stats.indexNumBytes = this.fr.index.ramBytesUsed();
        }
        this.currentFrame = this.staticFrame;
        if (this.fr.index != null) {
            arc = this.fr.index.getFirstArc(this.arcs[0]);
            assert (arc.isFinal());
        } else {
            arc = null;
        }
        this.currentFrame = this.pushFrame(arc, this.fr.rootCode, 0);
        this.currentFrame.fpOrig = this.currentFrame.fp;
        this.currentFrame.loadBlock();
        this.validIndexPrefix = 0;
        stats.startBlock(this.currentFrame, !this.currentFrame.isLastInFloor);
        while (true) {
            if (this.currentFrame.nextEnt == this.currentFrame.entCount) {
                stats.endBlock(this.currentFrame);
                if (!this.currentFrame.isLastInFloor) {
                    this.currentFrame.loadNextFloorBlock();
                    stats.startBlock(this.currentFrame, true);
                } else {
                    if (this.currentFrame.ord == 0) break;
                    long lastFP = this.currentFrame.fpOrig;
                    this.currentFrame = this.stack[this.currentFrame.ord - 1];
                    assert (lastFP == this.currentFrame.lastSubFP);
                    continue;
                }
            }
            while (this.currentFrame.next()) {
                this.currentFrame = this.pushFrame(null, this.currentFrame.lastSubFP, this.term.length());
                this.currentFrame.fpOrig = this.currentFrame.fp;
                this.currentFrame.loadBlock();
                stats.startBlock(this.currentFrame, !this.currentFrame.isLastInFloor);
            }
            stats.term(this.term.get());
        }
        stats.finish();
        this.currentFrame = this.staticFrame;
        if (this.fr.index != null) {
            arc = this.fr.index.getFirstArc(this.arcs[0]);
            assert (arc.isFinal());
        } else {
            arc = null;
        }
        this.currentFrame = this.pushFrame(arc, this.fr.rootCode, 0);
        this.currentFrame.rewind();
        this.currentFrame.loadBlock();
        this.validIndexPrefix = 0;
        this.term.clear();
        return stats;
    }

    private SegmentTermsEnumFrame getFrame(int ord) throws IOException {
        if (ord >= this.stack.length) {
            SegmentTermsEnumFrame[] next2 = new SegmentTermsEnumFrame[ArrayUtil.oversize(1 + ord, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
            System.arraycopy(this.stack, 0, next2, 0, this.stack.length);
            for (int stackOrd = this.stack.length; stackOrd < next2.length; ++stackOrd) {
                next2[stackOrd] = new SegmentTermsEnumFrame(this, stackOrd);
            }
            this.stack = next2;
        }
        assert (this.stack[ord].ord == ord);
        return this.stack[ord];
    }

    private FST.Arc<BytesRef> getArc(int ord) {
        if (ord >= this.arcs.length) {
            FST.Arc[] next2 = new FST.Arc[ArrayUtil.oversize(1 + ord, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
            System.arraycopy(this.arcs, 0, next2, 0, this.arcs.length);
            for (int arcOrd = this.arcs.length; arcOrd < next2.length; ++arcOrd) {
                next2[arcOrd] = new FST.Arc();
            }
            this.arcs = next2;
        }
        return this.arcs[ord];
    }

    SegmentTermsEnumFrame pushFrame(FST.Arc<BytesRef> arc, BytesRef frameData, int length) throws IOException {
        this.scratchReader.reset(frameData.bytes, frameData.offset, frameData.length);
        long code2 = this.scratchReader.readVLong();
        long fpSeek = code2 >>> 2;
        SegmentTermsEnumFrame f2 = this.getFrame(1 + this.currentFrame.ord);
        f2.hasTermsOrig = f2.hasTerms = (code2 & 2L) != 0L;
        boolean bl = f2.isFloor = (code2 & 1L) != 0L;
        if (f2.isFloor) {
            f2.setFloorData(this.scratchReader, frameData);
        }
        this.pushFrame(arc, fpSeek, length);
        return f2;
    }

    SegmentTermsEnumFrame pushFrame(FST.Arc<BytesRef> arc, long fp, int length) throws IOException {
        SegmentTermsEnumFrame f2 = this.getFrame(1 + this.currentFrame.ord);
        f2.arc = arc;
        if (f2.fpOrig == fp && f2.nextEnt != -1) {
            if (f2.ord > this.targetBeforeCurrentLength) {
                f2.rewind();
            }
            assert (length == f2.prefix);
        } else {
            f2.nextEnt = -1;
            f2.prefix = length;
            f2.state.termBlockOrd = 0;
            f2.fpOrig = f2.fp = fp;
            f2.lastSubFP = -1L;
        }
        return f2;
    }

    private boolean clearEOF() {
        this.eof = false;
        return true;
    }

    private boolean setEOF() {
        this.eof = true;
        return true;
    }

    @Override
    public boolean seekExact(BytesRef target) throws IOException {
        int targetUpto;
        BytesRef output;
        FST.Arc<BytesRef> arc;
        if (this.fr.index == null) {
            throw new IllegalStateException("terms index was not loaded");
        }
        this.term.grow(1 + target.length);
        assert (this.clearEOF());
        this.targetBeforeCurrentLength = this.currentFrame.ord;
        if (this.currentFrame != this.staticFrame) {
            arc = this.arcs[0];
            assert (arc.isFinal());
            output = (BytesRef)arc.output;
            SegmentTermsEnumFrame lastFrame = this.stack[0];
            assert (this.validIndexPrefix <= this.term.length());
            int targetLimit = Math.min(target.length, this.validIndexPrefix);
            int cmp = 0;
            for (targetUpto = 0; targetUpto < targetLimit && (cmp = (this.term.byteAt(targetUpto) & 0xFF) - (target.bytes[target.offset + targetUpto] & 0xFF)) == 0; ++targetUpto) {
                arc = this.arcs[1 + targetUpto];
                assert (arc.label == (target.bytes[target.offset + targetUpto] & 0xFF)) : "arc.label=" + (char)arc.label + " targetLabel=" + (char)(target.bytes[target.offset + targetUpto] & 0xFF);
                if (arc.output != BlockTreeTermsReader.NO_OUTPUT) {
                    output = BlockTreeTermsReader.FST_OUTPUTS.add(output, (BytesRef)arc.output);
                }
                if (!arc.isFinal()) continue;
                lastFrame = this.stack[1 + lastFrame.ord];
            }
            if (cmp == 0) {
                int targetUptoMid = targetUpto;
                int targetLimit2 = Math.min(target.length, this.term.length());
                while (targetUpto < targetLimit2 && (cmp = (this.term.byteAt(targetUpto) & 0xFF) - (target.bytes[target.offset + targetUpto] & 0xFF)) == 0) {
                    ++targetUpto;
                }
                if (cmp == 0) {
                    cmp = this.term.length() - target.length;
                }
                targetUpto = targetUptoMid;
            }
            if (cmp < 0) {
                this.currentFrame = lastFrame;
            } else if (cmp > 0) {
                this.targetBeforeCurrentLength = lastFrame.ord;
                this.currentFrame = lastFrame;
                this.currentFrame.rewind();
            } else {
                assert (this.term.length() == target.length);
                if (this.termExists) {
                    return true;
                }
            }
        } else {
            this.targetBeforeCurrentLength = -1;
            arc = this.fr.index.getFirstArc(this.arcs[0]);
            assert (arc.isFinal());
            assert (arc.output != null);
            output = (BytesRef)arc.output;
            this.currentFrame = this.staticFrame;
            targetUpto = 0;
            this.currentFrame = this.pushFrame(arc, BlockTreeTermsReader.FST_OUTPUTS.add(output, (BytesRef)arc.nextFinalOutput), 0);
        }
        while (targetUpto < target.length) {
            int targetLabel = target.bytes[target.offset + targetUpto] & 0xFF;
            FST.Arc<BytesRef> nextArc = this.fr.index.findTargetArc(targetLabel, arc, this.getArc(1 + targetUpto), this.fstReader);
            if (nextArc == null) {
                this.validIndexPrefix = this.currentFrame.prefix;
                this.currentFrame.scanToFloorFrame(target);
                if (!this.currentFrame.hasTerms) {
                    this.termExists = false;
                    this.term.setByteAt(targetUpto, (byte)targetLabel);
                    this.term.setLength(1 + targetUpto);
                    return false;
                }
                this.currentFrame.loadBlock();
                TermsEnum.SeekStatus result2 = this.currentFrame.scanToTerm(target, true);
                return result2 == TermsEnum.SeekStatus.FOUND;
            }
            arc = nextArc;
            this.term.setByteAt(targetUpto, (byte)targetLabel);
            assert (arc.output != null);
            if (arc.output != BlockTreeTermsReader.NO_OUTPUT) {
                output = BlockTreeTermsReader.FST_OUTPUTS.add(output, (BytesRef)arc.output);
            }
            ++targetUpto;
            if (!arc.isFinal()) continue;
            this.currentFrame = this.pushFrame(arc, BlockTreeTermsReader.FST_OUTPUTS.add(output, (BytesRef)arc.nextFinalOutput), targetUpto);
        }
        this.validIndexPrefix = this.currentFrame.prefix;
        this.currentFrame.scanToFloorFrame(target);
        if (!this.currentFrame.hasTerms) {
            this.termExists = false;
            this.term.setLength(targetUpto);
            return false;
        }
        this.currentFrame.loadBlock();
        TermsEnum.SeekStatus result3 = this.currentFrame.scanToTerm(target, true);
        return result3 == TermsEnum.SeekStatus.FOUND;
    }

    @Override
    public TermsEnum.SeekStatus seekCeil(BytesRef target) throws IOException {
        int targetUpto;
        BytesRef output;
        FST.Arc<BytesRef> arc;
        if (this.fr.index == null) {
            throw new IllegalStateException("terms index was not loaded");
        }
        this.term.grow(1 + target.length);
        assert (this.clearEOF());
        this.targetBeforeCurrentLength = this.currentFrame.ord;
        if (this.currentFrame != this.staticFrame) {
            arc = this.arcs[0];
            assert (arc.isFinal());
            output = (BytesRef)arc.output;
            SegmentTermsEnumFrame lastFrame = this.stack[0];
            assert (this.validIndexPrefix <= this.term.length());
            int targetLimit = Math.min(target.length, this.validIndexPrefix);
            int cmp = 0;
            for (targetUpto = 0; targetUpto < targetLimit && (cmp = (this.term.byteAt(targetUpto) & 0xFF) - (target.bytes[target.offset + targetUpto] & 0xFF)) == 0; ++targetUpto) {
                arc = this.arcs[1 + targetUpto];
                assert (arc.label == (target.bytes[target.offset + targetUpto] & 0xFF)) : "arc.label=" + (char)arc.label + " targetLabel=" + (char)(target.bytes[target.offset + targetUpto] & 0xFF);
                if (arc.output != BlockTreeTermsReader.NO_OUTPUT) {
                    output = BlockTreeTermsReader.FST_OUTPUTS.add(output, (BytesRef)arc.output);
                }
                if (!arc.isFinal()) continue;
                lastFrame = this.stack[1 + lastFrame.ord];
            }
            if (cmp == 0) {
                int targetUptoMid = targetUpto;
                int targetLimit2 = Math.min(target.length, this.term.length());
                while (targetUpto < targetLimit2 && (cmp = (this.term.byteAt(targetUpto) & 0xFF) - (target.bytes[target.offset + targetUpto] & 0xFF)) == 0) {
                    ++targetUpto;
                }
                if (cmp == 0) {
                    cmp = this.term.length() - target.length;
                }
                targetUpto = targetUptoMid;
            }
            if (cmp < 0) {
                this.currentFrame = lastFrame;
            } else if (cmp > 0) {
                this.targetBeforeCurrentLength = 0;
                this.currentFrame = lastFrame;
                this.currentFrame.rewind();
            } else {
                assert (this.term.length() == target.length);
                if (this.termExists) {
                    return TermsEnum.SeekStatus.FOUND;
                }
            }
        } else {
            this.targetBeforeCurrentLength = -1;
            arc = this.fr.index.getFirstArc(this.arcs[0]);
            assert (arc.isFinal());
            assert (arc.output != null);
            output = (BytesRef)arc.output;
            this.currentFrame = this.staticFrame;
            targetUpto = 0;
            this.currentFrame = this.pushFrame(arc, BlockTreeTermsReader.FST_OUTPUTS.add(output, (BytesRef)arc.nextFinalOutput), 0);
        }
        while (targetUpto < target.length) {
            int targetLabel = target.bytes[target.offset + targetUpto] & 0xFF;
            FST.Arc<BytesRef> nextArc = this.fr.index.findTargetArc(targetLabel, arc, this.getArc(1 + targetUpto), this.fstReader);
            if (nextArc == null) {
                this.validIndexPrefix = this.currentFrame.prefix;
                this.currentFrame.scanToFloorFrame(target);
                this.currentFrame.loadBlock();
                TermsEnum.SeekStatus result2 = this.currentFrame.scanToTerm(target, false);
                if (result2 == TermsEnum.SeekStatus.END) {
                    this.term.copyBytes(target);
                    this.termExists = false;
                    if (this.next() != null) {
                        return TermsEnum.SeekStatus.NOT_FOUND;
                    }
                    return TermsEnum.SeekStatus.END;
                }
                return result2;
            }
            this.term.setByteAt(targetUpto, (byte)targetLabel);
            arc = nextArc;
            assert (arc.output != null);
            if (arc.output != BlockTreeTermsReader.NO_OUTPUT) {
                output = BlockTreeTermsReader.FST_OUTPUTS.add(output, (BytesRef)arc.output);
            }
            ++targetUpto;
            if (!arc.isFinal()) continue;
            this.currentFrame = this.pushFrame(arc, BlockTreeTermsReader.FST_OUTPUTS.add(output, (BytesRef)arc.nextFinalOutput), targetUpto);
        }
        this.validIndexPrefix = this.currentFrame.prefix;
        this.currentFrame.scanToFloorFrame(target);
        this.currentFrame.loadBlock();
        TermsEnum.SeekStatus result3 = this.currentFrame.scanToTerm(target, false);
        if (result3 == TermsEnum.SeekStatus.END) {
            this.term.copyBytes(target);
            this.termExists = false;
            if (this.next() != null) {
                return TermsEnum.SeekStatus.NOT_FOUND;
            }
            return TermsEnum.SeekStatus.END;
        }
        return result3;
    }

    private void printSeekState(PrintStream out) throws IOException {
        if (this.currentFrame == this.staticFrame) {
            out.println("  no prior seek");
        } else {
            out.println("  prior seek state:");
            int ord = 0;
            boolean isSeekFrame = true;
            while (true) {
                SegmentTermsEnumFrame f2 = this.getFrame(ord);
                assert (f2 != null);
                BytesRef prefix = new BytesRef(this.term.get().bytes, 0, f2.prefix);
                if (f2.nextEnt == -1) {
                    out.println("    frame " + (isSeekFrame ? "(seek)" : "(next)") + " ord=" + ord + " fp=" + f2.fp + (f2.isFloor ? " (fpOrig=" + f2.fpOrig + ")" : "") + " prefixLen=" + f2.prefix + " prefix=" + prefix + (f2.nextEnt == -1 ? "" : " (of " + f2.entCount + ")") + " hasTerms=" + f2.hasTerms + " isFloor=" + f2.isFloor + " code=" + ((f2.fp << 2) + (long)(f2.hasTerms ? 2 : 0) + (long)(f2.isFloor ? 1 : 0)) + " isLastInFloor=" + f2.isLastInFloor + " mdUpto=" + f2.metaDataUpto + " tbOrd=" + f2.getTermBlockOrd());
                } else {
                    out.println("    frame " + (isSeekFrame ? "(seek, loaded)" : "(next, loaded)") + " ord=" + ord + " fp=" + f2.fp + (f2.isFloor ? " (fpOrig=" + f2.fpOrig + ")" : "") + " prefixLen=" + f2.prefix + " prefix=" + prefix + " nextEnt=" + f2.nextEnt + (f2.nextEnt == -1 ? "" : " (of " + f2.entCount + ")") + " hasTerms=" + f2.hasTerms + " isFloor=" + f2.isFloor + " code=" + ((f2.fp << 2) + (long)(f2.hasTerms ? 2 : 0) + (long)(f2.isFloor ? 1 : 0)) + " lastSubFP=" + f2.lastSubFP + " isLastInFloor=" + f2.isLastInFloor + " mdUpto=" + f2.metaDataUpto + " tbOrd=" + f2.getTermBlockOrd());
                }
                if (this.fr.index != null) {
                    long code2;
                    ByteArrayDataInput reader;
                    long codeOrig;
                    assert (!isSeekFrame || f2.arc != null) : "isSeekFrame=" + isSeekFrame + " f.arc=" + f2.arc;
                    if (f2.prefix > 0 && isSeekFrame && f2.arc.label != (this.term.byteAt(f2.prefix - 1) & 0xFF)) {
                        out.println("      broken seek state: arc.label=" + (char)f2.arc.label + " vs term byte=" + (char)(this.term.byteAt(f2.prefix - 1) & 0xFF));
                        throw new RuntimeException("seek state is broken");
                    }
                    BytesRef output = Util.get(this.fr.index, prefix);
                    if (output == null) {
                        out.println("      broken seek state: prefix is not final in index");
                        throw new RuntimeException("seek state is broken");
                    }
                    if (isSeekFrame && !f2.isFloor && (codeOrig = (reader = new ByteArrayDataInput(output.bytes, output.offset, output.length)).readVLong()) != (code2 = f2.fp << 2 | (long)(f2.hasTerms ? 2 : 0) | (long)(f2.isFloor ? 1 : 0))) {
                        out.println("      broken seek state: output code=" + codeOrig + " doesn't match frame code=" + code2);
                        throw new RuntimeException("seek state is broken");
                    }
                }
                if (f2 == this.currentFrame) break;
                if (f2.prefix == this.validIndexPrefix) {
                    isSeekFrame = false;
                }
                ++ord;
            }
        }
    }

    @Override
    public BytesRef next() throws IOException {
        if (this.in == null) {
            FST.Arc<BytesRef> arc;
            if (this.fr.index != null) {
                arc = this.fr.index.getFirstArc(this.arcs[0]);
                assert (arc.isFinal());
            } else {
                arc = null;
            }
            this.currentFrame = this.pushFrame(arc, this.fr.rootCode, 0);
            this.currentFrame.loadBlock();
        }
        this.targetBeforeCurrentLength = this.currentFrame.ord;
        assert (!this.eof);
        if (this.currentFrame == this.staticFrame) {
            boolean result2 = this.seekExact(this.term.get());
            assert (result2);
        }
        while (this.currentFrame.nextEnt == this.currentFrame.entCount) {
            if (!this.currentFrame.isLastInFloor) {
                this.currentFrame.loadNextFloorBlock();
                break;
            }
            if (this.currentFrame.ord == 0) {
                assert (this.setEOF());
                this.term.clear();
                this.validIndexPrefix = 0;
                this.currentFrame.rewind();
                this.termExists = false;
                return null;
            }
            long lastFP = this.currentFrame.fpOrig;
            this.currentFrame = this.stack[this.currentFrame.ord - 1];
            if (this.currentFrame.nextEnt == -1 || this.currentFrame.lastSubFP != lastFP) {
                this.currentFrame.scanToFloorFrame(this.term.get());
                this.currentFrame.loadBlock();
                this.currentFrame.scanToSubBlock(lastFP);
            }
            this.validIndexPrefix = Math.min(this.validIndexPrefix, this.currentFrame.prefix);
        }
        while (this.currentFrame.next()) {
            this.currentFrame = this.pushFrame(null, this.currentFrame.lastSubFP, this.term.length());
            this.currentFrame.loadBlock();
        }
        return this.term.get();
    }

    @Override
    public BytesRef term() {
        assert (!this.eof);
        return this.term.get();
    }

    @Override
    public int docFreq() throws IOException {
        assert (!this.eof);
        this.currentFrame.decodeMetaData();
        return this.currentFrame.state.docFreq;
    }

    @Override
    public long totalTermFreq() throws IOException {
        assert (!this.eof);
        this.currentFrame.decodeMetaData();
        return this.currentFrame.state.totalTermFreq;
    }

    @Override
    public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
        assert (!this.eof);
        this.currentFrame.decodeMetaData();
        return this.fr.parent.postingsReader.postings(this.fr.fieldInfo, this.currentFrame.state, reuse, flags);
    }

    @Override
    public void seekExact(BytesRef target, TermState otherState) {
        assert (this.clearEOF());
        if (target.compareTo(this.term.get()) != 0 || !this.termExists) {
            assert (otherState != null && otherState instanceof BlockTermState);
            this.currentFrame = this.staticFrame;
            this.currentFrame.state.copyFrom(otherState);
            this.term.copyBytes(target);
            this.currentFrame.metaDataUpto = this.currentFrame.getTermBlockOrd();
            assert (this.currentFrame.metaDataUpto > 0);
            this.validIndexPrefix = 0;
        }
    }

    @Override
    public TermState termState() throws IOException {
        assert (!this.eof);
        this.currentFrame.decodeMetaData();
        TermState ts = this.currentFrame.state.clone();
        return ts;
    }

    @Override
    public void seekExact(long ord) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long ord() {
        throw new UnsupportedOperationException();
    }
}

