/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.lucene.codecs.TermVectorsReader;
import org.apache.lucene.index.DocIDMerger;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;

public abstract class TermVectorsWriter
implements Closeable {
    protected TermVectorsWriter() {
    }

    public abstract void startDocument(int var1) throws IOException;

    public void finishDocument() throws IOException {
    }

    public abstract void startField(FieldInfo var1, int var2, boolean var3, boolean var4, boolean var5) throws IOException;

    public void finishField() throws IOException {
    }

    public abstract void startTerm(BytesRef var1, int var2) throws IOException;

    public void finishTerm() throws IOException {
    }

    public abstract void addPosition(int var1, int var2, int var3, BytesRef var4) throws IOException;

    public abstract void finish(FieldInfos var1, int var2) throws IOException;

    public void addProx(int numProx, DataInput positions, DataInput offsets) throws IOException {
        int position2 = 0;
        int lastOffset = 0;
        BytesRefBuilder payload = null;
        for (int i = 0; i < numProx; ++i) {
            int startOffset;
            int endOffset;
            BytesRef thisPayload;
            if (positions == null) {
                position2 = -1;
                thisPayload = null;
            } else {
                int code2 = positions.readVInt();
                position2 += code2 >>> 1;
                if ((code2 & 1) != 0) {
                    int payloadLength = positions.readVInt();
                    if (payload == null) {
                        payload = new BytesRefBuilder();
                    }
                    payload.grow(payloadLength);
                    positions.readBytes(payload.bytes(), 0, payloadLength);
                    payload.setLength(payloadLength);
                    thisPayload = payload.get();
                } else {
                    thisPayload = null;
                }
            }
            if (offsets == null) {
                endOffset = -1;
                startOffset = -1;
            } else {
                startOffset = lastOffset + offsets.readVInt();
                lastOffset = endOffset = startOffset + offsets.readVInt();
            }
            this.addPosition(position2, startOffset, endOffset, thisPayload);
        }
    }

    public int merge(MergeState mergeState) throws IOException {
        TermVectorsMergeSub sub;
        ArrayList<TermVectorsMergeSub> subs = new ArrayList<TermVectorsMergeSub>();
        for (int i = 0; i < mergeState.termVectorsReaders.length; ++i) {
            TermVectorsReader reader = mergeState.termVectorsReaders[i];
            if (reader != null) {
                reader.checkIntegrity();
            }
            subs.add(new TermVectorsMergeSub(mergeState.docMaps[i], reader, mergeState.maxDocs[i]));
        }
        DocIDMerger docIDMerger = DocIDMerger.of(subs, mergeState.needsIndexSort);
        int docCount = 0;
        while ((sub = (TermVectorsMergeSub)docIDMerger.next()) != null) {
            Fields vectors = sub.reader == null ? null : sub.reader.get(sub.docID);
            this.addAllDocVectors(vectors, mergeState);
            ++docCount;
        }
        this.finish(mergeState.mergeFieldInfos, docCount);
        return docCount;
    }

    protected final void addAllDocVectors(Fields vectors, MergeState mergeState) throws IOException {
        if (vectors == null) {
            this.startDocument(0);
            this.finishDocument();
            return;
        }
        int numFields = vectors.size();
        if (numFields == -1) {
            numFields = 0;
            Iterator<String> it = vectors.iterator();
            while (it.hasNext()) {
                it.next();
                ++numFields;
            }
        }
        this.startDocument(numFields);
        String lastFieldName = null;
        TermsEnum termsEnum = null;
        PostingsEnum docsAndPositionsEnum = null;
        int fieldCount = 0;
        for (String fieldName : vectors) {
            ++fieldCount;
            FieldInfo fieldInfo = mergeState.mergeFieldInfos.fieldInfo(fieldName);
            assert (lastFieldName == null || fieldName.compareTo(lastFieldName) > 0) : "lastFieldName=" + lastFieldName + " fieldName=" + fieldName;
            lastFieldName = fieldName;
            Terms terms = vectors.terms(fieldName);
            if (terms == null) continue;
            boolean hasPositions = terms.hasPositions();
            boolean hasOffsets = terms.hasOffsets();
            boolean hasPayloads = terms.hasPayloads();
            assert (!hasPayloads || hasPositions);
            int numTerms = (int)terms.size();
            if (numTerms == -1) {
                numTerms = 0;
                termsEnum = terms.iterator();
                while (termsEnum.next() != null) {
                    ++numTerms;
                }
            }
            this.startField(fieldInfo, numTerms, hasPositions, hasOffsets, hasPayloads);
            termsEnum = terms.iterator();
            int termCount = 0;
            while (termsEnum.next() != null) {
                ++termCount;
                int freq2 = (int)termsEnum.totalTermFreq();
                this.startTerm(termsEnum.term(), freq2);
                if (hasPositions || hasOffsets) {
                    docsAndPositionsEnum = termsEnum.postings(docsAndPositionsEnum, 120);
                    assert (docsAndPositionsEnum != null);
                    int docID = docsAndPositionsEnum.nextDoc();
                    assert (docID != Integer.MAX_VALUE);
                    assert (docsAndPositionsEnum.freq() == freq2);
                    for (int posUpto = 0; posUpto < freq2; ++posUpto) {
                        int pos = docsAndPositionsEnum.nextPosition();
                        int startOffset = docsAndPositionsEnum.startOffset();
                        int endOffset = docsAndPositionsEnum.endOffset();
                        BytesRef payload = docsAndPositionsEnum.getPayload();
                        assert (!hasPositions || pos >= 0);
                        this.addPosition(pos, startOffset, endOffset, payload);
                    }
                }
                this.finishTerm();
            }
            assert (termCount == numTerms);
            this.finishField();
        }
        assert (fieldCount == numFields);
        this.finishDocument();
    }

    @Override
    public abstract void close() throws IOException;

    private static class TermVectorsMergeSub
    extends DocIDMerger.Sub {
        private final TermVectorsReader reader;
        private final int maxDoc;
        int docID = -1;

        public TermVectorsMergeSub(MergeState.DocMap docMap, TermVectorsReader reader, int maxDoc) {
            super(docMap);
            this.maxDoc = maxDoc;
            this.reader = reader;
        }

        @Override
        public int nextDoc() {
            ++this.docID;
            if (this.docID == this.maxDoc) {
                return Integer.MAX_VALUE;
            }
            return this.docID;
        }
    }
}

