/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs;

import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;

public class LegacyDocValuesIterables {
    private LegacyDocValuesIterables() {
    }

    @Deprecated
    public static Iterable<BytesRef> valuesIterable(final SortedDocValues values2) {
        return new Iterable<BytesRef>(){

            @Override
            public Iterator<BytesRef> iterator() {
                return new Iterator<BytesRef>(){
                    private int nextOrd;

                    @Override
                    public boolean hasNext() {
                        return this.nextOrd < values2.getValueCount();
                    }

                    @Override
                    public BytesRef next() {
                        try {
                            return values2.lookupOrd(this.nextOrd++);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
            }
        };
    }

    @Deprecated
    public static Iterable<BytesRef> valuesIterable(final SortedSetDocValues values2) {
        return new Iterable<BytesRef>(){

            @Override
            public Iterator<BytesRef> iterator() {
                return new Iterator<BytesRef>(){
                    private long nextOrd;

                    @Override
                    public boolean hasNext() {
                        return this.nextOrd < values2.getValueCount();
                    }

                    @Override
                    public BytesRef next() {
                        try {
                            return values2.lookupOrd(this.nextOrd++);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
            }
        };
    }

    @Deprecated
    public static Iterable<Number> sortedOrdIterable(final DocValuesProducer valuesProducer, final FieldInfo fieldInfo, final int maxDoc) {
        return new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                SortedDocValues values2;
                try {
                    values2 = valuesProducer.getSorted(fieldInfo);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
                return new Iterator<Number>(){
                    private int nextDocID;

                    @Override
                    public boolean hasNext() {
                        return this.nextDocID < maxDoc;
                    }

                    @Override
                    public Number next() {
                        try {
                            if (this.nextDocID > values2.docID()) {
                                values2.nextDoc();
                            }
                            int result2 = this.nextDocID == values2.docID() ? values2.ordValue() : -1;
                            ++this.nextDocID;
                            return result2;
                        }
                        catch (IOException ioe) {
                            throw new RuntimeException(ioe);
                        }
                    }
                };
            }
        };
    }

    @Deprecated
    public static Iterable<Number> sortedSetOrdCountIterable(final DocValuesProducer valuesProducer, final FieldInfo fieldInfo, final int maxDoc) {
        return new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                SortedSetDocValues values2;
                try {
                    values2 = valuesProducer.getSortedSet(fieldInfo);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
                return new Iterator<Number>(){
                    private int nextDocID;
                    private int ordCount;

                    @Override
                    public boolean hasNext() {
                        return this.nextDocID < maxDoc;
                    }

                    @Override
                    public Number next() {
                        try {
                            if (this.nextDocID > values2.docID() && values2.nextDoc() != Integer.MAX_VALUE) {
                                this.ordCount = 0;
                                while (values2.nextOrd() != -1L) {
                                    ++this.ordCount;
                                }
                            }
                            int result2 = this.nextDocID == values2.docID() ? this.ordCount : 0;
                            ++this.nextDocID;
                            return result2;
                        }
                        catch (IOException ioe) {
                            throw new RuntimeException(ioe);
                        }
                    }
                };
            }
        };
    }

    @Deprecated
    public static Iterable<Number> sortedSetOrdsIterable(final DocValuesProducer valuesProducer, final FieldInfo fieldInfo) {
        return new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                SortedSetDocValues values2;
                try {
                    values2 = valuesProducer.getSortedSet(fieldInfo);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
                return new Iterator<Number>(){
                    private boolean nextIsSet;
                    private long nextOrd;

                    private void setNext() {
                        try {
                            if (!this.nextIsSet) {
                                if (values2.docID() == -1) {
                                    values2.nextDoc();
                                }
                                while (true) {
                                    if (values2.docID() == Integer.MAX_VALUE) {
                                        this.nextOrd = -1L;
                                        break;
                                    }
                                    this.nextOrd = values2.nextOrd();
                                    if (this.nextOrd != -1L) break;
                                    values2.nextDoc();
                                }
                                this.nextIsSet = true;
                            }
                        }
                        catch (IOException ioe) {
                            throw new RuntimeException(ioe);
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        this.setNext();
                        return this.nextOrd != -1L;
                    }

                    @Override
                    public Number next() {
                        this.setNext();
                        assert (this.nextOrd != -1L);
                        this.nextIsSet = false;
                        return this.nextOrd;
                    }
                };
            }
        };
    }

    @Deprecated
    public static Iterable<Number> sortedNumericToDocCount(final DocValuesProducer valuesProducer, final FieldInfo fieldInfo, final int maxDoc) {
        return new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                SortedNumericDocValues values2;
                try {
                    values2 = valuesProducer.getSortedNumeric(fieldInfo);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
                return new Iterator<Number>(){
                    private int nextDocID;

                    @Override
                    public boolean hasNext() {
                        return this.nextDocID < maxDoc;
                    }

                    @Override
                    public Number next() {
                        try {
                            if (this.nextDocID > values2.docID()) {
                                values2.nextDoc();
                            }
                            int result2 = this.nextDocID == values2.docID() ? values2.docValueCount() : 0;
                            ++this.nextDocID;
                            return result2;
                        }
                        catch (IOException ioe) {
                            throw new RuntimeException(ioe);
                        }
                    }
                };
            }
        };
    }

    @Deprecated
    public static Iterable<Number> sortedNumericToValues(final DocValuesProducer valuesProducer, final FieldInfo fieldInfo) {
        return new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                SortedNumericDocValues values2;
                try {
                    values2 = valuesProducer.getSortedNumeric(fieldInfo);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
                return new Iterator<Number>(){
                    private boolean nextIsSet;
                    private int nextCount;
                    private int upto;
                    private long nextValue;

                    private void setNext() {
                        try {
                            if (!this.nextIsSet) {
                                if (this.upto == this.nextCount) {
                                    values2.nextDoc();
                                    if (values2.docID() == Integer.MAX_VALUE) {
                                        this.nextCount = 0;
                                        this.nextIsSet = false;
                                        return;
                                    }
                                    this.nextCount = values2.docValueCount();
                                    this.upto = 0;
                                }
                                this.nextValue = values2.nextValue();
                                ++this.upto;
                                this.nextIsSet = true;
                            }
                        }
                        catch (IOException ioe) {
                            throw new RuntimeException(ioe);
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        this.setNext();
                        return this.nextCount != 0;
                    }

                    @Override
                    public Number next() {
                        this.setNext();
                        assert (this.nextCount != 0);
                        this.nextIsSet = false;
                        return this.nextValue;
                    }
                };
            }
        };
    }

    @Deprecated
    public static Iterable<Number> normsIterable(final FieldInfo field2, final NormsProducer normsProducer, final int maxDoc) {
        return new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                NumericDocValues values2;
                try {
                    values2 = normsProducer.getNorms(field2);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
                return new Iterator<Number>(){
                    private int docIDUpto = -1;

                    @Override
                    public boolean hasNext() {
                        return this.docIDUpto + 1 < maxDoc;
                    }

                    @Override
                    public Number next() {
                        Number result2;
                        ++this.docIDUpto;
                        if (this.docIDUpto > values2.docID()) {
                            try {
                                values2.nextDoc();
                            }
                            catch (IOException ioe) {
                                throw new RuntimeException(ioe);
                            }
                        }
                        if (this.docIDUpto == values2.docID()) {
                            try {
                                result2 = values2.longValue();
                            }
                            catch (IOException ioe) {
                                throw new RuntimeException(ioe);
                            }
                        } else {
                            result2 = 0;
                        }
                        return result2;
                    }
                };
            }
        };
    }

    @Deprecated
    public static Iterable<BytesRef> binaryIterable(final FieldInfo field2, final DocValuesProducer valuesProducer, final int maxDoc) {
        return new Iterable<BytesRef>(){

            @Override
            public Iterator<BytesRef> iterator() {
                BinaryDocValues values2;
                try {
                    values2 = valuesProducer.getBinary(field2);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
                return new Iterator<BytesRef>(){
                    private int docIDUpto = -1;

                    @Override
                    public boolean hasNext() {
                        return this.docIDUpto + 1 < maxDoc;
                    }

                    @Override
                    public BytesRef next() {
                        BytesRef result2;
                        ++this.docIDUpto;
                        if (this.docIDUpto > values2.docID()) {
                            try {
                                values2.nextDoc();
                            }
                            catch (IOException ioe) {
                                throw new RuntimeException(ioe);
                            }
                        }
                        if (this.docIDUpto == values2.docID()) {
                            try {
                                result2 = values2.binaryValue();
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        } else {
                            result2 = null;
                        }
                        return result2;
                    }
                };
            }
        };
    }

    @Deprecated
    public static Iterable<Number> numericIterable(final FieldInfo field2, final DocValuesProducer valuesProducer, final int maxDoc) {
        return new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                NumericDocValues values2;
                try {
                    values2 = valuesProducer.getNumeric(field2);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
                return new Iterator<Number>(){
                    private int docIDUpto = -1;

                    @Override
                    public boolean hasNext() {
                        return this.docIDUpto + 1 < maxDoc;
                    }

                    @Override
                    public Number next() {
                        Long result2;
                        ++this.docIDUpto;
                        if (this.docIDUpto > values2.docID()) {
                            try {
                                values2.nextDoc();
                            }
                            catch (IOException ioe) {
                                throw new RuntimeException(ioe);
                            }
                        }
                        if (this.docIDUpto == values2.docID()) {
                            try {
                                result2 = values2.longValue();
                            }
                            catch (IOException ioe) {
                                throw new RuntimeException(ioe);
                            }
                        } else {
                            result2 = null;
                        }
                        return result2;
                    }
                };
            }
        };
    }
}

