/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.wikipedia;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.analysis.wikipedia.WikipediaTokenizer;
import org.apache.lucene.util.AttributeFactory;

public class WikipediaTokenizerFactory
extends TokenizerFactory {
    public static final String TOKEN_OUTPUT = "tokenOutput";
    public static final String UNTOKENIZED_TYPES = "untokenizedTypes";
    protected final int tokenOutput;
    protected Set<String> untokenizedTypes;

    public WikipediaTokenizerFactory(Map<String, String> args2) {
        super(args2);
        this.tokenOutput = this.getInt(args2, TOKEN_OUTPUT, 0);
        this.untokenizedTypes = this.getSet(args2, UNTOKENIZED_TYPES);
        if (this.untokenizedTypes == null) {
            this.untokenizedTypes = Collections.emptySet();
        }
        if (!args2.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args2);
        }
    }

    @Override
    public WikipediaTokenizer create(AttributeFactory factory) {
        return new WikipediaTokenizer(factory, this.tokenOutput, this.untokenizedTypes);
    }
}

