/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.util;

import org.apache.lucene.util.Bits;
import org.apache.lucene.util.SparseFixedBitSet;

public final class UnicodeProps {
    public static final String UNICODE_VERSION = "10.0.0.0";
    public static final Bits WHITESPACE = UnicodeProps.createBits(9, 10, 11, 12, 13, 32, 133, 160, 5760, 8192, 8193, 8194, 8195, 8196, 8197, 8198, 8199, 8200, 8201, 8202, 8232, 8233, 8239, 8287, 12288);

    private UnicodeProps() {
    }

    private static Bits createBits(int ... codepoints) {
        final int len = codepoints[codepoints.length - 1] + 1;
        final SparseFixedBitSet bitset = new SparseFixedBitSet(len);
        for (int i : codepoints) {
            bitset.set(i);
        }
        return new Bits(){

            @Override
            public boolean get(int index2) {
                return index2 < len && bitset.get(index2);
            }

            @Override
            public int length() {
                return 0x110000;
            }
        };
    }
}

