/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.Version;

public abstract class AbstractAnalysisFactory {
    public static final String LUCENE_MATCH_VERSION_PARAM = "luceneMatchVersion";
    private final Map<String, String> originalArgs;
    protected final Version luceneMatchVersion;
    private boolean isExplicitLuceneMatchVersion = false;
    private static final Pattern ITEM_PATTERN = Pattern.compile("[^,\\s]+");
    private static final String CLASS_NAME = "class";

    protected AbstractAnalysisFactory(Map<String, String> args2) {
        this.originalArgs = Collections.unmodifiableMap(new HashMap<String, String>(args2));
        String version = this.get(args2, LUCENE_MATCH_VERSION_PARAM);
        if (version == null) {
            this.luceneMatchVersion = Version.LATEST;
        } else {
            try {
                this.luceneMatchVersion = Version.parseLeniently(version);
            }
            catch (ParseException pe) {
                throw new IllegalArgumentException(pe);
            }
        }
        args2.remove(CLASS_NAME);
    }

    public final Map<String, String> getOriginalArgs() {
        return this.originalArgs;
    }

    public final Version getLuceneMatchVersion() {
        return this.luceneMatchVersion;
    }

    public String require(Map<String, String> args2, String name) {
        String s2 = args2.remove(name);
        if (s2 == null) {
            throw new IllegalArgumentException("Configuration Error: missing parameter '" + name + "'");
        }
        return s2;
    }

    public String require(Map<String, String> args2, String name, Collection<String> allowedValues) {
        return this.require(args2, name, allowedValues, true);
    }

    public String require(Map<String, String> args2, String name, Collection<String> allowedValues, boolean caseSensitive) {
        String s2 = args2.remove(name);
        if (s2 == null) {
            throw new IllegalArgumentException("Configuration Error: missing parameter '" + name + "'");
        }
        for (String allowedValue : allowedValues) {
            if (!(caseSensitive ? s2.equals(allowedValue) : s2.equalsIgnoreCase(allowedValue))) continue;
            return s2;
        }
        throw new IllegalArgumentException("Configuration Error: '" + name + "' value must be one of " + allowedValues);
    }

    public String get(Map<String, String> args2, String name) {
        return args2.remove(name);
    }

    public String get(Map<String, String> args2, String name, String defaultVal) {
        String s2 = args2.remove(name);
        return s2 == null ? defaultVal : s2;
    }

    public String get(Map<String, String> args2, String name, Collection<String> allowedValues) {
        return this.get(args2, name, allowedValues, null);
    }

    public String get(Map<String, String> args2, String name, Collection<String> allowedValues, String defaultVal) {
        return this.get(args2, name, allowedValues, defaultVal, true);
    }

    public String get(Map<String, String> args2, String name, Collection<String> allowedValues, String defaultVal, boolean caseSensitive) {
        String s2 = args2.remove(name);
        if (s2 == null) {
            return defaultVal;
        }
        for (String allowedValue : allowedValues) {
            if (!(caseSensitive ? s2.equals(allowedValue) : s2.equalsIgnoreCase(allowedValue))) continue;
            return s2;
        }
        throw new IllegalArgumentException("Configuration Error: '" + name + "' value must be one of " + allowedValues);
    }

    protected final int requireInt(Map<String, String> args2, String name) {
        return Integer.parseInt(this.require(args2, name));
    }

    protected final int getInt(Map<String, String> args2, String name, int defaultVal) {
        String s2 = args2.remove(name);
        return s2 == null ? defaultVal : Integer.parseInt(s2);
    }

    protected final boolean requireBoolean(Map<String, String> args2, String name) {
        return Boolean.parseBoolean(this.require(args2, name));
    }

    protected final boolean getBoolean(Map<String, String> args2, String name, boolean defaultVal) {
        String s2 = args2.remove(name);
        return s2 == null ? defaultVal : Boolean.parseBoolean(s2);
    }

    protected final float requireFloat(Map<String, String> args2, String name) {
        return Float.parseFloat(this.require(args2, name));
    }

    protected final float getFloat(Map<String, String> args2, String name, float defaultVal) {
        String s2 = args2.remove(name);
        return s2 == null ? defaultVal : Float.parseFloat(s2);
    }

    public char requireChar(Map<String, String> args2, String name) {
        return this.require(args2, name).charAt(0);
    }

    public char getChar(Map<String, String> args2, String name, char defaultValue2) {
        String s2 = args2.remove(name);
        if (s2 == null) {
            return defaultValue2;
        }
        if (s2.length() != 1) {
            throw new IllegalArgumentException(name + " should be a char. \"" + s2 + "\" is invalid");
        }
        return s2.charAt(0);
    }

    public Set<String> getSet(Map<String, String> args2, String name) {
        String s2 = args2.remove(name);
        if (s2 == null) {
            return null;
        }
        HashSet<String> set = null;
        Matcher matcher2 = ITEM_PATTERN.matcher(s2);
        if (matcher2.find()) {
            set = new HashSet<String>();
            set.add(matcher2.group(0));
            while (matcher2.find()) {
                set.add(matcher2.group(0));
            }
        }
        return set;
    }

    protected final Pattern getPattern(Map<String, String> args2, String name) {
        try {
            return Pattern.compile(this.require(args2, name));
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Configuration Error: '" + name + "' can not be parsed in " + this.getClass().getSimpleName(), e);
        }
    }

    protected final CharArraySet getWordSet(ResourceLoader loader, String wordFiles, boolean ignoreCase) throws IOException {
        List<String> files2 = this.splitFileNames(wordFiles);
        CharArraySet words2 = null;
        if (files2.size() > 0) {
            words2 = new CharArraySet(files2.size() * 10, ignoreCase);
            for (String file : files2) {
                List<String> wlist = this.getLines(loader, file.trim());
                words2.addAll(StopFilter.makeStopSet(wlist, ignoreCase));
            }
        }
        return words2;
    }

    protected final List<String> getLines(ResourceLoader loader, String resource) throws IOException {
        return WordlistLoader.getLines(loader.openResource(resource), StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final CharArraySet getSnowballWordSet(ResourceLoader loader, String wordFiles, boolean ignoreCase) throws IOException {
        List<String> files2 = this.splitFileNames(wordFiles);
        CharArraySet words2 = null;
        if (files2.size() > 0) {
            words2 = new CharArraySet(files2.size() * 10, ignoreCase);
            for (String file : files2) {
                InputStream stream = null;
                InputStreamReader reader = null;
                try {
                    stream = loader.openResource(file.trim());
                    CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
                    reader = new InputStreamReader(stream, decoder);
                    WordlistLoader.getSnowballWordSet(reader, words2);
                }
                catch (Throwable throwable2) {
                    IOUtils.closeWhileHandlingException(reader, stream);
                    throw throwable2;
                }
                IOUtils.closeWhileHandlingException(reader, stream);
            }
        }
        return words2;
    }

    protected final List<String> splitFileNames(String fileNames) {
        return this.splitAt(',', fileNames);
    }

    protected final List<String> splitAt(char separator, String list2) {
        if (list2 == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result2 = new ArrayList<String>();
        for (String item : list2.split("(?<!\\\\)[" + separator + "]")) {
            result2.add(item.replaceAll("\\\\(?=[" + separator + "])", ""));
        }
        return result2;
    }

    public String getClassArg() {
        String className;
        if (null != this.originalArgs && null != (className = this.originalArgs.get(CLASS_NAME))) {
            return className;
        }
        return this.getClass().getName();
    }

    public boolean isExplicitLuceneMatchVersion() {
        return this.isExplicitLuceneMatchVersion;
    }

    public void setExplicitLuceneMatchVersion(boolean isExplicitLuceneMatchVersion) {
        this.isExplicitLuceneMatchVersion = isExplicitLuceneMatchVersion;
    }
}

