/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.shingle;

import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.shingle.ShingleFilter;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class ShingleFilterFactory
extends TokenFilterFactory {
    private final int minShingleSize;
    private final int maxShingleSize;
    private final boolean outputUnigrams;
    private final boolean outputUnigramsIfNoShingles;
    private final String tokenSeparator;
    private final String fillerToken;

    public ShingleFilterFactory(Map<String, String> args2) {
        super(args2);
        this.maxShingleSize = this.getInt(args2, "maxShingleSize", 2);
        if (this.maxShingleSize < 2) {
            throw new IllegalArgumentException("Invalid maxShingleSize (" + this.maxShingleSize + ") - must be at least 2");
        }
        this.minShingleSize = this.getInt(args2, "minShingleSize", 2);
        if (this.minShingleSize < 2) {
            throw new IllegalArgumentException("Invalid minShingleSize (" + this.minShingleSize + ") - must be at least 2");
        }
        if (this.minShingleSize > this.maxShingleSize) {
            throw new IllegalArgumentException("Invalid minShingleSize (" + this.minShingleSize + ") - must be no greater than maxShingleSize (" + this.maxShingleSize + ")");
        }
        this.outputUnigrams = this.getBoolean(args2, "outputUnigrams", true);
        this.outputUnigramsIfNoShingles = this.getBoolean(args2, "outputUnigramsIfNoShingles", false);
        this.tokenSeparator = this.get(args2, "tokenSeparator", " ");
        this.fillerToken = this.get(args2, "fillerToken", "_");
        if (!args2.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args2);
        }
    }

    @Override
    public ShingleFilter create(TokenStream input2) {
        ShingleFilter r = new ShingleFilter(input2, this.minShingleSize, this.maxShingleSize);
        r.setOutputUnigrams(this.outputUnigrams);
        r.setOutputUnigramsIfNoShingles(this.outputUnigramsIfNoShingles);
        r.setTokenSeparator(this.tokenSeparator);
        r.setFillerToken(this.fillerToken);
        return r;
    }
}

