/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.pattern;

import java.util.Map;
import org.apache.lucene.analysis.pattern.SimplePatternTokenizer;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.util.AttributeFactory;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.RegExp;

public class SimplePatternTokenizerFactory
extends TokenizerFactory {
    public static final String PATTERN = "pattern";
    private final Automaton dfa;
    private final int maxDeterminizedStates;

    public SimplePatternTokenizerFactory(Map<String, String> args2) {
        super(args2);
        this.maxDeterminizedStates = this.getInt(args2, "maxDeterminizedStates", 10000);
        this.dfa = Operations.determinize(new RegExp(this.require(args2, PATTERN)).toAutomaton(), this.maxDeterminizedStates);
        if (!args2.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args2);
        }
    }

    @Override
    public SimplePatternTokenizer create(AttributeFactory factory) {
        return new SimplePatternTokenizer(factory, this.dfa);
    }
}

