/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.path;

import java.util.Map;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.path.PathHierarchyTokenizer;
import org.apache.lucene.analysis.path.ReversePathHierarchyTokenizer;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.util.AttributeFactory;

public class PathHierarchyTokenizerFactory
extends TokenizerFactory {
    private final char delimiter;
    private final char replacement;
    private final boolean reverse;
    private final int skip;

    public PathHierarchyTokenizerFactory(Map<String, String> args2) {
        super(args2);
        this.delimiter = this.getChar(args2, "delimiter", '/');
        this.replacement = this.getChar(args2, "replace", this.delimiter);
        this.reverse = this.getBoolean(args2, "reverse", false);
        this.skip = this.getInt(args2, "skip", 0);
        if (!args2.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args2);
        }
    }

    @Override
    public Tokenizer create(AttributeFactory factory) {
        if (this.reverse) {
            return new ReversePathHierarchyTokenizer(factory, this.delimiter, this.replacement, this.skip);
        }
        return new PathHierarchyTokenizer(factory, this.delimiter, this.replacement, this.skip);
    }
}

