/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ngram;

import java.util.Map;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ngram.NGramTokenFilter;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class NGramFilterFactory
extends TokenFilterFactory {
    private final int maxGramSize;
    private final int minGramSize;
    private final boolean preserveOriginal;

    public NGramFilterFactory(Map<String, String> args2) {
        super(args2);
        this.minGramSize = this.getInt(args2, "minGramSize", 1);
        this.maxGramSize = this.getInt(args2, "maxGramSize", 2);
        this.preserveOriginal = this.getBoolean(args2, "keepShortTerm", false);
        if (!args2.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args2);
        }
    }

    @Override
    public TokenFilter create(TokenStream input2) {
        return new NGramTokenFilter(input2, this.minGramSize, this.maxGramSize, this.preserveOriginal);
    }
}

