/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ngram;

import java.util.Map;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenizer;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.util.AttributeFactory;

public class EdgeNGramTokenizerFactory
extends TokenizerFactory {
    private final int maxGramSize;
    private final int minGramSize;

    public EdgeNGramTokenizerFactory(Map<String, String> args2) {
        super(args2);
        this.minGramSize = this.getInt(args2, "minGramSize", 1);
        this.maxGramSize = this.getInt(args2, "maxGramSize", 1);
        if (!args2.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args2);
        }
    }

    @Override
    public Tokenizer create(AttributeFactory factory) {
        return new EdgeNGramTokenizer(factory, this.minGramSize, this.maxGramSize);
    }
}

